package io.burkard.cdk.services.amplifyuibuilder

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ComponentChildProperty {

  def apply(
    name: String,
    componentType: String,
    properties: software.amazon.awscdk.services.amplifyuibuilder.CfnComponent.ComponentPropertiesProperty,
    children: Option[List[_]] = None
  ): software.amazon.awscdk.services.amplifyuibuilder.CfnComponent.ComponentChildProperty =
    (new software.amazon.awscdk.services.amplifyuibuilder.CfnComponent.ComponentChildProperty.Builder)
      .name(name)
      .componentType(componentType)
      .properties(properties)
      .children(children.map(_.asJava).orNull)
      .build()
}
