package io.burkard.cdk.services.amplifyuibuilder

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ComponentDataConfigurationProperty {

  def apply(
    model: String,
    sort: Option[List[_]] = None,
    predicate: Option[software.amazon.awscdk.services.amplifyuibuilder.CfnComponent.PredicateProperty] = None,
    identifiers: Option[List[String]] = None
  ): software.amazon.awscdk.services.amplifyuibuilder.CfnComponent.ComponentDataConfigurationProperty =
    (new software.amazon.awscdk.services.amplifyuibuilder.CfnComponent.ComponentDataConfigurationProperty.Builder)
      .model(model)
      .sort(sort.map(_.asJava).orNull)
      .predicate(predicate.orNull)
      .identifiers(identifiers.map(_.asJava).orNull)
      .build()
}
