package io.burkard.cdk.services.amazonmq

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object UserProperty {

  def apply(
    password: String,
    username: String,
    groups: Option[List[String]] = None,
    consoleAccess: Option[Boolean] = None
  ): software.amazon.awscdk.services.amazonmq.CfnBroker.UserProperty =
    (new software.amazon.awscdk.services.amazonmq.CfnBroker.UserProperty.Builder)
      .password(password)
      .username(username)
      .groups(groups.map(_.asJava).orNull)
      .consoleAccess(consoleAccess.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .build()
}
