/*
 * Decompiled with CFR 0.152.
 */
package io.bullet.spliff;

import io.bullet.spliff.Diff;
import io.bullet.spliff.Diff$;
import io.bullet.spliff.Diff$Chunk$Distinct$;
import io.bullet.spliff.Diff$Chunk$InBase$;
import io.bullet.spliff.Diff$Chunk$InBoth$;
import io.bullet.spliff.Diff$Chunk$InTarget$;
import io.bullet.spliff.Diff$Op$;
import io.bullet.spliff.Diff$Op$Delete$;
import io.bullet.spliff.Diff$Op$Insert$;
import io.bullet.spliff.Diff$Op$Move$;
import io.bullet.spliff.Diff$Op$Replace$;
import io.bullet.spliff.Diff$Patch$;
import io.bullet.spliff.Diff$Patch$Insert$;
import io.bullet.spliff.util.IntArrayStack;
import io.bullet.spliff.util.SimpleBitSet;
import io.bullet.spliff.util.SimpleBitSet$;
import java.io.Serializable;
import java.util.Arrays;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IndexedSeqView;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.ArraySeq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.mutable.Builder;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Try;
import scala.util.Try$;

public abstract class Diff<T> {
    public static <T> Diff<T> apply(IndexedSeq<T> indexedSeq, IndexedSeq<T> indexedSeq2, Eq<T> eq) {
        return Diff$.MODULE$.apply(indexedSeq, indexedSeq2, eq);
    }

    public static <T> ArraySeq<T> longestCommonSubsequence(IndexedSeq<T> indexedSeq, IndexedSeq<T> indexedSeq2, Eq<T> eq, ClassTag<T> classTag) {
        return Diff$.MODULE$.longestCommonSubsequence(indexedSeq, indexedSeq2, eq, classTag);
    }

    public static <T> int minEditDistance(IndexedSeq<T> indexedSeq, IndexedSeq<T> indexedSeq2, Eq<T> eq) {
        return Diff$.MODULE$.minEditDistance(indexedSeq, indexedSeq2, eq);
    }

    public abstract IndexedSeq<T> base();

    public abstract IndexedSeq<T> target();

    public abstract ArraySeq<Op.Delete> deletes();

    public abstract ArraySeq<Op.Insert> inserts();

    public abstract ArraySeq<Op.DelIns> delInsOps();

    public abstract ArraySeq<Op.DelIns> delInsOpsSorted();

    public abstract ArraySeq<Op.DelInsMov> delInsMovOps();

    public abstract ArraySeq<Op.DelInsMov> delInsMovOpsSorted();

    public abstract ArraySeq<Op> allOps();

    public abstract Patch<T> patch(ClassTag<T> var1);

    public abstract ArraySeq<Chunk<T>> chunks();

    public abstract Bimap basicBimap();

    public abstract Bimap bimap();

    public static interface Bimap {
        public Option<Object> baseToTargetIndex(int var1);

        public Option<Object> targetToBaseIndex(int var1);
    }

    public static interface Chunk<T> {
    }

    public static interface Eq<T> {
        public boolean apply(T var1, T var2);
    }

    private static final class Impl<T>
    extends Diff<T> {
        private final IndexedSeq base;
        private final IndexedSeq target;
        private final ArraySeq deletes;
        private final ArraySeq inserts;
        private final Eq<T> eq;

        public <T> Impl(IndexedSeq<T> base, IndexedSeq<T> target, ArraySeq<Op.Delete> deletes, ArraySeq<Op.Insert> inserts, Eq<T> eq) {
            this.base = base;
            this.target = target;
            this.deletes = deletes;
            this.inserts = inserts;
            this.eq = eq;
        }

        @Override
        public IndexedSeq<T> base() {
            return this.base;
        }

        @Override
        public IndexedSeq<T> target() {
            return this.target;
        }

        @Override
        public ArraySeq<Op.Delete> deletes() {
            return this.deletes;
        }

        @Override
        public ArraySeq<Op.Insert> inserts() {
            return this.inserts;
        }

        @Override
        public ArraySeq<Op.DelIns> delInsOps() {
            Op.Delete[] deletes = (Op.Delete[])this.deletes().unsafeArray();
            Op.Insert[] inserts = (Op.Insert[])this.inserts().unsafeArray();
            Op.DelIns[] result = new Op.DelIns[deletes.length + inserts.length];
            System.arraycopy(deletes, 0, result, 0, deletes.length);
            System.arraycopy(inserts, 0, result, deletes.length, inserts.length);
            return ArraySeq$.MODULE$.unsafeWrapArray((Object)result);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ArraySeq<Op.DelIns> delInsOpsSorted() {
            void var1_1;
            ArraySeq result = this.delInsOps().sorted(Diff$Op$.MODULE$.ordering());
            Op.DelIns[] array = (Op.DelIns[])result.unsafeArray();
            Arrays.sort(array, Diff$Op$.MODULE$.ordering());
            return var1_1;
        }

        @Override
        public ArraySeq<Op.DelInsMov> delInsMovOps() {
            Object object;
            Op.Delete[] deletes = (Op.Delete[])this.deletes().unsafeArray();
            Op.Insert[] inserts = (Op.Insert[])this.inserts().unsafeArray();
            if (deletes.length > 0 && inserts.length > 0) {
                Op.DelInsMov[] result = new Op.DelInsMov[deletes.length + inserts.length];
                SimpleBitSet pairedInserts = SimpleBitSet$.MODULE$.withSize(inserts.length);
                object = ArraySeq$.MODULE$.unsafeWrapArray((Object)this.rec$1(deletes, inserts, result, pairedInserts, 0, 0, 0));
            } else {
                object = deletes.length > 0 ? this.deletes() : this.inserts();
            }
            return object;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ArraySeq<Op.DelInsMov> delInsMovOpsSorted() {
            void var1_1;
            ArraySeq result = this.delInsMovOps().sorted(Diff$Op$.MODULE$.ordering());
            Op.DelInsMov[] array = (Op.DelInsMov[])result.unsafeArray();
            Arrays.sort(array, Diff$Op$.MODULE$.ordering());
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ArraySeq<Op> allOps() {
            void var1_1;
            Op[] result;
            ArraySeq<Op.DelInsMov> dimOps = this.delInsMovOpsSorted();
            Op.DelInsMov[] dimArray = (Op.DelInsMov[])dimOps.unsafeArray();
            int ir = this.rec$2(dimArray, result = new Op[dimArray.length], 0, 0, null);
            return ir < result.length ? ArraySeq$.MODULE$.unsafeWrapArray((Object)Arrays.copyOf(result, ir)) : var1_1;
        }

        @Override
        public Bimap basicBimap() {
            Op.DelIns[] delIns = (Op.DelIns[])this.delInsOpsSorted().unsafeArray();
            int[] bttMap = new int[this.base().size()];
            int[] ttbMap = new int[this.target().size()];
            this.rec$3(delIns, bttMap, ttbMap, 0, 0, 0);
            return new BimapImpl(bttMap, ttbMap);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Bimap bimap() {
            void var1_1;
            BimapImpl bmap = (BimapImpl)this.basicBimap();
            this.delInsMovOps().foreach((Function1 & Serializable)x$1 -> {
                this.bimap$$anonfun$1(bmap, (Op.DelInsMov)x$1);
                return BoxedUnit.UNIT;
            });
            return var1_1;
        }

        @Override
        public ArraySeq<Chunk<T>> chunks() {
            Builder buf = ArraySeq$.MODULE$.newBuilder(ClassTag$.MODULE$.apply(Chunk.class));
            Op.Delete[] deletes = (Op.Delete[])this.deletes().unsafeArray();
            Op.Insert[] inserts = (Op.Insert[])this.inserts().unsafeArray();
            return this.rec$4(buf, deletes, inserts, 0, 0, 0, 0, null);
        }

        @Override
        public Patch<T> patch(ClassTag<T> ct) {
            ArraySeq steps = this.delInsMovOps().map((Function1 & Serializable)x$1 -> {
                Patch.Insert insert;
                Op.DelInsMov delInsMov = x$1;
                if (delInsMov instanceof Op.Insert) {
                    Op.Insert insert2 = Diff$Op$Insert$.MODULE$.unapply((Op.Insert)delInsMov);
                    int n = insert2._1();
                    int n2 = insert2._2();
                    int n3 = insert2._3();
                    int baseIx = n;
                    int targetIx = n2;
                    int count = n3;
                    Object values = Arrays$.MODULE$.newGenericArray(count, ct);
                    insert = Diff$Patch$Insert$.MODULE$.apply(baseIx, ArraySeq$.MODULE$.unsafeWrapArray(this.rec$6(targetIx, values, 0)));
                } else if (delInsMov instanceof Patch.Step) {
                    Op.DelInsMov x = (Op.DelInsMov)((Object)((Patch.Step)((Object)delInsMov)));
                    insert = (Patch.Insert)((Object)x);
                } else {
                    throw new MatchError((Object)delInsMov);
                }
                return insert;
            });
            return Diff$Patch$.MODULE$.apply(this.base().size(), this.target().size(), steps);
        }

        private final boolean doMatch$1(Op.Delete del$1, Op.Insert ins$1, int i) {
            boolean bl;
            block3: {
                block2: {
                    for (int j = i; j != del$1.count(); ++j) {
                        if (this.eq.apply(this.base().apply(del$1.baseIx() + j), this.target().apply(ins$1.targetIx() + j))) {
                            continue;
                        }
                        break block2;
                    }
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            return bl;
        }

        private final int appendUnpairedInserts$1(Op.Insert[] inserts$5, Op.DelInsMov[] result$2, SimpleBitSet pairedInserts$2, int ii, int ir) {
            int n = ir;
            int n2 = ii;
            while (n2 < inserts$5.length) {
                if (pairedInserts$2.contains(n2)) {
                    ++n2;
                    continue;
                }
                int n3 = n2 + 1;
                int n4 = Diff$.MODULE$.io$bullet$spliff$Diff$$$setAndGetNextIndex(result$2, n, inserts$5[n2]);
                n2 = n3;
                n = n4;
            }
            return n;
        }

        private final Op.DelInsMov[] rec$1(Op.Delete[] deletes$4, Op.Insert[] inserts$4, Op.DelInsMov[] result$1, SimpleBitSet pairedInserts$1, int delIx, int insIx, int resIx) {
            int n = resIx;
            int n2 = insIx;
            int n3 = delIx;
            while (n3 < deletes$4.length) {
                Op.Delete del = deletes$4[n3];
                Op.Insert ins = inserts$4[n2];
                if (del.count() == ins.count() && !pairedInserts$1.contains(n2) && this.doMatch$1(del, ins, 0)) {
                    pairedInserts$1.$plus$eq(n2);
                    int n4 = n3 + 1;
                    int n5 = 0;
                    int n6 = Diff$.MODULE$.io$bullet$spliff$Diff$$$setAndGetNextIndex(result$1, n, Diff$Op$Move$.MODULE$.apply(del.baseIx(), ins.baseIx(), del.count()));
                    n3 = n4;
                    n2 = n5;
                    n = n6;
                    continue;
                }
                if (n2 + 1 == inserts$4.length) {
                    int n7 = n3 + 1;
                    int n8 = 0;
                    int n9 = Diff$.MODULE$.io$bullet$spliff$Diff$$$setAndGetNextIndex(result$1, n, del);
                    n3 = n7;
                    n2 = n8;
                    n = n9;
                    continue;
                }
                ++n2;
            }
            int endIr = this.appendUnpairedInserts$1(inserts$4, result$1, pairedInserts$1, 0, n);
            return endIr < result$1.length ? Arrays.copyOfRange(result$1, 0, endIr) : result$1;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        private final int rec$2(Op.DelInsMov[] dimArray$1, Op[] result$3, int dimIx, int resIx, Op last) {
            var6_6 = last;
            var7_7 = resIx;
            var8_8 = dimIx;
            while (var8_8 < dimArray$1.length) {
                op = dimArray$1[var8_8];
                ir1 = var7_7;
                var13_13 = (Op)Predef$.MODULE$.ArrowAssoc((Object)var6_6);
                var12_12 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)var13_13, (Object)op);
                if (var12_12 == null) ** GOTO lbl-1000
                var14_14 = (Op)var12_12._1();
                var15_15 = (Op.DelInsMov)var12_12._2();
                if (!(var14_14 instanceof Op.Delete)) ** GOTO lbl-1000
                var16_16 = Diff$Op$Delete$.MODULE$.unapply((Op.Delete)var14_14);
                var17_17 = var16_16._1();
                var18_18 = var16_16._2();
                delBaseIx = var17_17;
                delCnt = var18_18;
                if (!(var15_15 instanceof Op.Insert)) ** GOTO lbl-1000
                var21_21 = Diff$Op$Insert$.MODULE$.unapply((Op.Insert)var15_15);
                var22_22 = var21_21._1();
                var23_23 = var21_21._2();
                var24_24 = var21_21._3();
                insBaseIx = var22_22;
                targetIx = var23_23;
                insCnt = var24_24;
                if (delBaseIx == insBaseIx) {
                    ir1 = var7_7 - 1;
                    v0 /* !! */  = Diff$Op$Replace$.MODULE$.apply(delBaseIx, delCnt, targetIx, insCnt);
                } else lbl-1000:
                // 4 sources

                {
                    v0 /* !! */  = op;
                }
                next = v0 /* !! */ ;
                result$3[ir1] = next;
                var28_28 = var8_8 + 1;
                var29_29 = ir1 + 1;
                var30_30 = next;
                var8_8 = var28_28;
                var7_7 = var29_29;
                var6_6 = var30_30;
            }
            return var7_7;
        }

        private final int mapUp$1(int[] bttMap$1, int[] ttbMap$1, int baseCursor, int targetCursor, int baseEnd) {
            int n = targetCursor;
            int n2 = baseCursor;
            while (n2 < baseEnd) {
                bttMap$1[n2] = n;
                ttbMap$1[n] = n2;
                int n3 = n2 + 1;
                int n4 = n + 1;
                n2 = n3;
                n = n4;
            }
            return n;
        }

        private final void rec$3(Op.DelIns[] delIns$1, int[] bttMap$2, int[] ttbMap$2, int delInsIx, int baseCursor, int targetCursor) {
            int n = targetCursor;
            int n2 = baseCursor;
            int n3 = delInsIx;
            while (n3 < delIns$1.length) {
                Op.DelIns op = delIns$1[n3];
                int newTargetCursor = this.mapUp$1(bttMap$2, ttbMap$2, n2, n, op.baseIx());
                Op.DelIns delIns = op;
                if (delIns instanceof Op.Delete) {
                    Op.Delete delete = Diff$Op$Delete$.MODULE$.unapply((Op.Delete)delIns);
                    int n4 = delete._1();
                    int n5 = delete._2();
                    int baseIx = n4;
                    int count = n5;
                    Arrays.fill(bttMap$2, baseIx, baseIx + count, -1);
                    int n6 = n3 + 1;
                    int n7 = baseIx + count;
                    int n8 = newTargetCursor;
                    n3 = n6;
                    n2 = n7;
                    n = n8;
                    continue;
                }
                if (delIns instanceof Op.Insert) {
                    Op.Insert insert = Diff$Op$Insert$.MODULE$.unapply((Op.Insert)delIns);
                    int n9 = insert._1();
                    int n10 = insert._2();
                    int n11 = insert._3();
                    int baseIx = n9;
                    int targetIx = n10;
                    int count = n11;
                    if (newTargetCursor != targetIx) {
                        throw new IllegalStateException();
                    }
                    Arrays.fill(ttbMap$2, targetIx, targetIx + count, -1);
                    int n12 = n3 + 1;
                    int n13 = scala.math.package$.MODULE$.max(n2, baseIx);
                    int n14 = targetIx + count;
                    n3 = n12;
                    n2 = n13;
                    n = n14;
                    continue;
                }
                throw new MatchError((Object)delIns);
            }
            this.mapUp$1(bttMap$2, ttbMap$2, n2, n, bttMap$2.length);
        }

        private final void rec$5(BimapImpl bmap$1, int baseCursor, int targetCursor, int count) {
            int n = count;
            int n2 = targetCursor;
            int n3 = baseCursor;
            while (n > 0) {
                bmap$1.bttMap()[n3] = n2;
                bmap$1.ttbMap()[n2] = n3;
                int n4 = n3 + 1;
                int n5 = n2 + 1;
                int n6 = n - 1;
                n3 = n4;
                n2 = n5;
                n = n6;
            }
        }

        private final /* synthetic */ void bimap$$anonfun$1(BimapImpl bmap$2, Op.DelInsMov x$1) {
            block0: {
                Op.DelInsMov delInsMov = x$1;
                if (!(delInsMov instanceof Op.Move)) break block0;
                Op.Move move = Diff$Op$Move$.MODULE$.unapply((Op.Move)delInsMov);
                int n = move._1();
                int n2 = move._2();
                int n3 = move._3();
                int baseIx = n;
                int targetIx = n2;
                int count = n3;
                this.rec$5(bmap$2, baseIx, targetIx, count);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private final Chunk append$1(Builder buf$2, Chunk last, Chunk next) {
            Chunk.Distinct distinct;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)last, next);
            if (tuple2 != null) {
                Chunk chunk = (Chunk)tuple2._1();
                Chunk chunk2 = (Chunk)tuple2._2();
                if (chunk == null) {
                    distinct = next;
                    return distinct;
                }
                if (chunk instanceof Chunk.InBase) {
                    Slice slice;
                    Chunk.InBase inBase = Diff$Chunk$InBase$.MODULE$.unapply((Chunk.InBase)chunk);
                    Slice a = slice = inBase._1();
                    if (chunk2 instanceof Chunk.InTarget) {
                        Slice slice2;
                        Chunk.InTarget inTarget = Diff$Chunk$InTarget$.MODULE$.unapply((Chunk.InTarget)chunk2);
                        Slice b = slice2 = inTarget._1();
                        distinct = Diff$Chunk$Distinct$.MODULE$.apply(a, b);
                        return distinct;
                    }
                }
                if (chunk instanceof Chunk.InTarget) {
                    Slice slice;
                    Chunk.InTarget inTarget = Diff$Chunk$InTarget$.MODULE$.unapply((Chunk.InTarget)chunk);
                    Slice b = slice = inTarget._1();
                    if (chunk2 instanceof Chunk.InBase) {
                        Slice slice3;
                        Chunk.InBase inBase = Diff$Chunk$InBase$.MODULE$.unapply((Chunk.InBase)chunk2);
                        Slice a = slice3 = inBase._1();
                        distinct = Diff$Chunk$Distinct$.MODULE$.apply(a, b);
                        return distinct;
                    }
                }
                if (chunk instanceof Chunk.Distinct) {
                    Chunk.Distinct distinct2 = Diff$Chunk$Distinct$.MODULE$.unapply((Chunk.Distinct)chunk);
                    Slice slice = distinct2._1();
                    Slice slice4 = distinct2._2();
                    Slice a = slice;
                    Slice b = slice4;
                    if (chunk2 instanceof Chunk.InBase) {
                        Slice slice5;
                        Chunk.InBase inBase = Diff$Chunk$InBase$.MODULE$.unapply((Chunk.InBase)chunk2);
                        Slice c = slice5 = inBase._1();
                        distinct = Diff$Chunk$Distinct$.MODULE$.apply(a.merge(c), b);
                        return distinct;
                    }
                    Slice a2 = slice;
                    Slice b2 = slice4;
                    if (chunk2 instanceof Chunk.InTarget) {
                        Slice slice6;
                        Chunk.InTarget inTarget = Diff$Chunk$InTarget$.MODULE$.unapply((Chunk.InTarget)chunk2);
                        Slice c = slice6 = inTarget._1();
                        distinct = Diff$Chunk$Distinct$.MODULE$.apply(a2, b2.merge(c));
                        return distinct;
                    }
                }
            }
            buf$2.$plus$eq((Object)last);
            distinct = next;
            return distinct;
        }

        private final Chunk lastAfterUnchanged$1(Builder buf$3, int cb$tailLocal1$1, int ct$tailLocal1$1, Chunk last$tailLocal2$1, int baseIx) {
            return cb$tailLocal1$1 < baseIx ? this.append$1(buf$3, last$tailLocal2$1, Diff$Chunk$InBoth$.MODULE$.apply(new Slice<T>(this.base(), cb$tailLocal1$1, baseIx), new Slice<T>(this.target(), ct$tailLocal1$1, ct$tailLocal1$1 + baseIx - cb$tailLocal1$1))) : last$tailLocal2$1;
        }

        private final ArraySeq rec$4(Builder buf$4, Op.Delete[] deletes$5, Op.Insert[] inserts$6, int delIx, int insIx, int cb, int ct, Chunk last) {
            int n = insIx;
            Chunk chunk = last;
            int n2 = ct;
            int n3 = cb;
            int n4 = delIx;
            while (true) {
                Op.Insert ins;
                Op.Delete del = n4 < deletes$5.length ? deletes$5[n4] : null;
                Op.Insert insert = ins = n < inserts$6.length ? inserts$6[n] : null;
                if (del != null && (ins == null || del.baseIx() <= ins.baseIx())) {
                    Chunk.InBase<T> deleted = Diff$Chunk$InBase$.MODULE$.apply(new Slice<T>(this.base(), del.baseIx(), del.baseIx() + del.count()));
                    Chunk newLast = this.append$1(buf$4, this.lastAfterUnchanged$1(buf$4, n3, n2, chunk, del.baseIx()), deleted);
                    int n5 = n4 + 1;
                    int n6 = del.baseIx() + del.count();
                    int n7 = del.baseIx() > n3 ? n2 + del.baseIx() - n3 : n2;
                    Chunk chunk2 = newLast;
                    n4 = n5;
                    n3 = n6;
                    n2 = n7;
                    chunk = chunk2;
                    continue;
                }
                if (ins == null) break;
                Chunk.InTarget<T> inserted = Diff$Chunk$InTarget$.MODULE$.apply(new Slice<T>(this.target(), ins.targetIx(), ins.targetIx() + ins.count()));
                Chunk newLast = this.append$1(buf$4, this.lastAfterUnchanged$1(buf$4, n3, n2, chunk, ins.baseIx()), inserted);
                int n8 = n + 1;
                int n9 = scala.math.package$.MODULE$.max(n3, ins.baseIx());
                int n10 = ins.targetIx() + ins.count();
                Chunk chunk3 = newLast;
                n = n8;
                n3 = n9;
                n2 = n10;
                chunk = chunk3;
            }
            return (ArraySeq)((Builder)buf$4.addOne((Object)this.lastAfterUnchanged$1(buf$4, n3, n2, chunk, this.base().size()))).result();
        }

        private final Object rec$6(int targetIx$1, Object values$1, int i) {
            int n = i;
            while (n < ScalaRunTime$.MODULE$.array_length(values$1)) {
                n = Diff$.MODULE$.io$bullet$spliff$Diff$$$setAndGetNextIndex(values$1, n, this.target().apply(targetIx$1 + n));
            }
            return values$1;
        }

        private final class BimapImpl
        implements Bimap {
            private final int[] bttMap;
            private final int[] ttbMap;

            public BimapImpl(int[] bttMap, int[] ttbMap) {
                this.bttMap = bttMap;
                this.ttbMap = ttbMap;
            }

            public int[] bttMap() {
                return this.bttMap;
            }

            public int[] ttbMap() {
                return this.ttbMap;
            }

            @Override
            public Option<Object> baseToTargetIndex(int ix) {
                return this.getFrom(this.bttMap(), ix);
            }

            @Override
            public Option<Object> targetToBaseIndex(int ix) {
                return this.getFrom(this.ttbMap(), ix);
            }

            private Option<Object> getFrom(int[] array, int ix) {
                None$ none$;
                if (0 <= ix && ix < array.length) {
                    int n = array[ix];
                    if (-1 == n) {
                        none$ = None$.MODULE$;
                    } else {
                        int x = n;
                        none$ = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)x));
                    }
                } else {
                    none$ = None$.MODULE$;
                }
                return none$;
            }
        }
    }

    private static final class Myers
    extends IntArrayStack {
        private int _lastDelBaseIx = -1;
        private int _lastDelCount;
        private int _lastInsBaseIx = -1;
        private int _lastInsTargetIx;
        private int _lastInsCount;

        public Myers() {
            super(64);
        }

        public <T> Diff<T> diff(IndexedSeq<T> base, IndexedSeq<T> target, Eq<T> eq) {
            Builder deletes = ArraySeq$.MODULE$.newBuilder(ClassTag$.MODULE$.apply(Op.Delete.class));
            Builder inserts = ArraySeq$.MODULE$.newBuilder(ClassTag$.MODULE$.apply(Op.Insert.class));
            Myers stack = this;
            stack.push4(0, base.size(), 0, target.size());
            while (stack.nonEmpty()) {
                this.rec$1(base, target, eq, deletes, inserts, stack);
            }
            this.flushLastOps$1(deletes, inserts);
            return new Impl<T>(base, target, (ArraySeq<Op.Delete>)((ArraySeq)deletes.result()), (ArraySeq<Op.Insert>)((ArraySeq)inserts.result()), eq);
        }

        private final void appendCollapsingDelete$1(Builder deletes$1, int baseIx, int count) {
            if (baseIx != this._lastDelBaseIx + this._lastDelCount) {
                if (this._lastDelBaseIx >= 0) {
                    deletes$1.$plus$eq((Object)Diff$Op$Delete$.MODULE$.apply(this._lastDelBaseIx, this._lastDelCount));
                }
                this._lastDelBaseIx = baseIx;
                this._lastDelCount = count;
            } else {
                this._lastDelCount += count;
            }
        }

        private final void appendCollapsingInsert$1(Builder inserts$1, int baseIx, int targetIx, int count) {
            if (baseIx != this._lastInsBaseIx || targetIx != this._lastInsTargetIx + this._lastInsCount) {
                if (this._lastInsBaseIx >= 0) {
                    inserts$1.$plus$eq((Object)Diff$Op$Insert$.MODULE$.apply(this._lastInsBaseIx, this._lastInsTargetIx, this._lastInsCount));
                }
                this._lastInsBaseIx = baseIx;
                this._lastInsTargetIx = targetIx;
                this._lastInsCount = count;
            } else {
                this._lastInsCount += count;
            }
        }

        private final void flushLastOps$1(Builder deletes$2, Builder inserts$2) {
            if (this._lastDelBaseIx >= 0) {
                deletes$2.$plus$eq((Object)Diff$Op$Delete$.MODULE$.apply(this._lastDelBaseIx, this._lastDelCount));
            }
            if (this._lastInsBaseIx >= 0) {
                inserts$2.$plus$eq((Object)Diff$Op$Insert$.MODULE$.apply(this._lastInsBaseIx, this._lastInsTargetIx, this._lastInsCount));
            }
        }

        private final void rec$1(IndexedSeq base$2, IndexedSeq target$1, Eq eq$1, Builder deletes$3, Builder inserts$3, IntArrayStack stack$1) {
            int M = stack$1.pop();
            int j = stack$1.pop();
            int N = stack$1.pop();
            int i = stack$1.pop();
            int L = N + M;
            int Z = 2 * Math.min(N, M) + 2;
            int modL2 = Math.floorMod(L, 2);
            if (N > 0 && M > 0) {
                int w = N - M;
                int[] g = new int[Z];
                int[] p = new int[Z];
                int hLimit = L / 2 + modL2 + 1;
                for (int h = 0; h < hLimit; ++h) {
                    int[] c = g;
                    int[] d = p;
                    int o = 1;
                    int m = 1;
                    int ii0 = i;
                    int jj0 = j;
                    while (o >= 0) {
                        int kLimit = h - 2 * Math.max(0, h - N) + 1;
                        for (int k = -(h - 2 * Math.max(0, h - M)); k < kLimit; k += 2) {
                            Object object;
                            int mkz0 = Math.floorMod(k - 1, Z);
                            int mkz1 = Math.floorMod(k + 1, Z);
                            int a = k == -h || k != h && c[mkz0] < c[mkz1] ? c[mkz1] : c[mkz0] + 1;
                            int b = a - k;
                            int s = a;
                            int t = b;
                            int ii = ii0 + m * a;
                            int jj = jj0 + m * b;
                            while (a < N && b < M && eq$1.apply(base$2.apply(ii), target$1.apply(jj))) {
                                ++a;
                                ++b;
                                ii += m;
                                jj += m;
                            }
                            int modKZ = Math.floorMod(k, Z);
                            c[modKZ] = a;
                            int z = -(k - w);
                            if (modL2 != o || z < -(h - o) || z > h - o || c[modKZ] + d[Math.floorMod(z, Z)] < N) continue;
                            int _D = 2 * h - o;
                            int x = s;
                            int y = t;
                            int u = a;
                            int v = b;
                            if (o == 0) {
                                x = N - a;
                                y = M - b;
                                u = N - s;
                                v = M - t;
                            }
                            if (_D > 1 || x != u && y != v) {
                                stack$1.push4(i + u, N - u, j + v, M - v);
                                object = stack$1.push4(i, x, j, y);
                            } else if (M > N) {
                                object = stack$1.push4(i + N, 0, j + N, M - N);
                            } else if (M < N) {
                                stack$1.push4(i + M, w, j + M, 0);
                                object = BoxedUnit.UNIT;
                            } else {
                                object = BoxedUnit.UNIT;
                            }
                            return;
                        }
                        c = p;
                        d = g;
                        --o;
                        m = -1;
                        ii0 += N - 1;
                        jj0 += M - 1;
                    }
                }
                throw Diff$.MODULE$.io$bullet$spliff$Diff$$$failDiff();
            }
            if (N > 0) {
                this.appendCollapsingDelete$1(deletes$3, i, N);
            } else if (M > 0) {
                this.appendCollapsingInsert$1(inserts$3, i, j, M);
            }
        }
    }

    public static interface Op {
        public int baseIx();
    }

    public static final class Patch<T>
    implements Product,
    Serializable {
        private final int baseSize;
        private final int targetSize;
        private final ArraySeq steps;

        public static Diff$Op$Delete$ Delete() {
            return Diff$Patch$.MODULE$.Delete();
        }

        public static Diff$Op$Move$ Move() {
            return Diff$Patch$.MODULE$.Move();
        }

        public static Patch fromProduct(Product product) {
            return Diff$Patch$.MODULE$.fromProduct(product);
        }

        public static Ordering ordering() {
            return Diff$Patch$.MODULE$.ordering();
        }

        public static <T> Patch<T> unapply(Patch<T> patch) {
            return Diff$Patch$.MODULE$.unapply(patch);
        }

        public <T> Patch(int baseSize, int targetSize, ArraySeq<Step<T>> steps) {
            this.baseSize = baseSize;
            this.targetSize = targetSize;
            this.steps = steps;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.baseSize());
            n = Statics.mix((int)n, (int)this.targetSize());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.steps()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Patch)) return false;
            Patch patch = (Patch)object;
            if (this.baseSize() != patch.baseSize()) return false;
            if (this.targetSize() != patch.targetSize()) return false;
            ArraySeq<Step<T>> arraySeq = this.steps();
            ArraySeq<Step<T>> arraySeq2 = patch.steps();
            if (arraySeq != null) {
                if (!arraySeq.equals(arraySeq2)) return false;
                return true;
            }
            if (arraySeq2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Patch;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Patch";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = BoxesRunTime.boxToInteger((int)this._1());
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToInteger((int)this._2());
                    break;
                }
                case 2: {
                    object = this._3();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "baseSize";
                    break;
                }
                case 1: {
                    string = "targetSize";
                    break;
                }
                case 2: {
                    string = "steps";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public int baseSize() {
            return this.baseSize;
        }

        public int targetSize() {
            return this.targetSize;
        }

        public ArraySeq<Step<T>> steps() {
            return this.steps;
        }

        public Patch<T> sorted() {
            ArraySeq arraySeq = this.steps().sorted(Diff$Patch$.MODULE$.ordering());
            int n = this.copy$default$1();
            int n2 = this.copy$default$2();
            return this.copy(n, n2, arraySeq);
        }

        public Either<Failure, ArraySeq<T>> apply(IndexedSeq<T> base, ClassTag<T> ct) {
            Left left;
            try {
                left = package$.MODULE$.Right().apply(this.throwingApply(base, ct));
            }
            catch (Failure e) {
                left = package$.MODULE$.Left().apply((Object)e);
            }
            return left;
        }

        public Try<ArraySeq<T>> tryApply(IndexedSeq<T> base, ClassTag<T> ct) {
            return Try$.MODULE$.apply(() -> this.tryApply$$anonfun$1(base, ct));
        }

        public ArraySeq<T> throwingApply(IndexedSeq<T> base, ClassTag<T> ct) {
            return Diff$.MODULE$.io$bullet$spliff$Diff$$$applyPatch(base, this.baseSize(), this.targetSize(), this.steps(), ct);
        }

        public <T> Patch<T> copy(int baseSize, int targetSize, ArraySeq<Step<T>> steps) {
            return new Patch<T>(baseSize, targetSize, steps);
        }

        public int copy$default$1() {
            return this.baseSize();
        }

        public int copy$default$2() {
            return this.targetSize();
        }

        public <T> ArraySeq<Step<T>> copy$default$3() {
            return this.steps();
        }

        public int _1() {
            return this.baseSize();
        }

        public int _2() {
            return this.targetSize();
        }

        public ArraySeq<Step<T>> _3() {
            return this.steps();
        }

        private final ArraySeq tryApply$$anonfun$1(IndexedSeq base$1, ClassTag ct$1) {
            return this.throwingApply(base$1, ct$1);
        }

        public static abstract class Failure
        extends RuntimeException {
            public Failure(String msg) {
                super(msg);
            }
        }
    }

    public static final class Slice<T>
    extends IndexedSeqView.Slice<T> {
        private final IndexedSeq underlying;

        public <T> Slice(IndexedSeq<T> underlying, int _from, int _until) {
            this.underlying = underlying;
            super(underlying, _from, _until);
        }

        public IndexedSeq<T> underlying() {
            return this.underlying;
        }

        public int from() {
            return this.lo();
        }

        public int until() {
            return this.hi();
        }

        public Slice<T> merge(Slice<T> that) {
            Slice<T> slice;
            if (this.until() == that.from()) {
                slice = new Slice<T>(this.underlying(), this.from(), that.until());
            } else if (that.until() == this.from()) {
                slice = new Slice<T>(this.underlying(), that.from(), this.until());
            } else {
                throw new IllegalArgumentException();
            }
            return slice;
        }
    }
}

