/*
 * Decompiled with CFR 0.152.
 */
package io.bullet.spliff;

import io.bullet.spliff.Diff;
import io.bullet.spliff.Diff$Chunk$;
import io.bullet.spliff.Diff$Eq$;
import io.bullet.spliff.Diff$Op$;
import io.bullet.spliff.Diff$Patch$;
import io.bullet.spliff.Diff$Patch$BaseSizeMismatch$;
import io.bullet.spliff.Diff$Patch$Insert$;
import io.bullet.spliff.Diff$Patch$IntegrityFailure$;
import io.bullet.spliff.Diff$Slice$;
import io.bullet.spliff.util.IntArrayStack;
import java.io.Serializable;
import java.util.Arrays;
import scala.MatchError;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.ArraySeq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.mutable.Builder;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.runtime.Arrays$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public final class Diff$
implements Serializable {
    public static final Diff$Op$ Op;
    public static final Diff$Patch$ Patch;
    public static final Diff$Chunk$ Chunk;
    public static final Diff$Slice$ Slice;
    public static final Diff$Eq$ Eq;
    public static final Diff$ MODULE$;

    private Diff$() {
    }

    static {
        MODULE$ = new Diff$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Diff$.class);
    }

    public <T> Diff<T> apply(IndexedSeq<T> base, IndexedSeq<T> target, Diff.Eq<T> evidence$1) {
        return new Diff.Myers().diff(base, target, evidence$1);
    }

    public <T> ArraySeq<T> longestCommonSubsequence(IndexedSeq<T> base, IndexedSeq<T> target, Diff.Eq<T> evidence$2, ClassTag<T> evidence$3) {
        ArraySeq arraySeq;
        if (base.nonEmpty() && target.nonEmpty()) {
            Builder buf = ArraySeq$.MODULE$.newBuilder(evidence$3);
            IntArrayStack stack = new IntArrayStack(64);
            stack.push4(0, base.size(), 0, target.size());
            while (stack.nonEmpty()) {
                int M = stack.pop();
                int j = stack.pop();
                int N = stack.pop();
                int i = stack.pop();
                if (j >= 0) {
                    int D = this.findMiddleSnake(base, i, N, target, j, M, stack, evidence$2);
                    int v = stack.pop();
                    int u = stack.pop();
                    int y = stack.pop();
                    int x = stack.pop();
                    if (D > 1) {
                        if (N > u && M > v) {
                            stack.push4(i + u, N - u, j + v, M - v);
                        }
                        if (u > x) {
                            stack.push4(i + x, i + u, -1, 0);
                        }
                        if (x <= 0 || y <= 0) continue;
                        stack.push4(i, x, j, y);
                        continue;
                    }
                    if (M > N) {
                        this.appendSlice$1(buf, base, i, i + N);
                        continue;
                    }
                    this.appendSlice$1(buf, target, j, j + M);
                    continue;
                }
                this.appendSlice$1(buf, base, i, N);
            }
            arraySeq = (ArraySeq)buf.result();
        } else {
            arraySeq = ArraySeq$.MODULE$.empty(evidence$3);
        }
        return arraySeq;
    }

    public <T> int minEditDistance(IndexedSeq<T> base, IndexedSeq<T> target, Diff.Eq<T> eq) {
        int N = base.size();
        int M = target.size();
        int MAX = N + M;
        int MAX2 = MAX + 2;
        int[] V = new int[MAX2];
        for (int D = 0; D <= MAX; ++D) {
            int kmax = D - 2 * package$.MODULE$.max(0, D - N);
            for (int k = -(D - 2 * package$.MODULE$.max(0, D - M)); k <= kmax; k += 2) {
                int y;
                int x = k == -D || k != D && this.v$1(MAX2, V, k - 1) < this.v$1(MAX2, V, k + 1) ? this.v$1(MAX2, V, k + 1) : this.v$1(MAX2, V, k - 1) + 1;
                for (y = x - k; x < N && y < M && eq.apply(base.apply(x), target.apply(y)); ++x, ++y) {
                }
                V[k >= 0 ? k : MAX2 + k] = x;
                if (x != N || y != M) continue;
                return D;
            }
        }
        throw this.io$bullet$spliff$Diff$$$failDiff();
    }

    private <T> int findMiddleSnake(IndexedSeq<T> base, int i, int N, IndexedSeq<T> target, int j, int M, IntArrayStack stack, Diff.Eq<T> eq) {
        int MAX2 = N + M + 2;
        int Delta = N - M;
        boolean deltaOdd = (Delta & 1) != 0;
        int[] Vf = new int[MAX2];
        int[] Vb = new int[MAX2];
        int Dlimit = (MAX2 >> 1) + (MAX2 & 1);
        for (int D = 0; D < Dlimit; ++D) {
            int k;
            for (k = -D; k <= D; k += 2) {
                int y;
                int x = k == -D || k != D && this.vf$1(MAX2, Vf, k - 1) < this.vf$1(MAX2, Vf, k + 1) ? this.vf$1(MAX2, Vf, k + 1) : this.vf$1(MAX2, Vf, k - 1) + 1;
                int x_i = x;
                int y_i = y;
                for (y = x - k; x < N && y < M && eq.apply(base.apply(i + x), target.apply(j + y)); ++x, ++y) {
                }
                Vf[k >= 0 ? k : MAX2 + k] = x;
                int kd = -(k - Delta);
                int D1 = D - 1;
                if (!deltaOdd || kd < -D1 || kd > D1 || this.vf$1(MAX2, Vf, k) + this.vb$1(MAX2, Vb, kd) < N) continue;
                stack.push4(x_i, y_i, x, y);
                return 2 * D - 1;
            }
            for (k = -D; k <= D; k += 2) {
                int y;
                int x = k == -D || k != D && this.vb$1(MAX2, Vb, k - 1) < this.vb$1(MAX2, Vb, k + 1) ? this.vb$1(MAX2, Vb, k + 1) : this.vb$1(MAX2, Vb, k - 1) + 1;
                int x_i = x;
                int y_i = y;
                for (y = x - k; x < N && y < M && eq.apply(base.apply(i + N - x - 1), target.apply(j + M - y - 1)); ++x, ++y) {
                }
                Vb[k >= 0 ? k : MAX2 + k] = x;
                int kd = -(k - Delta);
                if (deltaOdd || kd < -D || kd > D || this.vb$1(MAX2, Vb, k) + this.vf$1(MAX2, Vf, kd) < N) continue;
                stack.push4(N - x, M - y, N - x_i, M - y_i);
                return 2 * D;
            }
        }
        throw this.io$bullet$spliff$Diff$$$failDiff();
    }

    public <T> ArraySeq<T> io$bullet$spliff$Diff$$$applyPatch(IndexedSeq<T> base, int baseSize, int targetSize, ArraySeq<Diff.Patch.Step<T>> steps, ClassTag<T> evidence$4) {
        if (base.size() == baseSize) {
            if (steps.size() > 0x3FFFFFFF) {
                throw new IllegalArgumentException();
            }
        } else {
            throw Diff$Patch$BaseSizeMismatch$.MODULE$.apply(base.size(), baseSize);
        }
        Diff.Patch.Step[] allSteps = new Diff.Patch.Step[steps.size() * 2];
        int stepsCount = this.expandSteps$1(steps, allSteps, 0, 0);
        Arrays.sort(allSteps, 0, stepsCount, Diff$Patch$.MODULE$.ordering());
        Object target = Arrays$.MODULE$.newGenericArray(targetSize, evidence$4);
        return ArraySeq$.MODULE$.unsafeWrapArray(this.applyRemainingSteps$1(base, allSteps, stepsCount, target, 0, 0, 0));
    }

    public <T> int io$bullet$spliff$Diff$$$setAndGetNextIndex(Object array, int i, T value) {
        ScalaRunTime$.MODULE$.array_update(array, i, value);
        return i + 1;
    }

    public Nothing$ io$bullet$spliff$Diff$$$failDiff() {
        throw new RuntimeException("Diff algorithm unexpectedly failed. Were the data mutated during the diffing process?");
    }

    private final void appendSlice$1(Builder buf$1, IndexedSeq seq, int start, int end) {
        for (int i = start; i < end; ++i) {
            buf$1.$plus$eq(seq.apply(i));
        }
    }

    private final int v$1(int MAX2$1, int[] V$1, int ix) {
        return V$1[ix >= 0 ? ix : MAX2$1 + ix];
    }

    private final int vf$1(int MAX2$2, int[] Vf$1, int ix) {
        return Vf$1[ix >= 0 ? ix : MAX2$2 + ix];
    }

    private final int vb$1(int MAX2$3, int[] Vb$1, int ix) {
        return Vb$1[ix >= 0 ? ix : MAX2$3 + ix];
    }

    private final int expandSteps$1(ArraySeq steps$2, Diff.Patch.Step[] allSteps$1, int i, int j) {
        int n = j;
        int n2 = i;
        while (n2 < steps$2.size()) {
            int n3;
            Diff.Patch.Step step = (Diff.Patch.Step)steps$2.apply(n2);
            if (step instanceof Diff.Op.Move) {
                Diff.Op.Move move = (Diff.Op.Move)step;
                Diff.Op.Move move2 = Diff$Patch$.MODULE$.Move().unapply(move);
                int n4 = move2._1();
                int n5 = move2._2();
                int n6 = move2._3();
                int origIx = n4;
                int count = n6;
                Diff.Op.Move x = move;
                n3 = this.io$bullet$spliff$Diff$$$setAndGetNextIndex(allSteps$1, this.io$bullet$spliff$Diff$$$setAndGetNextIndex(allSteps$1, n, Diff$Patch$.MODULE$.Delete().apply(origIx, count)), x);
            } else {
                Diff.Patch.Step x = step;
                n3 = this.io$bullet$spliff$Diff$$$setAndGetNextIndex(allSteps$1, n, x);
            }
            int nextj = n3;
            int n7 = n2 + 1;
            int n8 = nextj;
            n2 = n7;
            n = n8;
        }
        return n;
    }

    private final int copyFromBase$1(IndexedSeq base$3, Object target$2, int baseStartIx, int baseEndIx, int targetIx) {
        int n = targetIx;
        int n2 = baseStartIx;
        while (n2 < baseEndIx) {
            if (n < ScalaRunTime$.MODULE$.array_length(target$2)) {
                ScalaRunTime$.MODULE$.array_update(target$2, n, base$3.apply(n2));
                int n3 = n2 + 1;
                int n4 = n + 1;
                n2 = n3;
                n = n4;
                continue;
            }
            throw Diff$Patch$IntegrityFailure$.MODULE$;
        }
        return n;
    }

    private final Object applyRemainingSteps$1(IndexedSeq base$4, Diff.Patch.Step[] allSteps$2, int stepsCount$1, Object target$3, int stepsIx, int baseIx, int targetIx) {
        int n = targetIx;
        int n2 = baseIx;
        int n3 = stepsIx;
        while (n3 < stepsCount$1) {
            Diff.Patch.Step step = allSteps$2[n3];
            if (step instanceof Diff.Op.Delete) {
                Diff.Op.Delete delete = Diff$Patch$.MODULE$.Delete().unapply((Diff.Op.Delete)step);
                int n4 = delete._1();
                int n5 = delete._2();
                int bix = n4;
                int count = n5;
                int n6 = n3 + 1;
                int n7 = bix + count;
                int n8 = this.copyFromBase$1(base$4, target$3, n2, bix, n);
                n3 = n6;
                n2 = n7;
                n = n8;
                continue;
            }
            if (step instanceof Diff.Patch.Insert) {
                Object valuesArray;
                Diff.Patch.Insert insert = Diff$Patch$Insert$.MODULE$.unapply((Diff.Patch.Insert)step);
                int n9 = insert._1();
                ArraySeq arraySeq = insert._2();
                int bix = n9;
                ArraySeq values = arraySeq;
                int bbix = package$.MODULE$.max(bix, n2);
                int tix = this.copyFromBase$1(base$4, target$3, n2, bbix, n);
                int nextTargetIx = tix + ScalaRunTime$.MODULE$.array_length(valuesArray = values.unsafeArray());
                if (nextTargetIx <= ScalaRunTime$.MODULE$.array_length(target$3)) {
                    System.arraycopy(valuesArray, 0, target$3, tix, ScalaRunTime$.MODULE$.array_length(valuesArray));
                    int n10 = n3 + 1;
                    int n11 = bbix;
                    int n12 = nextTargetIx;
                    n3 = n10;
                    n2 = n11;
                    n = n12;
                    continue;
                }
                throw Diff$Patch$IntegrityFailure$.MODULE$;
            }
            if (step instanceof Diff.Op.Move) {
                Diff.Op.Move move = Diff$Patch$.MODULE$.Move().unapply((Diff.Op.Move)step);
                int n13 = move._1();
                int n14 = move._2();
                int n15 = move._3();
                int origIx = n13;
                int destIx = n14;
                int count = n15;
                int tix = this.copyFromBase$1(base$4, target$3, n2, destIx, n);
                int nextTargetIx = this.copyFromBase$1(base$4, target$3, origIx, origIx + count, tix);
                int n16 = n3 + 1;
                int n17 = package$.MODULE$.max(destIx, n2);
                int n18 = nextTargetIx;
                n3 = n16;
                n2 = n17;
                n = n18;
                continue;
            }
            throw new MatchError((Object)step);
        }
        if (this.copyFromBase$1(base$4, target$3, n2, base$4.size(), n) != ScalaRunTime$.MODULE$.array_length(target$3)) {
            throw Diff$Patch$IntegrityFailure$.MODULE$;
        }
        return target$3;
    }
}

