/*
 * Decompiled with CFR 0.152.
 */
package io.bullet.spliff;

import io.bullet.spliff.Diff;
import io.bullet.spliff.Diff$Patch$;
import io.bullet.spliff.Diff$Patch$IntegrityFailure$;
import io.bullet.spliff.util.IntArrayStack;
import java.io.Serializable;
import java.util.Arrays;
import scala.Function2;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.ArraySeq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.mutable.Builder;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public final class Diff$ {
    public static final Diff$ MODULE$ = new Diff$();

    public <T> Diff<T> apply(IndexedSeq<T> base, IndexedSeq<T> target, Diff.Eq<T> evidence$1) {
        return new Diff.Myers().diff(base, target, evidence$1);
    }

    public <T> ArraySeq<T> longestCommonSubsequence(IndexedSeq<T> base, IndexedSeq<T> target, Diff.Eq<T> evidence$2, ClassTag<T> evidence$3) {
        ArraySeq arraySeq;
        if (base.nonEmpty() && target.nonEmpty()) {
            Builder buf = ArraySeq$.MODULE$.newBuilder(evidence$3);
            IntArrayStack stack = new IntArrayStack(64);
            stack.push4(0, base.size(), 0, target.size());
            while (stack.nonEmpty()) {
                Object object;
                int M = stack.pop();
                int j = stack.pop();
                int N = stack.pop();
                int i = stack.pop();
                if (j >= 0) {
                    int D = this.findMiddleSnake(base, i, N, target, j, M, stack, evidence$2);
                    int v = stack.pop();
                    int u = stack.pop();
                    int y = stack.pop();
                    int x = stack.pop();
                    if (D > 1) {
                        Object object2 = N > u && M > v ? stack.push4(i + u, N - u, j + v, M - v) : BoxedUnit.UNIT;
                        Object object3 = u > x ? stack.push4(i + x, i + u, -1, 0) : BoxedUnit.UNIT;
                        if (x > 0 && y > 0) {
                            object = stack.push4(i, x, j, y);
                            continue;
                        }
                        object = BoxedUnit.UNIT;
                        continue;
                    }
                    if (M > N) {
                        this.appendSlice$1(base, i, i + N, buf);
                    } else {
                        this.appendSlice$1(target, j, j + M, buf);
                    }
                    object = BoxedUnit.UNIT;
                    continue;
                }
                this.appendSlice$1(base, i, N, buf);
                object = BoxedUnit.UNIT;
            }
            arraySeq = (ArraySeq)buf.result();
        } else {
            arraySeq = ArraySeq$.MODULE$.empty(evidence$3);
        }
        return arraySeq;
    }

    public <T> int minEditDistance(IndexedSeq<T> base, IndexedSeq<T> target, Diff.Eq<T> eq) {
        int N = base.size();
        int M = target.size();
        int MAX = N + M;
        int MAX2 = MAX + 2;
        int[] V = new int[MAX2];
        for (int D = 0; D <= MAX; ++D) {
            int kmax = D - 2 * package$.MODULE$.max(0, D - N);
            for (int k = -(D - 2 * package$.MODULE$.max(0, D - M)); k <= kmax; k += 2) {
                int y;
                int x = k == -D || k != D && Diff$.v$1(k - 1, V, MAX2) < Diff$.v$1(k + 1, V, MAX2) ? Diff$.v$1(k + 1, V, MAX2) : Diff$.v$1(k - 1, V, MAX2) + 1;
                for (y = x - k; x < N && y < M && eq.apply(base.apply(x), target.apply(y)); ++x, ++y) {
                }
                V[k >= 0 ? k : MAX2 + k] = x;
                if (x != N || y != M) continue;
                return D;
            }
        }
        throw this.io$bullet$spliff$Diff$$failDiff();
    }

    private <T> int findMiddleSnake(IndexedSeq<T> base, int i, int N, IndexedSeq<T> target, int j, int M, IntArrayStack stack, Diff.Eq<T> eq) {
        int MAX2 = N + M + 2;
        int Delta = N - M;
        boolean deltaOdd = (Delta & 1) != 0;
        int[] Vf = new int[MAX2];
        int[] Vb = new int[MAX2];
        int Dlimit = (MAX2 >> 1) + (MAX2 & 1);
        for (int D = 0; D < Dlimit; ++D) {
            int k;
            for (k = -D; k <= D; k += 2) {
                int y;
                int x = k == -D || k != D && Diff$.vf$1(k - 1, Vf, MAX2) < Diff$.vf$1(k + 1, Vf, MAX2) ? Diff$.vf$1(k + 1, Vf, MAX2) : Diff$.vf$1(k - 1, Vf, MAX2) + 1;
                int x_i = x;
                int y_i = y;
                for (y = x - k; x < N && y < M && eq.apply(base.apply(i + x), target.apply(j + y)); ++x, ++y) {
                }
                Vf[k >= 0 ? k : MAX2 + k] = x;
                int kd = -(k - Delta);
                int D1 = D - 1;
                if (!deltaOdd || kd < -D1 || kd > D1 || Diff$.vf$1(k, Vf, MAX2) + Diff$.vb$1(kd, Vb, MAX2) < N) continue;
                stack.push4(x_i, y_i, x, y);
                return 2 * D - 1;
            }
            for (k = -D; k <= D; k += 2) {
                int y;
                int x = k == -D || k != D && Diff$.vb$1(k - 1, Vb, MAX2) < Diff$.vb$1(k + 1, Vb, MAX2) ? Diff$.vb$1(k + 1, Vb, MAX2) : Diff$.vb$1(k - 1, Vb, MAX2) + 1;
                int x_i = x;
                int y_i = y;
                for (y = x - k; x < N && y < M && eq.apply(base.apply(i + N - x - 1), target.apply(j + M - y - 1)); ++x, ++y) {
                }
                Vb[k >= 0 ? k : MAX2 + k] = x;
                int kd = -(k - Delta);
                if (deltaOdd || kd < -D || kd > D || Diff$.vb$1(k, Vb, MAX2) + Diff$.vf$1(kd, Vf, MAX2) < N) continue;
                stack.push4(N - x, M - y, N - x_i, M - y_i);
                return 2 * D;
            }
        }
        throw this.io$bullet$spliff$Diff$$failDiff();
    }

    public <T> ArraySeq<T> io$bullet$spliff$Diff$$applyPatch(IndexedSeq<T> base, int baseSize, int targetSize, ArraySeq<Diff.Patch.Step<T>> steps, ClassTag<T> evidence$4) {
        if (base.size() == baseSize) {
            if (steps.size() > 0x3FFFFFFF) {
                throw new IllegalArgumentException();
            }
        } else {
            throw new Diff.Patch.BaseSizeMismatch(base.size(), baseSize);
        }
        Diff.Patch.Step[] allSteps = new Diff.Patch.Step[steps.size() * 2];
        int stepsCount = this.expandSteps$1(0, 0, steps, allSteps);
        Arrays.sort((Object[])allSteps, 0, stepsCount, Diff$Patch$.MODULE$.ordering());
        Object target = evidence$4.newArray(targetSize);
        return ArraySeq$.MODULE$.unsafeWrapArray(this.applyRemainingSteps$1(0, 0, 0, stepsCount, allSteps, targetSize, target, base));
    }

    public <T> Diff.Patch<T> io$bullet$spliff$Diff$$patchFromBaseSizeAndSteps(int baseSize, ArraySeq<Diff.Patch.Step<T>> steps) {
        int targetSize = BoxesRunTime.unboxToInt((Object)steps.foldLeft((Object)BoxesRunTime.boxToInteger((int)baseSize), (Function2 & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToInteger((int)Diff$.$anonfun$patchFromBaseSizeAndSteps$1(BoxesRunTime.unboxToInt((Object)x0$1), x1$1))));
        return new Diff.Patch<T>(baseSize, targetSize, steps);
    }

    public <T> int io$bullet$spliff$Diff$$setAndGetNextIndex(Object array, int i, T value) {
        ScalaRunTime$.MODULE$.array_update(array, i, value);
        return i + 1;
    }

    public Nothing$ io$bullet$spliff$Diff$$failDiff() {
        throw new RuntimeException("Diff algorithm unexpectedly failed. Were the data mutated during the diffing process?");
    }

    private final void appendSlice$1(IndexedSeq seq, int start, int end, Builder buf$1) {
        while (start < end) {
            buf$1.$plus$eq(seq.apply(start));
            ++start;
        }
    }

    private static final int v$1(int ix, int[] V$1, int MAX2$1) {
        return V$1[ix >= 0 ? ix : MAX2$1 + ix];
    }

    private static final int vf$1(int ix, int[] Vf$1, int MAX2$2) {
        return Vf$1[ix >= 0 ? ix : MAX2$2 + ix];
    }

    private static final int vb$1(int ix, int[] Vb$1, int MAX2$2) {
        return Vb$1[ix >= 0 ? ix : MAX2$2 + ix];
    }

    private final int expandSteps$1(int i, int j, ArraySeq steps$1, Diff.Patch.Step[] allSteps$1) {
        while (i < steps$1.size()) {
            int nextj;
            int n;
            Diff.Patch.Step step = (Diff.Patch.Step)steps$1.apply(i);
            if (step instanceof Diff.Op.Move) {
                Diff.Op.Move move = (Diff.Op.Move)step;
                int origIx = move.origIx();
                int count = move.count();
                n = this.io$bullet$spliff$Diff$$setAndGetNextIndex(allSteps$1, this.io$bullet$spliff$Diff$$setAndGetNextIndex(allSteps$1, j, Diff$Patch$.MODULE$.Delete().apply(origIx, count)), move);
            } else {
                n = this.io$bullet$spliff$Diff$$setAndGetNextIndex(allSteps$1, j, step);
            }
            j = nextj = n;
            ++i;
        }
        return j;
    }

    private final int copyFromBase$1(int baseStartIx, int baseEndIx, int targetIx, int targetSize$1, Object target$2, IndexedSeq base$3) {
        while (baseStartIx < baseEndIx) {
            if (targetIx < targetSize$1) {
                ScalaRunTime$.MODULE$.array_update(target$2, targetIx, base$3.apply(baseStartIx));
                ++targetIx;
                ++baseStartIx;
                continue;
            }
            throw Diff$Patch$IntegrityFailure$.MODULE$;
        }
        return targetIx;
    }

    private final Object applyRemainingSteps$1(int stepsIx, int baseIx, int targetIx, int stepsCount$1, Diff.Patch.Step[] allSteps$1, int targetSize$1, Object target$2, IndexedSeq base$3) {
        while (stepsIx < stepsCount$1) {
            Diff.Patch.Step step = allSteps$1[stepsIx];
            if (step instanceof Diff.Op.Delete) {
                Diff.Op.Delete delete = (Diff.Op.Delete)step;
                int bix = delete.baseIx();
                int count = delete.count();
                targetIx = this.copyFromBase$1(baseIx, bix, targetIx, targetSize$1, target$2, base$3);
                baseIx = bix + count;
                ++stepsIx;
                continue;
            }
            if (step instanceof Diff.Patch.Insert) {
                Object valuesArray;
                Diff.Patch.Insert insert = (Diff.Patch.Insert)step;
                int bix = insert.baseIx();
                ArraySeq values = insert.values();
                int bbix = package$.MODULE$.max(bix, baseIx);
                int tix = this.copyFromBase$1(baseIx, bbix, targetIx, targetSize$1, target$2, base$3);
                int nextTargetIx = tix + ScalaRunTime$.MODULE$.array_length(valuesArray = values.unsafeArray());
                if (nextTargetIx <= targetSize$1) {
                    System.arraycopy(valuesArray, 0, target$2, tix, ScalaRunTime$.MODULE$.array_length(valuesArray));
                    targetIx = nextTargetIx;
                    baseIx = bbix;
                    ++stepsIx;
                    continue;
                }
                throw Diff$Patch$IntegrityFailure$.MODULE$;
            }
            if (step instanceof Diff.Op.Move) {
                int nextTargetIx;
                Diff.Op.Move move = (Diff.Op.Move)step;
                int origIx = move.origIx();
                int destIx = move.destIx();
                int count = move.count();
                int tix = this.copyFromBase$1(baseIx, destIx, targetIx, targetSize$1, target$2, base$3);
                targetIx = nextTargetIx = this.copyFromBase$1(origIx, origIx + count, tix, targetSize$1, target$2, base$3);
                baseIx = package$.MODULE$.max(destIx, baseIx);
                ++stepsIx;
                continue;
            }
            throw new MatchError((Object)step);
        }
        if (this.copyFromBase$1(baseIx, base$3.size(), targetIx, targetSize$1, target$2, base$3) != targetSize$1) {
            throw Diff$Patch$IntegrityFailure$.MODULE$;
        }
        return target$2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ int $anonfun$patchFromBaseSizeAndSteps$1(int x0$1, Diff.Patch.Step x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$1), (Object)x1$1);
        if (tuple2 != null) {
            int acc = tuple2._1$mcI$sp();
            Diff.Patch.Step step = (Diff.Patch.Step)tuple2._2();
            if (step instanceof Diff.Op.Delete) {
                Diff.Op.Delete delete = (Diff.Op.Delete)step;
                int count = delete.count();
                return acc - count;
            }
        }
        if (tuple2 != null) {
            int acc = tuple2._1$mcI$sp();
            Diff.Patch.Step step = (Diff.Patch.Step)tuple2._2();
            if (step instanceof Diff.Patch.Insert) {
                Diff.Patch.Insert insert = (Diff.Patch.Insert)step;
                ArraySeq values = insert.values();
                return acc + values.size();
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        int acc = tuple2._1$mcI$sp();
        if (!(tuple2._2() instanceof Diff.Op.Move)) throw new MatchError((Object)tuple2);
        return acc;
    }

    private Diff$() {
    }
}

