/*
 * Decompiled with CFR 0.152.
 */
package io.bullet.borer.compat;

import io.bullet.borer.compat.scodec$;
import io.bullet.borer.core.ByteAccess;
import io.bullet.borer.core.Cbor;
import io.bullet.borer.core.Input;
import io.bullet.borer.core.Output;
import java.util.Arrays;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001ds!\u0002\u0011\"\u0011\u0003Qc!\u0002\u0017\"\u0011\u0003i\u0003\"\u0002\u001b\u0002\t\u0003)\u0004b\u0002\u001c\u0002\u0005\u0004%\u0019a\u000e\u0005\u0007\u000b\u0006\u0001\u000b\u0011\u0002\u001d\u0007\t\u0019\u000b\u0011a\u0012\u0005\t'\u0016\u0011\t\u0011)A\u0005}!)A'\u0002C\u0001)\"I\u0001,\u0002a\u0001\u0002\u0003\u0006K!\u0017\u0005\n9\u0016\u0001\r\u0011!Q!\nuC\u0011\u0002Y\u0003A\u0002\u0003\u0005\u000b\u0015\u0002 \u0006\t\u0005,\u0001!\u0016\u0005\u0006E\u0016!\ta\u0019\u0005\u0006I\u0016!\t!\u001a\u0005\u0006M\u0016!\ta\u001a\u0005\u0006Q\u0016!\t!\u001b\u0005\u0006_\u0016!\t\u0001\u001d\u0005\u0006g\u0016!\t\u0001\u001e\u0005\u0006m\u0016!\ta\u001e\u0005\bq\u0006\t\t\u0011b\u0001z\r\u0011Y\u0018A\u0001?\t\rQ\"B\u0011AA\u0001\u0011!\t)\u0001\u0006Q!\n\u0005\u001d\u0001B\u0003-\u0015\u0001\u0004\u0005\t\u0015)\u0003\u0002\u000e\u0015)\u0011\r\u0006\u0001\u0002\u0004!1!\r\u0006C\u0001\u0003'Aq!!\u0006\u0015\t\u0003\t9\u0002C\u0004\u0002 Q!\t!!\t\t\u000f\u0005}A\u0003\"\u0001\u0002(!9\u00111\u0006\u000b\u0005\u0002\u00055\u0002bBA\u0018)\u0011%\u0011\u0011\u0007\u0005\b\u0003{!B\u0011BA \u0003\u0019\u00198m\u001c3fG*\u0011!eI\u0001\u0007G>l\u0007/\u0019;\u000b\u0005\u0011*\u0013!\u00022pe\u0016\u0014(B\u0001\u0014(\u0003\u0019\u0011W\u000f\u001c7fi*\t\u0001&\u0001\u0002j_\u000e\u0001\u0001CA\u0016\u0002\u001b\u0005\t#AB:d_\u0012,7m\u0005\u0002\u0002]A\u0011qFM\u0007\u0002a)\t\u0011'A\u0003tG\u0006d\u0017-\u0003\u00024a\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0016\u0002)\tLH/Z*ue&twMQ=uK\u0006\u001b7-Z:t+\u0005A\u0004cA\u001d=}5\t!H\u0003\u0002<G\u0005!1m\u001c:f\u0013\ti$H\u0001\u0006CsR,\u0017iY2fgN\u0004\"aP\"\u000e\u0003\u0001S!!\u0011\"\u0002\t\tLGo\u001d\u0006\u0002A%\u0011A\t\u0011\u0002\u000b\u0005f$XMV3di>\u0014\u0018!\u00062zi\u0016\u001cFO]5oO\nKH/Z!dG\u0016\u001c8\u000f\t\u0002\u0010\u0005f$XMV3di>\u0014\u0018J\u001c9viN!QA\f%L!\rI\u0014JP\u0005\u0003\u0015j\u0012Q!\u00138qkR\u0004\"\u0001T)\u000e\u00035S!AT(\u0002\t1\fgn\u001a\u0006\u0002!\u0006!!.\u0019<b\u0013\t\u0011VJA\u0005DY>tW-\u00192mK\u0006)\u0011N\u001c9viR\u0011Qk\u0016\t\u0003-\u0016i\u0011!\u0001\u0005\u0006'\u001e\u0001\rAP\u0001\b?\u000e,(o]8s!\ty#,\u0003\u0002\\a\t!Aj\u001c8h\u0003%yF.Y:u\u0005f$X\r\u0005\u00020=&\u0011q\f\r\u0002\u0005\u0005f$X-\u0001\u0006`Y\u0006\u001cHOQ=uKN\u0014AaU3mM\u000611-\u001e:t_J,\u0012!W\u0001\tY\u0006\u001cHOQ=uKV\tQ,A\u0005mCN$()\u001f;fgV\ta(\u0001\u0005iCN\u0014\u0015\u0010^3t)\tQW\u000e\u0005\u00020W&\u0011A\u000e\r\u0002\b\u0005>|G.Z1o\u0011\u0015qw\u00021\u0001Z\u0003\u0019aWM\\4uQ\u0006A!/Z1e\u0005f$X\rF\u0001r!\t\u00118\"D\u0001\u0006\u0003%\u0011X-\u00193CsR,7\u000f\u0006\u0002rk\")a.\u0005a\u00013\u0006!1m\u001c9z+\u0005)\u0016a\u0004\"zi\u00164Vm\u0019;pe&s\u0007/\u001e;\u0015\u0005US\b\"B*\u0014\u0001\u0004q$\u0001\u0005\"zi\u00164Vm\u0019;pe>+H\u000f];u'\r!b& \t\u0004syt\u0014BA@;\u0005\u0019yU\u000f\u001e9viR\u0011\u00111\u0001\t\u0003-R\taAY;gM\u0016\u0014\b\u0003B\u0018\u0002\nuK1!a\u00031\u0005\u0015\t%O]1z!\ry\u0013qB\u0005\u0004\u0003#\u0001$aA%oiV\u0011\u0011QB\u0001\noJLG/\u001a\"zi\u0016$B!!\u0007\u0002\u001c5\tA\u0003\u0003\u0004\u0002\u001ei\u0001\r!X\u0001\u0005Ef$X-\u0001\u0006xe&$XMQ=uKN$B!!\u0007\u0002$!9\u0011QE\u000eA\u0002\u0005\u001d\u0011!\u00022zi\u0016\u001cH\u0003BA\r\u0003SAa!!\n\u001d\u0001\u0004q\u0014A\u0002:fgVdG\u000fF\u0001?\u00031)gn];sK2+gn\u001a;i)\u0011\t\u0019$!\u000f\u0011\u0007=\n)$C\u0002\u00028A\u0012A!\u00168ji\"9\u00111\b\u0010A\u0002\u00055\u0011aB7j]NK'0Z\u0001\t_Z,'O\u001a7poR\u0011\u0011\u0011\t\t\u0004_\u0005\r\u0013bAA#a\t9aj\u001c;iS:<\u0007")
public final class scodec {
    public static ByteVectorInput ByteVectorInput(ByteVector byteVector) {
        return scodec$.MODULE$.ByteVectorInput(byteVector);
    }

    public static ByteAccess<ByteVector> byteStringByteAccess() {
        return scodec$.MODULE$.byteStringByteAccess();
    }

    public static class ByteVectorInput
    implements Input<ByteVector>,
    Cloneable {
        private final ByteVector input;
        private long _cursor;
        private byte _lastByte;
        private ByteVector _lastBytes;

        public long cursor() {
            return this._cursor;
        }

        public byte lastByte() {
            return this._lastByte;
        }

        public ByteVector lastBytes() {
            return this._lastBytes;
        }

        public boolean hasBytes(long length) {
            long off = length + this._cursor;
            return 0L <= off && off <= this.input.length();
        }

        public ByteVectorInput readByte() {
            this._lastByte = this.input.apply(this._cursor);
            ++this._cursor;
            return this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public ByteVectorInput readBytes(long length) {
            if (length > 0L) {
                long newCursor = this._cursor + length;
                if (newCursor < 0L) throw new Cbor.Error$.Overflow((Object)BoxesRunTime.boxToLong((long)this._cursor), "ByteVector input is limited to 2^63 bytes");
                this._lastBytes = this.input.slice(this._cursor, newCursor);
                this._cursor = newCursor;
                return this;
            } else {
                this._lastBytes = ByteVector$.MODULE$.empty();
            }
            return this;
        }

        public ByteVectorInput copy() {
            return (ByteVectorInput)super.clone();
        }

        public ByteVectorInput(ByteVector input) {
            this.input = input;
        }
    }

    public static final class ByteVectorOutput
    implements Output<ByteVector> {
        private byte[] buffer = new byte[64];
        private int _cursor;

        public int cursor() {
            return this._cursor;
        }

        public ByteVectorOutput writeByte(byte by) {
            int newCursor = this._cursor + 1;
            if (newCursor <= 0) {
                throw this.overflow();
            }
            this.ensureLength(newCursor);
            this.buffer[this._cursor] = by;
            this._cursor = newCursor;
            return this;
        }

        public ByteVectorOutput writeBytes(byte[] bytes) {
            int l = bytes.length;
            int newCursor = this._cursor + l;
            if (newCursor <= 0) {
                throw this.overflow();
            }
            this.ensureLength(newCursor);
            System.arraycopy(bytes, 0, this.buffer, this._cursor, l);
            this._cursor = newCursor;
            return this;
        }

        public ByteVectorOutput writeBytes(ByteVector bytes) {
            int newCursor;
            long l = bytes.size();
            if (l > Integer.MAX_VALUE) {
                newCursor = this._cursor + (int)l;
                if (newCursor <= 0) {
                    throw this.overflow();
                }
            } else {
                throw this.overflow();
            }
            this.ensureLength(newCursor);
            bytes.copyToArray(this.buffer, this._cursor);
            this._cursor = newCursor;
            return this;
        }

        public ByteVector result() {
            return ByteVector$.MODULE$.view(this.buffer, 0, this._cursor);
        }

        private void ensureLength(int minSize) {
            block0: {
                if (this.buffer.length >= minSize) break block0;
                int newLen = package$.MODULE$.max(this.buffer.length << 1, minSize);
                this.buffer = Arrays.copyOf(this.buffer, newLen);
            }
        }

        private Nothing$ overflow() {
            throw new Cbor.Error$.Overflow((Object)this, "Cannot output to byte array with > 2^31 bytes");
        }
    }
}

