/*
 * Decompiled with CFR 0.152.
 */
package io.bullet.borer.compat;

import io.bullet.borer.Decoder;
import io.bullet.borer.Decoder$;
import io.bullet.borer.Encoder;
import io.bullet.borer.Encoder$;
import io.bullet.borer.InputReader;
import io.bullet.borer.Reader;
import io.bullet.borer.SimpleValue;
import io.bullet.borer.Tag;
import io.bullet.borer.Writer;
import io.bullet.borer.encodings.BaseEncoding$;
import io.circe.DecodingFailure;
import io.circe.Json;
import io.circe.Json$;
import io.circe.JsonNumber;
import io.circe.JsonNumber$;
import io.circe.JsonObject;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class circe$ {
    public static circe$ MODULE$;
    private final Encoder<Json> circeJsonAstEncoder;
    private final Decoder<Json> defaultCirceJsonAstDecoder;

    static {
        new circe$();
    }

    private final String JsonDoubleName() {
        return "io.circe.JsonDouble";
    }

    private final String JsonFloatName() {
        return "io.circe.JsonFloat";
    }

    private final String JsonLongName() {
        return "io.circe.JsonLong";
    }

    public <T> Encoder<T> borerEncoderFromCirceEncoder(io.circe.Encoder<T> ce) {
        return Encoder$.MODULE$.apply((w, x) -> MODULE$.circeJsonAstEncoder().write(w, (Object)ce.apply(x)));
    }

    public <T> Decoder<T> defaultBorerDecoderFromCirceDecoder(io.circe.Decoder<T> cd) {
        return this.borerDecoderFromCirceDecoder(this.defaultCirceJsonAstDecoder(), cd);
    }

    public <T> Decoder<T> borerDecoderFromCirceDecoder(Decoder<Json> circeJsonAstEncoder, io.circe.Decoder<T> cd) {
        return Decoder$.MODULE$.apply(r -> {
            Object x;
            Either either = cd.decodeJson((Json)circeJsonAstEncoder.read(r));
            if (either instanceof Left) {
                Left left = (Left)either;
                DecodingFailure e = (DecodingFailure)left.value();
                throw r.validationFailure(e.getMessage());
            }
            if (!(either instanceof Right)) {
                throw new MatchError((Object)either);
            }
            Right right = (Right)either;
            Object object = x = right.value();
            return object;
        });
    }

    public Encoder<Json> circeJsonAstEncoder() {
        return this.circeJsonAstEncoder;
    }

    public Decoder<Json> defaultCirceJsonAstDecoder() {
        return this.defaultCirceJsonAstDecoder;
    }

    public Decoder<Json> circeJsonAstDecoder(Decoder<BigInt> bigIntDecoder, Decoder<BigDecimal> bigDecimalDecoder, Option<Function0<Json>> decodeUndefined, Option<Function1<byte[], Json>> decodeByteArray, Option<Function1<SimpleValue, Json>> decodeSimpleValue) {
        return new Decoder<Json>(decodeUndefined, bigIntDecoder, decodeByteArray, decodeSimpleValue, bigDecimalDecoder){
            private final Decoder<Vector<Json>> arrayDecoder;
            private final Decoder<ListMap<String, Json>> mapDecoder;
            private final Option decodeUndefined$1;
            private final Decoder bigIntDecoder$1;
            private final Option decodeByteArray$1;
            private final Option decodeSimpleValue$1;
            private final Decoder bigDecimalDecoder$1;

            public Json read(InputReader<? extends Reader.Config> r) {
                Json json;
                int n = Integer.numberOfTrailingZeros(r.dataItem());
                switch (n) {
                    case 0: {
                        r.readNull();
                        json = Json$.MODULE$.Null();
                        break;
                    }
                    case 1: {
                        Option option = this.decodeUndefined$1;
                        if (!(option instanceof Some)) {
                            if (None$.MODULE$.equals(option)) {
                                throw r.validationFailure("CBOR `undefined` cannot be represented in the circe JSON AST");
                            }
                            throw new MatchError((Object)option);
                        }
                        Some some = (Some)option;
                        Function0 f = (Function0)some.value();
                        Json json2 = (Json)f.apply();
                        json = json2;
                        break;
                    }
                    case 2: {
                        if (r.readBoolean()) {
                            json = Json$.MODULE$.True();
                            break;
                        }
                        json = Json$.MODULE$.False();
                        break;
                    }
                    case 3: {
                        json = Json$.MODULE$.fromInt(r.readInt());
                        break;
                    }
                    case 4: {
                        json = Json$.MODULE$.fromLong(r.readLong());
                        break;
                    }
                    case 5: {
                        json = Json$.MODULE$.fromBigInt((BigInt)this.bigIntDecoder$1.read(r));
                        break;
                    }
                    case 6: 
                    case 7: {
                        float f = r.readFloat();
                        json = (Json)Json$.MODULE$.fromFloat(f).getOrElse((Function0 & Serializable & scala.Serializable)() -> r.validationFailure(new StringBuilder(58).append("Float value `").append(f).append("` cannot be represented in the circe JSON AST").toString()));
                        break;
                    }
                    case 8: {
                        double d = r.readDouble();
                        json = (Json)Json$.MODULE$.fromDouble(d).getOrElse((Function0 & Serializable & scala.Serializable)() -> r.validationFailure(new StringBuilder(59).append("Double value `").append(d).append("` cannot be represented in the circe JSON AST").toString()));
                        break;
                    }
                    case 9: {
                        json = Json$.MODULE$.fromJsonNumber(JsonNumber$.MODULE$.fromDecimalStringUnsafe(r.readNumberString()));
                        break;
                    }
                    case 14: 
                    case 15: {
                        Option option = this.decodeByteArray$1;
                        if (!(option instanceof Some)) {
                            if (None$.MODULE$.equals(option)) {
                                throw r.validationFailure("Raw byte arrays cannot be represented in the circe JSON AST");
                            }
                            throw new MatchError((Object)option);
                        }
                        Some some = (Some)option;
                        Function1 f = (Function1)some.value();
                        Json json3 = (Json)f.apply((Object)r.readByteArray());
                        json = json3;
                        break;
                    }
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: {
                        json = Json$.MODULE$.fromString(r.readString());
                        break;
                    }
                    case 22: {
                        Option option = this.decodeSimpleValue$1;
                        if (!(option instanceof Some)) {
                            if (None$.MODULE$.equals(option)) {
                                throw r.validationFailure("Raw byte arrays cannot be represented in the circe JSON AST");
                            }
                            throw new MatchError((Object)option);
                        }
                        Some some = (Some)option;
                        Function1 f = (Function1)some.value();
                        Json json4 = (Json)f.apply((Object)new SimpleValue(r.readSimpleValue()));
                        json = json4;
                        break;
                    }
                    case 16: 
                    case 17: {
                        json = Json$.MODULE$.fromValues((Iterable)this.arrayDecoder.read(r));
                        break;
                    }
                    case 18: 
                    case 19: {
                        json = Json$.MODULE$.fromFields((Iterable)this.mapDecoder.read(r));
                        break;
                    }
                    case 21: {
                        if (r.hasTag((Tag)Tag.PositiveBigNum$.MODULE$) | r.hasTag((Tag)Tag.NegativeBigNum$.MODULE$)) {
                            json = Json$.MODULE$.fromBigInt((BigInt)this.bigIntDecoder$1.read(r));
                            break;
                        }
                        if (r.hasTag((Tag)Tag.DecimalFraction$.MODULE$)) {
                            json = Json$.MODULE$.fromBigDecimal((BigDecimal)this.bigDecimalDecoder$1.read(r));
                            break;
                        }
                        throw r.validationFailure(new StringBuilder(56).append("CBOR tag `").append(r.readTag()).append("` cannot be represented in the circe JSON AST`").toString());
                    }
                    default: {
                        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                    }
                }
                return json;
            }
            {
                this.decodeUndefined$1 = decodeUndefined$1;
                this.bigIntDecoder$1 = bigIntDecoder$1;
                this.decodeByteArray$1 = decodeByteArray$1;
                this.decodeSimpleValue$1 = decodeSimpleValue$1;
                this.bigDecimalDecoder$1 = bigDecimalDecoder$1;
                this.arrayDecoder = Decoder$.MODULE$.fromFactory((Decoder)this, (CanBuildFrom)Predef$.MODULE$.implicitly((Object)Vector$.MODULE$.canBuildFrom()));
                this.mapDecoder = Decoder$.MODULE$.forListMap(Decoder$.MODULE$.forString(), (Decoder)this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$1(io.bullet.borer.InputReader float ), $anonfun$read$2(io.bullet.borer.InputReader double )}, serializedLambda);
            }
        };
    }

    public Decoder<BigInt> circeJsonAstDecoder$default$1() {
        return Decoder$.MODULE$.forBigInt();
    }

    public Decoder<BigDecimal> circeJsonAstDecoder$default$2() {
        return Decoder$.MODULE$.forBigDecimal();
    }

    public Option<Function0<Json>> circeJsonAstDecoder$default$3() {
        return new Some((Function0 & Serializable & scala.Serializable)() -> Json$.MODULE$.Null());
    }

    public Option<Function1<byte[], Json>> circeJsonAstDecoder$default$4() {
        return new Some(this.defaultDecodeByteArray());
    }

    public Option<Function1<SimpleValue, Json>> circeJsonAstDecoder$default$5() {
        return None$.MODULE$;
    }

    private Function1<byte[], Json> defaultDecodeByteArray() {
        return (Function1 & Serializable & scala.Serializable)bytes -> Json$.MODULE$.fromString(new String(BaseEncoding$.MODULE$.base64().encode(bytes)));
    }

    private circe$() {
        MODULE$ = this;
        this.circeJsonAstEncoder = Encoder$.MODULE$.apply((w, value) -> (Writer)value.foldWith((Json.Folder)new Json.Folder<Writer>(w){
            private final Writer w$1;

            public Writer onNull() {
                return this.w$1.writeNull();
            }

            public Writer onBoolean(boolean value) {
                return this.w$1.writeBoolean(value);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public Writer onNumber(JsonNumber value) {
                Writer writer;
                if (this.w$1.writingCbor()) {
                    String className = value.getClass().getName();
                    if (className == "io.circe.JsonLong") {
                        writer = this.w$1.writeLong(BoxesRunTime.unboxToLong((Object)value.toLong().get()));
                        return writer;
                    } else if (className == "io.circe.JsonDouble") {
                        writer = this.w$1.writeDouble(value.toDouble());
                        return writer;
                    } else if (className == "io.circe.JsonFloat") {
                        writer = this.w$1.writeFloat(value.toFloat());
                        return writer;
                    } else {
                        Writer writer2;
                        Option option = value.toBigDecimal();
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            BigDecimal bigDecimal = (BigDecimal)some.value();
                            Option option2 = bigDecimal.toBigIntExact();
                            if (option2 instanceof Some) {
                                Some some2 = (Some)option2;
                                BigInt bigInt = (BigInt)some2.value();
                                writer2 = this.w$1.write((Object)bigInt, Encoder$.MODULE$.forBigInt());
                            } else {
                                if (!None$.MODULE$.equals(option2)) throw new MatchError((Object)option2);
                                writer2 = this.w$1.write((Object)bigDecimal, Encoder$.MODULE$.forBigDecimal());
                            }
                        } else {
                            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                            throw new NumberFormatException(new StringBuilder(53).append("The circe JsonNumber `").append(value).append("` cannot be represented in CBOR").toString());
                        }
                        Writer writer3 = writer2;
                        writer = writer3;
                    }
                    return writer;
                } else {
                    writer = this.w$1.writeNumberString(value.toString());
                }
                return writer;
            }

            public Writer onString(String value) {
                return this.w$1.writeString(value);
            }

            public Writer onArray(Vector<Json> value) {
                return this.w$1.writeIndexedSeq(value, circe$.MODULE$.circeJsonAstEncoder());
            }

            public Writer onObject(JsonObject value) {
                Writer writer;
                if (value.nonEmpty()) {
                    Iterator iterator = value.toIterable().iterator();
                    this.w$1.writeMapOpen(value.size());
                    while (iterator.hasNext()) {
                        Tuple2 tuple2 = (Tuple2)iterator.next();
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        String k = (String)tuple2._1();
                        Json v = (Json)tuple2._2();
                        Tuple2 tuple22 = new Tuple2((Object)k, (Object)v);
                        Tuple2 tuple23 = tuple22;
                        String k2 = (String)tuple23._1();
                        Json v2 = (Json)tuple23._2();
                        circe$.MODULE$.circeJsonAstEncoder().write(this.w$1.writeString(k2), (Object)v2);
                    }
                    writer = this.w$1.writeMapClose();
                } else {
                    writer = this.w$1.writeEmptyMap();
                }
                return writer;
            }
            {
                this.w$1 = w$1;
            }
        }));
        this.defaultCirceJsonAstDecoder = this.circeJsonAstDecoder(this.circeJsonAstDecoder$default$1(), this.circeJsonAstDecoder$default$2(), this.circeJsonAstDecoder$default$3(), this.circeJsonAstDecoder$default$4(), this.circeJsonAstDecoder$default$5());
    }
}

