/*
 * Decompiled with CFR 0.152.
 */
package io.buji.oauth;

import io.buji.oauth.OAuthToken;
import io.buji.oauth.ShiroUserSession;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.authc.AuthenticatingFilter;
import org.apache.shiro.web.util.WebUtils;
import org.scribe.up.credential.OAuthCredential;
import org.scribe.up.profile.ProfileHelper;
import org.scribe.up.provider.OAuthProvider;
import org.scribe.up.provider.ProvidersDefinition;
import org.scribe.up.session.UserSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OAuthFilter
extends AuthenticatingFilter {
    private static Logger log = LoggerFactory.getLogger(OAuthFilter.class);
    private String failureUrl;
    private ProvidersDefinition providersDefinition;
    private ShiroUserSession shiroUserSession = new ShiroUserSession();

    public OAuthFilter() {
        ProfileHelper.setKeepRawData((boolean)false);
    }

    protected AuthenticationToken createToken(ServletRequest request, ServletResponse response) throws Exception {
        Map parameters = request.getParameterMap();
        OAuthProvider provider = this.providersDefinition.findProvider(parameters);
        log.debug("provider : {}", (Object)provider);
        OAuthCredential credential = provider.getCredential((UserSession)this.shiroUserSession, parameters);
        log.debug("credential : {}", (Object)credential);
        return new OAuthToken(credential);
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        return this.executeLogin(request, response);
    }

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        return false;
    }

    protected boolean onLoginSuccess(AuthenticationToken token, Subject subject, ServletRequest request, ServletResponse response) throws Exception {
        this.issueSuccessRedirect(request, response);
        return false;
    }

    protected boolean onLoginFailure(AuthenticationToken token, AuthenticationException ae, ServletRequest request, ServletResponse response) {
        Subject subject = this.getSubject(request, response);
        if (subject.isAuthenticated()) {
            try {
                this.issueSuccessRedirect(request, response);
            }
            catch (Exception e) {
                log.error("Cannot redirect to the default success url", (Throwable)e);
            }
        } else {
            try {
                WebUtils.issueRedirect((ServletRequest)request, (ServletResponse)response, (String)this.failureUrl);
            }
            catch (IOException e) {
                log.error("Cannot redirect to failure url : {}", (Object)this.failureUrl, (Object)e);
            }
        }
        return false;
    }

    public void setFailureUrl(String failureUrl) {
        this.failureUrl = failureUrl;
    }

    public void setProvider(OAuthProvider provider) {
        this.providersDefinition = new ProvidersDefinition(provider);
        this.providersDefinition.init();
    }

    public void setProvidersDefinition(ProvidersDefinition providersDefinition) {
        this.providersDefinition = providersDefinition;
        this.providersDefinition.init();
    }
}

