/*
 * Decompiled with CFR 0.152.
 */
package io.buji.oauth;

import io.buji.oauth.OAuthAuthenticationException;
import io.buji.oauth.OAuthToken;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.util.CollectionUtils;
import org.apache.shiro.util.StringUtils;
import org.scribe.up.credential.OAuthCredential;
import org.scribe.up.profile.ProfileHelper;
import org.scribe.up.profile.UserProfile;
import org.scribe.up.provider.OAuthProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuthRealm
extends AuthorizingRealm {
    private static Logger log = LoggerFactory.getLogger(OAuthRealm.class);
    private OAuthProvider provider;
    private String defaultRoles;
    private String defaultPermissions;

    public OAuthRealm() {
        this.setAuthenticationTokenClass(OAuthToken.class);
        ProfileHelper.setKeepRawData((boolean)false);
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        OAuthToken oauthToken = (OAuthToken)authenticationToken;
        if (oauthToken == null) {
            return null;
        }
        OAuthCredential credential = (OAuthCredential)oauthToken.getCredentials();
        log.debug("credential : {}", (Object)credential);
        if (credential == null || !this.provider.getType().equals(credential.getProviderType())) {
            return null;
        }
        UserProfile userProfile = null;
        userProfile = this.provider.getUserProfile(credential);
        log.debug("userProfile : {}", (Object)userProfile);
        if (userProfile == null || !StringUtils.hasText((String)userProfile.getId())) {
            log.error("Unable to get user profile for OAuth credentials : [{}]", (Object)credential);
            throw new OAuthAuthenticationException("Unable to get user profile for OAuth credential : [" + credential + "]");
        }
        String userId = userProfile.getTypedId();
        oauthToken.setUserId(userId);
        List principals = CollectionUtils.asList((Object[])new Serializable[]{userId, userProfile});
        SimplePrincipalCollection principalCollection = new SimplePrincipalCollection((Collection)principals, this.getName());
        return new SimpleAuthenticationInfo((PrincipalCollection)principalCollection, (Object)credential);
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        SimpleAuthorizationInfo simpleAuthorizationInfo = new SimpleAuthorizationInfo();
        simpleAuthorizationInfo.addRoles(this.split(this.defaultRoles));
        simpleAuthorizationInfo.addStringPermissions(this.split(this.defaultPermissions));
        return simpleAuthorizationInfo;
    }

    protected List<String> split(String s) {
        ArrayList<String> list = new ArrayList<String>();
        String[] elements = StringUtils.split((String)s, (char)',');
        if (elements != null && elements.length > 0) {
            for (String element : elements) {
                if (!StringUtils.hasText((String)element)) continue;
                list.add(element.trim());
            }
        }
        return list;
    }

    public void setProvider(OAuthProvider provider) {
        this.provider = provider;
    }

    public void setDefaultRoles(String defaultRoles) {
        this.defaultRoles = defaultRoles;
    }

    public void setDefaultPermissions(String defaultPermissions) {
        this.defaultPermissions = defaultPermissions;
    }
}

