/*
 * Decompiled with CFR 0.152.
 */
package io.buildlogic.wiremock.maven.plugin.mojo;

import io.buildlogic.wiremock.maven.plugin.mojo.ConfigurationMojo;
import io.buildlogic.wiremock.maven.plugin.server.WireMockServer;
import io.buildlogic.wiremock.maven.plugin.util.ClasspathUtil;
import java.util.Arrays;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="run", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class WireMockRunMojo
extends ConfigurationMojo {
    public void execute() throws MojoExecutionException {
        if (this.shouldSkip()) {
            this.getLog().info((CharSequence)"Requested to skip WireMock Maven Plugin execution");
            return;
        }
        this.addRuntimeDependenciesToClasspath();
        String[] rawWireMockParams = this.getAllParams();
        String wireMockParams = this.getFormattedStringFrom(rawWireMockParams);
        String startMessage = String.format("Starting WireMock with following params: %s", wireMockParams);
        this.getLog().info((CharSequence)startMessage);
        WireMockServer wireMock = WireMockServer.getInstance();
        wireMock.run(rawWireMockParams);
        if (this.shouldKeepRunning()) {
            this.keepRunningUntilInterrupted();
        }
    }

    private void addRuntimeDependenciesToClasspath() throws MojoExecutionException {
        ClasspathUtil classpathUtil = new ClasspathUtil();
        classpathUtil.setClasspathElements(this.classpathElements);
        classpathUtil.setDescriptor(this.descriptor);
        classpathUtil.addRuntimeDependenciesToClasspath();
    }

    private String getFormattedStringFrom(String[] array) {
        return Arrays.toString(array).replaceAll("[\\[\\]]", "").replaceAll(", ", " ");
    }

    private void keepRunningUntilInterrupted() {
        this.getLog().info((CharSequence)"WireMock will keep running until interrupted manually...");
        while (true) {
            this.sleepForOneSecond();
        }
    }

    private void sleepForOneSecond() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            this.getLog().error((CharSequence)e.getMessage());
        }
    }
}

