/*
 * Decompiled with CFR 0.152.
 */
package io.blt.util;

import io.blt.util.functional.ThrowingRunnable;
import io.blt.util.functional.ThrowingSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class Ex {
    private Ex() {
        throw new IllegalAccessError("Utility class should be accessed statically and never constructed");
    }

    public static <R, E extends Throwable> R transformExceptions(ThrowingSupplier<R, ? extends Exception> supplier, Function<? super Exception, E> transformer) throws E {
        try {
            return supplier.get();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw (Throwable)transformer.apply(e);
        }
    }

    public static <E extends Throwable> void transformExceptions(ThrowingRunnable<? extends Exception> runnable, Function<? super Exception, E> transformer) throws E {
        Ex.transformExceptions(() -> {
            runnable.run();
            return null;
        }, transformer);
    }

    public static <T, E extends Throwable> T throwIf(T value, Predicate<? super T> predicate, Supplier<? extends E> throwable) throws E {
        if (predicate.test(value)) {
            throw (Throwable)throwable.get();
        }
        return value;
    }

    public static <T, E extends Throwable> T throwUnless(T value, Predicate<? super T> predicate, Supplier<? extends E> throwable) throws E {
        return Ex.throwIf(value, predicate.negate(), throwable);
    }
}

