/*
 * Decompiled with CFR 0.152.
 */
package io.blt.util;

import io.blt.util.functional.ThrowingConsumer;
import io.blt.util.functional.ThrowingSupplier;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class Obj {
    private Obj() {
        throw new IllegalAccessError("Utility class should be accessed statically and never constructed");
    }

    public static <T, E extends Throwable> T poke(T instance, ThrowingConsumer<T, E> consumer) throws E {
        consumer.accept(instance);
        return instance;
    }

    public static <T, E extends Throwable> T tap(Supplier<T> supplier, ThrowingConsumer<T, E> consumer) throws E {
        return Obj.poke(supplier.get(), consumer);
    }

    public static <T, E extends Throwable> T orElseGet(T value, ThrowingSupplier<T, E> supplier) throws E {
        return Objects.nonNull(value) ? value : supplier.get();
    }

    public static <T, E extends Throwable> T orElseOnException(ThrowingSupplier<T, E> supplier, T defaultValue) {
        return supplier.orOnException(defaultValue);
    }

    public static <T, E extends Throwable> T throwIf(T value, Predicate<? super T> predicate, Supplier<? extends E> throwable) throws E {
        if (predicate.test(value)) {
            throw (Throwable)throwable.get();
        }
        return value;
    }

    public static <T, E extends Throwable> T throwUnless(T value, Predicate<? super T> predicate, Supplier<? extends E> throwable) throws E {
        return Obj.throwIf(value, predicate.negate(), throwable);
    }

    public static <T> Optional<T> newInstanceOf(T obj) {
        try {
            return Optional.of(obj.getClass().getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            return Optional.empty();
        }
    }
}

