/*
 * Decompiled with CFR 0.152.
 */
package io.blt.util.stream;

import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public final class SingletonCollectors {
    private SingletonCollectors() {
        throw new IllegalAccessError("Utility class should be accessed statically and never constructed");
    }

    public static <T> SingletonCollector<T, Optional<T>> toOptional() {
        return new SingletonCollector(Container::getOptional);
    }

    public static <T> SingletonCollector<T, T> toNullable() {
        return new SingletonCollector(Container::getValue);
    }

    private static class SingletonCollector<T, R>
    implements Collector<T, Container<T>, R> {
        private final Function<Container<T>, R> finisher;

        public SingletonCollector(Function<Container<T>, R> finisher) {
            this.finisher = finisher;
        }

        @Override
        public Supplier<Container<T>> supplier() {
            return () -> new Container();
        }

        @Override
        public BiConsumer<Container<T>, T> accumulator() {
            return Container::setValue;
        }

        @Override
        public BinaryOperator<Container<T>> combiner() {
            return null;
        }

        @Override
        public Function<Container<T>, R> finisher() {
            return this.finisher;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.emptySet();
        }
    }

    private static final class Container<T> {
        private T value;

        private Container() {
        }

        public T getValue() {
            return this.value;
        }

        public void setValue(T value) {
            if (Objects.nonNull(this.value)) {
                throw new IllegalStateException("Expected stream to contain exactly 0 or 1 elements");
            }
            this.value = value;
        }

        public Optional<T> getOptional() {
            return Optional.ofNullable(this.getValue());
        }
    }
}

