/*
 * Decompiled with CFR 0.152.
 */
package io.blocko.coinstack.storage.core.topology;

import io.blocko.coinstack.storage.core.topology.MasterStatus;
import java.io.Serializable;
import java.util.List;

public class SystemClusterStatus
implements Serializable {
    private MasterStatus leader;
    private List<MasterStatus> peers;
    private int total;
    private int available;

    public SystemClusterStatus(MasterStatus leader, List<MasterStatus> peers) {
        this.leader = leader;
        this.peers = peers;
        this.total = peers.size() + 1;
        this.available = 1;
        for (MasterStatus item : peers) {
            if (!item.isActive()) continue;
            ++this.available;
        }
    }

    public String toString() {
        return "SystemClusterStatus{leader=" + this.leader + ", peers=" + this.peers + ", total=" + this.total + ", available=" + this.available + '}';
    }

    public MasterStatus getLeader() {
        return this.leader;
    }

    public List<MasterStatus> getPeers() {
        return this.peers;
    }

    public int getTotal() {
        return this.total;
    }

    public int getAvailable() {
        return this.available;
    }
}

