/*
 * Decompiled with CFR 0.152.
 */
package io.bestquality.protocol.mock;

import io.bestquality.protocol.mock.MockConnectionRegistry;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.regex.Pattern;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class MockConnectionTest {
    @Mock
    private URLConnection mockAllUrlConnection;
    @Mock
    private URLConnection mockUrlConnection;

    @BeforeClass
    public static void beforeClass() {
        MockConnectionRegistry.installProtocolHandlers();
    }

    @Before
    public void setUp() {
        MockConnectionRegistry.registerMockConnection((Pattern)Pattern.compile("mock://www.host.domain"), (URLConnection)this.mockUrlConnection);
        MockConnectionRegistry.registerMockConnection((URLConnection)this.mockAllUrlConnection);
    }

    @After
    public void tearDown() {
        MockConnectionRegistry.clearMockConnections();
    }

    @Test
    public void shouldHandleMockSchemeUsingWildcardConnection() throws Exception {
        URL url = new URL("mock://www.host.domain");
        Assertions.assertThat((Object)url.openConnection()).isSameAs((Object)this.mockUrlConnection);
        Assertions.assertThat((Object)url.openConnection(Proxy.NO_PROXY)).isSameAs((Object)this.mockUrlConnection);
    }

    @Test
    public void shouldHandleMockSchemeUsingSpecificConnection() throws Exception {
        URL url = new URL("mock://apex.domain");
        Assertions.assertThat((Object)url.openConnection()).isSameAs((Object)this.mockAllUrlConnection);
        Assertions.assertThat((Object)url.openConnection(Proxy.NO_PROXY)).isSameAs((Object)this.mockAllUrlConnection);
    }

    @Test(expected=IOException.class)
    public void shouldClearConnections() throws Exception {
        MockConnectionRegistry.clearMockConnections();
        URL url = new URL("mock://apex.domain");
        url.openConnection();
    }
}

