/*
 * Decompiled with CFR 0.152.
 */
package io.beanmother.java8.converter;

import com.google.common.reflect.TypeToken;
import io.beanmother.core.common.FixtureTemplate;
import io.beanmother.core.common.FixtureValue;
import io.beanmother.core.mapper.FixtureConverter;
import io.beanmother.core.util.TypeTokenUtils;
import java.util.List;
import java.util.Optional;

public class OptionalTypeFixtureConverter
implements FixtureConverter {
    private FixtureConverter fixtureConverter;

    public OptionalTypeFixtureConverter(FixtureConverter converter) {
        this.fixtureConverter = converter;
    }

    public Object convert(FixtureTemplate fixtureTemplate, TypeToken typeToken) {
        if (typeToken.getRawType() != Optional.class) {
            return this.fixtureConverter.convert(fixtureTemplate, typeToken);
        }
        List types = TypeTokenUtils.extractGenericTypeTokens((TypeToken)typeToken);
        if (types.isEmpty()) {
            if (fixtureTemplate instanceof FixtureValue) {
                Object value = ((FixtureValue)fixtureTemplate).getValue();
                return Optional.of(value);
            }
            return null;
        }
        return Optional.of(this.fixtureConverter.convert(fixtureTemplate, (TypeToken)types.get(0)));
    }
}

