/*
 * Decompiled with CFR 0.152.
 */
package io.beanmother.java8.converter;

import com.google.common.reflect.TypeToken;
import io.beanmother.core.converter.AbstractConverter;
import io.beanmother.core.converter.Converter;
import io.beanmother.core.converter.ConverterModule;
import io.beanmother.core.converter.std.NumberToNumberConverter;
import io.beanmother.core.converter.std.StringToNumberConverter;
import java.util.HashSet;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;

public class JavaOptionalConverterModule
implements ConverterModule {
    private static final Converter numberConverter = new NumberToNumberConverter();
    private static final Converter stringToNumberConverter = new StringToNumberConverter();
    private static final Set<Converter> converters = new HashSet<Converter>();

    public Set<Converter> getConverters() {
        return converters;
    }

    static {
        converters.add((Converter)new NumberToOptionalIntConverter());
        converters.add((Converter)new NumberToOptionalDoubleConverter());
        converters.add((Converter)new NumberToOptionalLongConverter());
        converters.add((Converter)new StringToOptionalIntConverter());
        converters.add((Converter)new StringToOptionalDoubleConverter());
        converters.add((Converter)new StringToOptionalLongConverter());
    }

    public static class StringToOptionalLongConverter
    extends AbstractConverter {
        public Object convert(Object source, TypeToken<?> targetTypeToken) {
            Object converted = stringToNumberConverter.convert(source, TypeToken.of(Long.class));
            if (converted == null) {
                return OptionalLong.empty();
            }
            return OptionalLong.of((Long)converted);
        }

        public boolean canHandle(Object source, TypeToken<?> targetTypeToken) {
            return stringToNumberConverter.canHandle(source, TypeToken.of(Long.class)) && targetTypeToken.equals((Object)TypeToken.of(OptionalLong.class));
        }
    }

    public static class StringToOptionalDoubleConverter
    extends AbstractConverter {
        public Object convert(Object source, TypeToken<?> targetTypeToken) {
            Object converted = stringToNumberConverter.convert(source, TypeToken.of(Double.class));
            if (converted == null) {
                return OptionalDouble.empty();
            }
            return OptionalDouble.of((Double)converted);
        }

        public boolean canHandle(Object source, TypeToken<?> targetTypeToken) {
            return stringToNumberConverter.canHandle(source, TypeToken.of(Double.class)) && targetTypeToken.equals((Object)TypeToken.of(OptionalDouble.class));
        }
    }

    public static class StringToOptionalIntConverter
    extends AbstractConverter {
        public Object convert(Object source, TypeToken<?> targetTypeToken) {
            Object converted = stringToNumberConverter.convert(source, TypeToken.of(Integer.class));
            if (converted == null) {
                return OptionalInt.empty();
            }
            return OptionalInt.of((Integer)converted);
        }

        public boolean canHandle(Object source, TypeToken<?> targetTypeToken) {
            return stringToNumberConverter.canHandle(source, TypeToken.of(Integer.class)) && targetTypeToken.equals((Object)TypeToken.of(OptionalInt.class));
        }
    }

    public static class NumberToOptionalLongConverter
    extends AbstractConverter {
        public Object convert(Object source, TypeToken<?> targetTypeToken) {
            Object converted = numberConverter.convert(source, TypeToken.of(Long.class));
            if (converted == null) {
                return OptionalLong.empty();
            }
            return OptionalLong.of((Long)converted);
        }

        public boolean canHandle(Object source, TypeToken<?> targetTypeToken) {
            return numberConverter.canHandle(source, TypeToken.of(Long.class)) && targetTypeToken.equals((Object)TypeToken.of(OptionalLong.class));
        }
    }

    public static class NumberToOptionalDoubleConverter
    extends AbstractConverter {
        public Object convert(Object source, TypeToken<?> targetTypeToken) {
            Object converted = numberConverter.convert(source, TypeToken.of(Double.class));
            if (converted == null) {
                return OptionalDouble.empty();
            }
            return OptionalDouble.of((Double)converted);
        }

        public boolean canHandle(Object source, TypeToken<?> targetTypeToken) {
            return numberConverter.canHandle(source, TypeToken.of(Double.class)) && targetTypeToken.equals((Object)TypeToken.of(OptionalDouble.class));
        }
    }

    public static class NumberToOptionalIntConverter
    extends AbstractConverter {
        public Object convert(Object source, TypeToken<?> targetTypeToken) {
            Object converted = numberConverter.convert(source, TypeToken.of(Integer.class));
            if (converted == null) {
                return OptionalInt.empty();
            }
            return OptionalInt.of((Integer)converted);
        }

        public boolean canHandle(Object source, TypeToken<?> targetTypeToken) {
            return numberConverter.canHandle(source, TypeToken.of(Integer.class)) && targetTypeToken.equals((Object)TypeToken.of(OptionalInt.class));
        }
    }
}

