/*
 * Decompiled with CFR 0.152.
 */
package io.beanmother.java8.converter;

import io.beanmother.core.converter.AbstractGenericConverter;
import io.beanmother.core.converter.Converter;
import io.beanmother.core.converter.ConverterModule;
import io.beanmother.core.converter.std.StringToDateConverter;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class JavaTimeConverterModule
implements ConverterModule {
    private static final StringToDateConverter stringToDateConverter = new StringToDateConverter();
    private static final ZoneId DEFAULT_TIMEZONE = ZoneId.systemDefault();
    private static final Set<Converter> converters = new HashSet<Converter>();

    public Set<Converter> getConverters() {
        return converters;
    }

    private static LocalDateTime convertDateToLocalDateTime(Date source) {
        return LocalDateTime.ofInstant(source.toInstant(), DEFAULT_TIMEZONE);
    }

    static {
        converters.add((Converter)new DateToLocalDateTimeConverter());
        converters.add((Converter)new DateToLocalTimeConverter());
        converters.add((Converter)new DateToLocalDateConverter());
        converters.add((Converter)new StringToLocalDateTimeConverter());
        converters.add((Converter)new StringToLocalTimeConverter());
        converters.add((Converter)new StringToLocalDateConverter());
    }

    public static class StringToLocalDateConverter
    extends AbstractGenericConverter<String, LocalDate> {
        public LocalDate convert(String source) {
            return JavaTimeConverterModule.convertDateToLocalDateTime(stringToDateConverter.convert(source)).toLocalDate();
        }
    }

    public static class StringToLocalTimeConverter
    extends AbstractGenericConverter<String, LocalTime> {
        public LocalTime convert(String source) {
            return JavaTimeConverterModule.convertDateToLocalDateTime(stringToDateConverter.convert(source)).toLocalTime();
        }
    }

    public static class StringToLocalDateTimeConverter
    extends AbstractGenericConverter<String, LocalDateTime> {
        public LocalDateTime convert(String source) {
            return JavaTimeConverterModule.convertDateToLocalDateTime(stringToDateConverter.convert(source));
        }
    }

    public static class DateToLocalDateConverter
    extends AbstractGenericConverter<Date, LocalDate> {
        public LocalDate convert(Date source) {
            return JavaTimeConverterModule.convertDateToLocalDateTime(source).toLocalDate();
        }
    }

    public static class DateToLocalTimeConverter
    extends AbstractGenericConverter<Date, LocalTime> {
        public LocalTime convert(Date source) {
            return JavaTimeConverterModule.convertDateToLocalDateTime(source).toLocalTime();
        }
    }

    public static class DateToLocalDateTimeConverter
    extends AbstractGenericConverter<Date, LocalDateTime> {
        public LocalDateTime convert(Date source) {
            return JavaTimeConverterModule.convertDateToLocalDateTime(source);
        }
    }
}

