/*
 * Decompiled with CFR 0.152.
 */
package io.bayonet.helpers;

import com.google.gson.Gson;
import io.bayonet.exceptions.BayonetException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;

public class HttpHelper {
    private static final String BASE_URL = "https://api.bayonet.io/v";
    private static final String BASE_URL_DEVICE_FINGERPRINT = "https://fingerprinting.bayonet.io/v";
    private static final String USER_AGENT = "OfficialBayonetJavaSDK";
    private int response_code;
    private String response_json;

    public void request(Object params, String route, String api_version) throws BayonetException {
        if (params == null) {
            throw new BayonetException(-1, "params sent to the post request cannot be null", -1);
        }
        if (route == null) {
            throw new BayonetException(-1, "Internal SDK error. The Http client implementation is incorrect. Please contact the Bayonet team to report this bug", -1);
        }
        String params_as_json = new Gson().toJson(params);
        String url = (route.equals("get-device-data") ? BASE_URL_DEVICE_FINGERPRINT : BASE_URL) + api_version + "/" + route;
        try {
            String inputLine;
            URL obj = new URL(url);
            HttpsURLConnection con = (HttpsURLConnection)obj.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("User-Agent", USER_AGENT);
            con.setRequestProperty("Content-Type", "application/json; charset=utf-8");
            con.setDoOutput(true);
            OutputStreamWriter writer = new OutputStreamWriter(con.getOutputStream(), "UTF-8");
            writer.write(params_as_json);
            writer.close();
            int response_code = con.getResponseCode();
            BufferedReader in = response_code == 200 ? new BufferedReader(new InputStreamReader(con.getInputStream())) : new BufferedReader(new InputStreamReader(con.getErrorStream()));
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            this.response_code = response_code;
            this.response_json = response.toString();
        }
        catch (IOException e) {
            throw new BayonetException(-1, "POST request to the Bayonet API endpoint (" + url + ") failed with the following error :\n" + e.getMessage(), -1);
        }
    }

    public int getResponseCode() {
        return this.response_code;
    }

    public String getResponseJson() {
        return this.response_json;
    }
}

