/*
 * Decompiled with CFR 0.152.
 */
package io.bayonet.clients;

import com.google.gson.Gson;
import io.bayonet.Bayonet;
import io.bayonet.exceptions.BayonetException;
import io.bayonet.helpers.HttpHelper;
import io.bayonet.model.base.BaseResponse;
import io.bayonet.model.base.RulesTriggered;
import io.bayonet.model.ecommerce.ConsultResponse;
import io.bayonet.model.ecommerce.EcommerceConsultRequest;
import io.bayonet.model.ecommerce.EcommerceFeedbackHistoricalRequest;
import io.bayonet.model.ecommerce.EcommerceUpdateTransactionRequest;
import java.util.HashMap;

public class EcommerceClient
extends Bayonet {
    private Integer http_response_code;
    private Integer reason_code;
    private String reason_message;
    private RulesTriggered rules_triggered;
    private String decision;
    private String bayonet_tracking_id;
    private HashMap<String, Object> payload;
    private static final String SUB_PATH = "sigma";

    public EcommerceClient(String api_key, String api_version) {
        super(api_key, api_version);
    }

    public void consult(EcommerceConsultRequest params) throws BayonetException {
        this.validateClientConfig();
        if (params == null) {
            throw new BayonetException(-1, "params sent to the post request cannot be null", -1);
        }
        this.resetClass();
        params.setApiKey(this.api_key);
        HttpHelper http_helper = new HttpHelper();
        http_helper.request(params, "sigma/consult", this.api_version);
        this.http_response_code = http_helper.getResponseCode();
        String response_json = http_helper.getResponseJson();
        if (response_json != null) {
            if (this.http_response_code == 200) {
                ConsultResponse response = (ConsultResponse)new Gson().fromJson(response_json, ConsultResponse.class);
                this.reason_code = response.getReason_code();
                this.reason_message = response.getReason_message();
                this.rules_triggered = response.getRulesTriggered();
                this.decision = response.getDecision();
                this.bayonet_tracking_id = response.getBayonet_tracking_id();
                try {
                    this.payload = response.getPayloadAsMap();
                }
                catch (IllegalAccessException e) {
                    throw new BayonetException(-1, "Internal SDK error. Please contact the Bayonet team to report this bug", -1);
                }
            } else if (this.http_response_code == 400 || this.http_response_code == 500) {
                BaseResponse response = (BaseResponse)new Gson().fromJson(response_json, BaseResponse.class);
                throw new BayonetException(response.getReason_code(), response.getReason_message(), this.http_response_code);
            }
        } else {
            throw new BayonetException(-1, "Could not fetch a response from the Bayonet API. Please try again after some time", -1);
        }
    }

    public void feedbackHistorical(EcommerceFeedbackHistoricalRequest params) throws BayonetException {
        this.validateClientConfig();
        if (params == null) {
            throw new BayonetException(-1, "params sent to the post request cannot be null", -1);
        }
        this.resetClass();
        params.setApiKey(this.api_key);
        HttpHelper http_helper = new HttpHelper();
        http_helper.request(params, "sigma/feedback-historical", this.api_version);
        this.http_response_code = http_helper.getResponseCode();
        String response_json = http_helper.getResponseJson();
        this.processGenericResponse(response_json);
    }

    public void updateTransaction(EcommerceUpdateTransactionRequest params) throws BayonetException {
        this.validateClientConfig();
        if (params == null) {
            throw new BayonetException(-1, "params sent to the post request cannot be null", -1);
        }
        this.resetClass();
        params.setApiKey(this.api_key);
        HttpHelper http_helper = new HttpHelper();
        http_helper.request(params, "sigma/update-transaction", this.api_version);
        this.http_response_code = http_helper.getResponseCode();
        String response_json = http_helper.getResponseJson();
        this.processGenericResponse(response_json);
    }

    private void processGenericResponse(String response_json) throws BayonetException {
        if (response_json != null) {
            BaseResponse response = (BaseResponse)new Gson().fromJson(response_json, BaseResponse.class);
            this.reason_code = response.getReason_code();
            this.reason_message = response.getReason_message();
            if (this.http_response_code != 200) {
                throw new BayonetException(this.reason_code, this.reason_message, this.http_response_code);
            }
        } else {
            throw new BayonetException(-1, "Could not fetch a response from the Bayonet API. Please try again after some time", -1);
        }
    }

    private void resetClass() {
        this.reason_code = null;
        this.reason_message = null;
        this.rules_triggered = null;
        this.decision = null;
        this.payload = null;
        this.bayonet_tracking_id = null;
    }

    public Integer getHttpResponseCode() {
        return this.http_response_code;
    }

    public Integer getReasonCode() {
        return this.reason_code;
    }

    public String getReasonMessage() {
        return this.reason_message;
    }

    public String getBayonetTrackingId() {
        return this.bayonet_tracking_id;
    }

    public RulesTriggered getRulesTriggered() {
        return this.rules_triggered;
    }

    public String getDecision() {
        return this.decision;
    }

    public HashMap<String, Object> getResponsePayload() {
        return this.payload;
    }
}

