/*
 * Decompiled with CFR 0.152.
 */
package io.bayonet.clients;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.bayonet.Bayonet;
import io.bayonet.exceptions.BayonetException;
import io.bayonet.helpers.HttpHelper;
import io.bayonet.model.device_fingerprint.DeviceFingerprintRequest;
import java.util.HashMap;

public class DeviceFingerprintClient
extends Bayonet {
    private Integer http_response_code;
    private Integer reason_code;
    private String reason_message;
    private String bayonet_fingerprint;
    private HashMap<String, Object> device_info;

    public DeviceFingerprintClient(String api_key, String api_version) {
        super(api_key, api_version);
    }

    public void queryFingerprintData(DeviceFingerprintRequest params) throws BayonetException {
        this.validateClientConfig();
        if (params == null) {
            throw new BayonetException(-1, "params sent to the post request cannot be null", -1);
        }
        this.resetClass();
        params.setApiKey(this.api_key);
        HttpHelper http_helper = new HttpHelper();
        http_helper.request(params, "get-fingerprint-data", this.api_version);
        this.http_response_code = http_helper.getResponseCode();
        String response_json = http_helper.getResponseJson();
        if (response_json != null) {
            HashMap response_map = (HashMap)new Gson().fromJson(response_json, new TypeToken<HashMap<String, Object>>(){}.getType());
            if (this.http_response_code == 200) {
                this.device_info = response_map;
                this.reason_code = 0;
                this.reason_message = "success";
                if (response_map.containsKey("bayonet_fingerprint")) {
                    this.bayonet_fingerprint = response_map.get("bayonet_fingerprint").toString();
                }
            } else if (this.http_response_code == 400 || this.http_response_code == 500) {
                if (response_map.containsKey("status")) {
                    throw new BayonetException(-1, response_map.get("status").toString(), this.http_response_code);
                }
                throw new BayonetException(-1, "Could not fetch a response from the Bayonet API. Please try again after some time", -1);
            }
        } else {
            throw new BayonetException(-1, "Could not fetch a response from the Bayonet API. Please try again after some time", -1);
        }
    }

    private void resetClass() {
        this.reason_code = null;
        this.reason_message = null;
        this.bayonet_fingerprint = null;
        this.device_info = null;
    }

    public Integer getHttpResponseCode() {
        return this.http_response_code;
    }

    public Integer getReasonCode() {
        return this.reason_code;
    }

    public String getReasonMessage() {
        return this.reason_message;
    }

    public String getBayonetFingerprint() {
        return this.bayonet_fingerprint;
    }

    public HashMap<String, Object> getDeviceInfo() {
        return this.device_info;
    }
}

