/*
 * Decompiled with CFR 0.152.
 */
package io.bayonet.clients;

import com.google.gson.Gson;
import io.bayonet.Bayonet;
import io.bayonet.exceptions.BayonetException;
import io.bayonet.helpers.HttpHelper;
import io.bayonet.model.base.BaseResponse;
import io.bayonet.model.lending.LendingConsultRequest;
import io.bayonet.model.lending.LendingConsultResponse;
import io.bayonet.model.lending.LendingFeedbackHistoricalRequest;
import io.bayonet.model.lending.LendingFeedbackRequest;
import io.bayonet.model.lending.LendingReportTransactionRequest;
import java.net.URLStreamHandler;
import java.util.HashMap;

public class LendingClient
extends Bayonet {
    private Integer http_response_code;
    private Integer reason_code;
    private String reason_message;
    private HashMap<String, Object> payload;
    private static final String SUB_PATH = "lending";
    private URLStreamHandler custom_url_stream_handler = null;

    public LendingClient(String api_key, String api_version) {
        super(api_key, api_version);
    }

    public LendingClient(String api_key, String api_version, URLStreamHandler custom_url_stream_handler) {
        super(api_key, api_version);
        this.custom_url_stream_handler = custom_url_stream_handler;
    }

    public void reportTransaction(LendingReportTransactionRequest params) throws BayonetException {
        this.validateClientConfig();
        if (params == null) {
            throw new BayonetException(-1, "params sent to the post request cannot be null", -1);
        }
        this.resetClass();
        params.setApiKey(this.api_key);
        HttpHelper http_helper = new HttpHelper();
        http_helper.request(params, "lending/transaction/report", this.api_version, this.custom_url_stream_handler);
        this.http_response_code = http_helper.getResponseCode();
        String response_json = http_helper.getResponseJson();
        this.processGenericResponse(response_json);
    }

    public void reportTransactionAndConsult(LendingReportTransactionRequest params) throws BayonetException {
        this.validateClientConfig();
        if (params == null) {
            throw new BayonetException(-1, "params sent to the post request cannot be null", -1);
        }
        this.resetClass();
        params.setApiKey(this.api_key);
        HttpHelper http_helper = new HttpHelper();
        http_helper.request(params, "lending/transaction/report?consult=true", this.api_version, this.custom_url_stream_handler);
        this.http_response_code = http_helper.getResponseCode();
        String response_json = http_helper.getResponseJson();
        this.processConsultResponse(response_json);
    }

    public void consult(LendingConsultRequest params) throws BayonetException {
        this.validateClientConfig();
        if (params == null) {
            throw new BayonetException(-1, "params sent to the post request cannot be null", -1);
        }
        this.resetClass();
        params.setApiKey(this.api_key);
        HttpHelper http_helper = new HttpHelper();
        http_helper.request(params, "lending/consult", this.api_version, this.custom_url_stream_handler);
        this.http_response_code = http_helper.getResponseCode();
        String response_json = http_helper.getResponseJson();
        this.processConsultResponse(response_json);
    }

    public void feedback(LendingFeedbackRequest params) throws BayonetException {
        this.validateClientConfig();
        if (params == null) {
            throw new BayonetException(-1, "params sent to the post request cannot be null", -1);
        }
        this.resetClass();
        params.setApiKey(this.api_key);
        HttpHelper http_helper = new HttpHelper();
        http_helper.request(params, "lending/feedback", this.api_version, this.custom_url_stream_handler);
        this.http_response_code = http_helper.getResponseCode();
        String response_json = http_helper.getResponseJson();
        this.processGenericResponse(response_json);
    }

    public void feedbackHistorical(LendingFeedbackHistoricalRequest params) throws BayonetException {
        this.validateClientConfig();
        if (params == null) {
            throw new BayonetException(-1, "params sent to the post request cannot be null", -1);
        }
        this.resetClass();
        params.setApiKey(this.api_key);
        HttpHelper http_helper = new HttpHelper();
        http_helper.request(params, "lending/feedback-historical", this.api_version, this.custom_url_stream_handler);
        this.http_response_code = http_helper.getResponseCode();
        String response_json = http_helper.getResponseJson();
        this.processGenericResponse(response_json);
    }

    private void processGenericResponse(String response_json) throws BayonetException {
        if (response_json != null) {
            BaseResponse response = (BaseResponse)new Gson().fromJson(response_json, BaseResponse.class);
            this.reason_code = response.getReason_code();
            this.reason_message = response.getReason_message();
            if (this.http_response_code != 200) {
                throw new BayonetException(this.reason_code, this.reason_message, this.http_response_code);
            }
        } else {
            throw new BayonetException(-1, "Could not fetch a response from the Bayonet API. Please try again after some time", -1);
        }
    }

    private void processConsultResponse(String response_json) throws BayonetException {
        if (response_json != null) {
            if (this.http_response_code == 200) {
                LendingConsultResponse consult_response = (LendingConsultResponse)new Gson().fromJson(response_json, LendingConsultResponse.class);
                if (consult_response.getReasonCode() != null && consult_response.getReasonMessage() != null) {
                    this.reason_code = consult_response.getReasonCode();
                    this.reason_message = consult_response.getReasonMessage();
                    this.payload = consult_response.getPayloadAsMap();
                }
            } else if (this.http_response_code == 400 || this.http_response_code == 500) {
                BaseResponse response = (BaseResponse)new Gson().fromJson(response_json, BaseResponse.class);
                throw new BayonetException(response.getReason_code(), response.getReason_message(), this.http_response_code);
            }
        } else {
            throw new BayonetException(-1, "Could not fetch a response from the Bayonet API. Please try again after some time", -1);
        }
    }

    private void resetClass() {
        this.reason_code = null;
        this.reason_message = null;
        this.payload = null;
    }

    public Integer getHttpResponseCode() {
        return this.http_response_code;
    }

    public Integer getReasonCode() {
        return this.reason_code;
    }

    public String getReasonMessage() {
        return this.reason_message;
    }

    public HashMap<String, Object> getResponsePayload() {
        return this.payload;
    }
}

