/*
 * Decompiled with CFR 0.152.
 */
package io.bayonet.model.lending;

import java.util.HashMap;

public class LendingConsultResponse {
    private Integer reason_code;
    private String reason_message;
    private Payload payload;

    public Integer getReasonCode() {
        return this.reason_code;
    }

    public String getReasonMessage() {
        return this.reason_message;
    }

    public HashMap<String, Object> getPayloadAsMap() {
        HashMap<String, Object> payload_map = new HashMap<String, Object>();
        payload_map.put("is_blocked", this.payload.is_blocked);
        payload_map.put("alerts_raised", this.payload.alerts_raised);
        payload_map.put("parameters_used", this.payload.parameters_used);
        payload_map.put("activity", this.payload.activity.getUserActivityAsMap());
        return payload_map;
    }

    class Payload {
        boolean is_blocked;
        HashMap<String, Integer> alerts_raised;
        HashMap<String, Integer> parameters_used;
        UserActivity activity;

        Payload() {
        }
    }

    class UserActivity {
        Timestamps timestamps;
        Requests requests;

        UserActivity() {
        }

        HashMap<String, Object> getUserActivityAsMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("timestamps", this.timestamps.getTimestampsAsMap());
            map.put("requests", this.requests.getRequestsAsMap());
            return map;
        }
    }

    class RequestsHistoric {
        Integer last_2_weeks;
        Integer last_2_weeks_unique_sites;
        Integer last_1_month;
        Integer last_1_month_unique_sites;
        Integer last_3_months;
        Integer last_3_months_unique_sites;
        Integer last_6_months;
        Integer last_6_months_unique_sites;

        RequestsHistoric() {
        }

        HashMap<String, Integer> getRequestsHistoricAsMap() {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("last_2_weeks", this.last_2_weeks);
            map.put("last_2_weeks_unique_sites", this.last_2_weeks_unique_sites);
            map.put("last_1_month", this.last_1_month);
            map.put("last_1_month_unique_sites", this.last_1_month_unique_sites);
            map.put("last_3_months", this.last_3_months);
            map.put("last_3_months_unique_sites", this.last_3_months_unique_sites);
            map.put("last_6_months", this.last_6_months);
            map.put("last_6_months_unique_sites", this.last_6_months_unique_sites);
            return map;
        }
    }

    class RequestsRecent {
        Integer last_5_mins;
        Integer last_5_mins_unique_sites;
        Integer last_15_mins;
        Integer last_15_mins_unique_sites;
        Integer last_1_hour;
        Integer last_1_hour_unique_sites;
        Integer last_1_day;
        Integer last_1_day_unique_sites;

        RequestsRecent() {
        }

        HashMap<String, Integer> getRequestsRecentAsMap() {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("last_5_mins", this.last_5_mins);
            map.put("last_5_mins_unique_sites", this.last_5_mins_unique_sites);
            map.put("last_15_mins", this.last_15_mins);
            map.put("last_15_mins_unique_sites", this.last_15_mins_unique_sites);
            map.put("last_1_hour", this.last_1_hour);
            map.put("last_1_hour_unique_sites", this.last_1_hour_unique_sites);
            map.put("last_1_day", this.last_1_day);
            map.put("last_1_day_unique_sites", this.last_1_day_unique_sites);
            return map;
        }
    }

    class Requests {
        Integer total;
        Integer total_unique_sites;
        RequestsRecent recent;
        RequestsHistoric historic;

        Requests() {
        }

        HashMap<String, Object> getRequestsAsMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("total", this.total);
            map.put("total_unique_sites", this.total_unique_sites);
            map.put("recent", this.recent.getRequestsRecentAsMap());
            map.put("historic", this.historic.getRequestsHistoricAsMap());
            return map;
        }
    }

    class Timestamps {
        Long first_seen_on_network;
        Long last_seen_on_network;
        Long first_seen_on_client;
        Long last_seen_on_client;

        Timestamps() {
        }

        HashMap<String, Long> getTimestampsAsMap() {
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put("first_seen_on_network", this.first_seen_on_network);
            map.put("last_seen_on_network", this.last_seen_on_network);
            map.put("first_seen_on_client", this.first_seen_on_client);
            map.put("last_seen_on_client", this.last_seen_on_client);
            return map;
        }
    }
}

