package io.bayonet.model.ecommerce;

import io.bayonet.model.base.*;

import java.util.ArrayList;
import java.util.HashMap;

/**
 * Created by imranarshad on 11/27/17
 */

public class EcommerceConsultRequest {


    /** Auth info of the client */

    private AuthModel auth;


    /** Consumer email */

    private String email;


    /** Consumer name as received by a client */

    private String consumer_name;


    /** Consumer ID used to identify this user in the client's internal system */

    private String consumer_internal_id;


    /** Name on the card being processed by the client */

    private String cardholder_name;


    /** Consumer phone number */

    private String telephone;


    /** Card being used for the payment */

    private String card_number;


    /** Bin number of the card being used - sent in case the client does not have the full card number */

    private String card_bin;


    /** Last 4 digits of the card being used - sent in case the client does not have the full card number */

    private String card_last_4;


    /** Hash of full card number - generated by the client */

    private String card_hash;


    /** Amount of the transaction received by the client */

    private Double transaction_amount;


    /** Three letter ISO-4217 currency code */

    private String currency_code;


    /** Consumer's IP address */

    private String ip_address;


    /** Consumer shipping address */

    private Address shipping_address;


    /** Consumer billing address */

    private Address billing_address;


    /** Payment method being used on the client by the consumer */

    private String payment_method;


    /** Different methods within a payment method (e.g. usage type of card (chip, magnetic bank, nfc, etc.)   */

    private String payment_sub_method;


    /** The coupon code used by the customer */

    private String coupon;


    /** Did the customer purchasing something choose the option to get expedited shipping - true or false */

    private Boolean expedited_shipping;


    /** The payment gateway used by the client for processing payments */

    private String payment_gateway;


    /** Payment metadata - frequency, subscription type, etc. */

    private PaymentMetadata payment_metadata;


    /** The channel through which the transaction is being made - ecommerce, pos or mpos */

    private String channel;


    /** The merchant that received the transaction */

    private Merchant merchant;


    /** The product that a customer is trying to buy on a client's site */

    private ArrayList<Product> products;


    /** Device fingerprint token generated by Bayonet's Device fingerprinting API */

    private String bayonet_fingerprint_token;


    /** Internal id of a transaction maintained by the client */

    private String transaction_id;


    /** Internal id of an order maintained by the client */

    private String order_id;


    /** Transaction type - payment or credit_request */

    private String transaction_type;


    /** Payment terminal - used for pos, mpos transactions */

    private PaymentTerminal payment_terminal;


    /** What happened with the consumer transaction on the client - success, cancelled, suspected_fraud, bank_decline or chargeback */

    private String transaction_status;


    /** Code sent back by the processing bank to the client when a transaction is processed */

    private String bank_auth_code;


    /** Payment decline reason received by the client from the processing bank - should be sent when transaction_status = bank_decline */

    private String bank_decline_reason;


    /** Payment decline code received by the client from the processing bank */

    private String bank_decline_code;


    /** Payment decline description */

    private String bank_decline_description;


    /** Custom fields */

    private HashMap<String, String> custom_fields;


    /**
     * Getter and Setter methods
     */

    public void setApiKey(String api_key) {
        this.auth = new AuthModel(api_key);
    }

    public EcommerceConsultRequest setEmail(String email) {
        this.email = email;
        return this;
    }

    public EcommerceConsultRequest setConsumerName(String consumer_name) {
        this.consumer_name = consumer_name;
        return this;
    }

    public EcommerceConsultRequest setConsumerInternalId(String consumer_internal_id) {
        this.consumer_internal_id = consumer_internal_id;
        return this;
    }

    public EcommerceConsultRequest setCardholderName(String cardholder_name) {
        this.cardholder_name = cardholder_name;
        return this;
    }

    public EcommerceConsultRequest setTelephone(String telephone) {
        this.telephone = telephone;
        return this;
    }

    public EcommerceConsultRequest setCardNumber(String card_number) {
        this.card_number = card_number;
        return this;
    }

    public EcommerceConsultRequest setCardBin(String card_bin) {
        this.card_bin = card_bin;
        return this;
    }

    public EcommerceConsultRequest setCardLast4(String card_last_4) {
        this.card_last_4 = card_last_4;
        return this;
    }

    public EcommerceConsultRequest setCardHash(String card_hash) {
        this.card_hash = card_hash;
        return this;
    }

    public EcommerceConsultRequest setTransactionAmount(Double transaction_amount) {
        this.transaction_amount = transaction_amount;
        return this;
    }

    public EcommerceConsultRequest setCurrencyCode(String currency_code) {
        this.currency_code = currency_code;
        return this;
    }

    public EcommerceConsultRequest setIPAddress(String ip_address) {
        this.ip_address = ip_address;
        return this;
    }

    public EcommerceConsultRequest setShippingAddress(Address shipping_address) {
        this.shipping_address = shipping_address;
        return this;
    }

    public EcommerceConsultRequest setBillingAddress(Address billing_address) {
        this.billing_address = billing_address;
        return this;
    }

    public EcommerceConsultRequest setPaymentMethod(String payment_method) {
        this.payment_method = payment_method;
        return this;
    }

    public EcommerceConsultRequest setPaymentSubMethod(String payment_sub_method) {
        this.payment_sub_method = payment_sub_method;
        return this;
    }

    public EcommerceConsultRequest setPaymentMetadata(PaymentMetadata payment_metadata) {
        this.payment_metadata = payment_metadata;
        return this;
    }

    public EcommerceConsultRequest setCoupon(String coupon) {
        this.coupon = coupon;
        return this;
    }

    public EcommerceConsultRequest setExpeditedShipping(Boolean expedited_shipping) {
        this.expedited_shipping = expedited_shipping;
        return this;
    }

    public EcommerceConsultRequest setPaymentGateway(String payment_gateway) {
        this.payment_gateway = payment_gateway;
        return this;
    }

    public EcommerceConsultRequest setChannel(String channel) {
        this.channel = channel;
        return this;
    }

    public EcommerceConsultRequest setMerchant(Merchant merchant) {
        this.merchant = merchant;
        return this;
    }

    public EcommerceConsultRequest setProducts(ArrayList<Product> products) {
        this.products = products;
        return this;
    }

    public EcommerceConsultRequest setBayonetFingerprintToken(String bayonet_fingerprint_token) {
        this.bayonet_fingerprint_token = bayonet_fingerprint_token;
        return this;
    }

    public EcommerceConsultRequest setTransactionId(String transaction_id) {
        this.transaction_id = transaction_id;
        return this;
    }

    public EcommerceConsultRequest setOrderId(String order_id) {
        this.order_id = order_id;
        return this;
    }

    public EcommerceConsultRequest setTransactionType(String transaction_type) {
        this.transaction_type = transaction_type;
        return this;
    }

    public EcommerceConsultRequest setPaymentTerminal(PaymentTerminal payment_terminal) {
        this.payment_terminal = payment_terminal;
        return this;
    }

    public EcommerceConsultRequest setTransactionStatus(String transaction_status) {
        this.transaction_status = transaction_status;
        return this;
    }

    public EcommerceConsultRequest setBankAuthCode(String bank_auth_code) {
        this.bank_auth_code = bank_auth_code;
        return this;
    }

    public EcommerceConsultRequest setBankDeclineReason(String bank_decline_reason) {
        this.bank_decline_reason = bank_decline_reason;
        return this;
    }

    public EcommerceConsultRequest setBankDeclineCode(String bank_decline_code) {
        this.bank_decline_code = bank_decline_code;
        return this;
    }

    public EcommerceConsultRequest setBankDeclineDescription(String bank_decline_description) {
        this.bank_decline_description = bank_decline_description;
        return this;
    }

    public EcommerceConsultRequest setCustomFields(HashMap<String, String> custom_fields) {
        this.custom_fields = custom_fields;
        return this;
    }
}
