/*
 * Decompiled with CFR 0.152.
 */
package io.bayonet.clients;

import com.google.gson.Gson;
import io.bayonet.Bayonet;
import io.bayonet.exceptions.BayonetException;
import io.bayonet.helpers.HttpHelper;
import io.bayonet.model.base.BaseResponse;
import io.bayonet.model.ecommerce.ConsultingResponse;
import io.bayonet.model.ecommerce.EcommerceConsultingRequest;
import io.bayonet.model.ecommerce.EcommerceFeedbackHistoricalRequest;
import io.bayonet.model.ecommerce.EcommerceFeedbackRequest;
import io.bayonet.model.ecommerce.EcommerceUpdateTransactionRequest;
import java.util.ArrayList;
import java.util.HashMap;

public class EcommerceClient
extends Bayonet {
    private Integer http_response_code;
    private Integer reason_code;
    private String reason_message;
    private String feedback_api_trans_code;
    private ArrayList<String> rules_triggered;
    private String risk_level;
    private HashMap<String, Object> payload;

    public EcommerceClient(String api_key, String api_version) {
        super(api_key, api_version);
    }

    public void consulting(EcommerceConsultingRequest params) throws BayonetException {
        this.validateClientConfig();
        if (params == null) {
            throw new BayonetException(-1, "params sent to the post request cannot be null", -1);
        }
        this.resetClass();
        params.setApiKey(this.api_key);
        HttpHelper http_helper = new HttpHelper();
        http_helper.request(params, "consulting", this.api_version);
        this.http_response_code = http_helper.getResponseCode();
        String response_json = http_helper.getResponseJson();
        if (response_json != null) {
            if (this.http_response_code == 200) {
                ConsultingResponse response = (ConsultingResponse)new Gson().fromJson(response_json, ConsultingResponse.class);
                this.reason_code = response.getReason_code();
                this.reason_message = response.getReason_message();
                this.feedback_api_trans_code = response.getFeedbackApiTransCode();
                this.rules_triggered = response.getRulesTriggered();
                this.risk_level = response.getRiskLevel();
                try {
                    this.payload = response.getPayloadAsMap();
                }
                catch (IllegalAccessException e) {
                    throw new BayonetException(-1, "Internal SDK error. Please contact the Bayonet team to report this bug", -1);
                }
            } else if (this.http_response_code == 400 || this.http_response_code == 500) {
                BaseResponse response = (BaseResponse)new Gson().fromJson(response_json, BaseResponse.class);
                throw new BayonetException(response.getReason_code(), response.getReason_message(), this.http_response_code);
            }
        } else {
            throw new BayonetException(-1, "Could not fetch a response from the Bayonet API. Please try again after some time", -1);
        }
    }

    public void feedback(EcommerceFeedbackRequest params) throws BayonetException {
        this.validateClientConfig();
        if (params == null) {
            throw new BayonetException(-1, "params sent to the post request cannot be null", -1);
        }
        this.resetClass();
        params.setApiKey(this.api_key);
        HttpHelper http_helper = new HttpHelper();
        http_helper.request(params, "feedback", this.api_version);
        this.http_response_code = http_helper.getResponseCode();
        String response_json = http_helper.getResponseJson();
        this.processGenericResponse(response_json);
    }

    public void feedbackHistorical(EcommerceFeedbackHistoricalRequest params) throws BayonetException {
        this.validateClientConfig();
        if (params == null) {
            throw new BayonetException(-1, "params sent to the post request cannot be null", -1);
        }
        this.resetClass();
        params.setApiKey(this.api_key);
        HttpHelper http_helper = new HttpHelper();
        http_helper.request(params, "feedback-historical", this.api_version);
        this.http_response_code = http_helper.getResponseCode();
        String response_json = http_helper.getResponseJson();
        this.processGenericResponse(response_json);
    }

    public void updateTransaction(EcommerceUpdateTransactionRequest params) throws BayonetException {
        this.validateClientConfig();
        if (params == null) {
            throw new BayonetException(-1, "params sent to the post request cannot be null", -1);
        }
        this.resetClass();
        params.setApiKey(this.api_key);
        HttpHelper http_helper = new HttpHelper();
        http_helper.request(params, "update-transaction", this.api_version);
        this.http_response_code = http_helper.getResponseCode();
        String response_json = http_helper.getResponseJson();
        this.processGenericResponse(response_json);
    }

    private void processGenericResponse(String response_json) throws BayonetException {
        if (response_json != null) {
            BaseResponse response = (BaseResponse)new Gson().fromJson(response_json, BaseResponse.class);
            this.reason_code = response.getReason_code();
            this.reason_message = response.getReason_message();
            if (this.http_response_code != 200) {
                throw new BayonetException(this.reason_code, this.reason_message, this.http_response_code);
            }
        } else {
            throw new BayonetException(-1, "Could not fetch a response from the Bayonet API. Please try again after some time", -1);
        }
    }

    private void resetClass() {
        this.reason_code = null;
        this.reason_message = null;
        this.feedback_api_trans_code = null;
        this.rules_triggered = null;
        this.risk_level = null;
        this.payload = null;
    }

    public Integer getHttpResponseCode() {
        return this.http_response_code;
    }

    public Integer getReasonCode() {
        return this.reason_code;
    }

    public String getReasonMessage() {
        return this.reason_message;
    }

    public String getFeedbackApiTransCode() {
        return this.feedback_api_trans_code;
    }

    public ArrayList<String> getRulesTriggered() {
        return this.rules_triggered;
    }

    public String getRiskLevel() {
        return this.risk_level;
    }

    public HashMap<String, Object> getResponsePayload() {
        return this.payload;
    }
}

