package io.bayonet.model.lending;

import io.bayonet.model.base.Actions;
import io.bayonet.model.base.AuthModel;

/**
 * Created by imranarshad on 11/28/17
 */

public class LendingFeedbackRequest {

    /** Auth info of the client */

    private AuthModel auth;


    /** Internal id of a transaction generated by the client (and not by Bayonet) */

    private String transaction_id;


    /** Actions to take on the user in question */

    private Actions actions;


    /**
     * Setters
     */
    public void setApiKey(String api_key) {
        this.auth = new AuthModel(api_key);
    }

    public LendingFeedbackRequest setTransactionId(String transaction_id) {
        this.transaction_id = transaction_id;
        return this;
    }

    public LendingFeedbackRequest setActions(Actions actions) {
        this.actions = actions;
        return this;
    }
}
