package io.bayonet.model.ecommerce;

import io.bayonet.model.base.Address;
import io.bayonet.model.base.AuthModel;
import io.bayonet.model.base.Product;

import java.util.ArrayList;

/**
 * Created by imranarshad on 11/27/17
 */

public class EcommerceConsultingRequest {


    /** Auth info of the client */

    private AuthModel auth;


    /** Consumer email */

    private String email;


    /** Consumer name as received by a client */

    private String consumer_name;


    /** Consumer ID used to identify this user in the client's internal system */

    private String consumer_internal_id;


    /** Name on the card being processed by the client */

    private String cardholder_name;


    /** Consumer phone number */

    private String telephone;


    /** Card being used for the payment */

    private String card_number;


    /** Bin number of the card being used - sent in case the client does not have the full card number */

    private String card_bin;


    /** Last 4 digits of the card being used - sent in case the client does not have the full card number */

    private String card_last_4;


    /** Amount of the transaction received by the client */

    private Double transaction_amount;


    /** Three letter ISO-4217 currency code */

    private String currency_code;


    /** Consumer shipping address */

    private Address shipping_address;


    /** Consumer billing address */

    private Address billing_address;


    /** Payment method being used on the client by the consumer */

    private String payment_method;


    /** Unix timestamp when the transaction occurred */

    private Long transaction_time;


    /** The coupon code used by the customer */

    private String coupon;


    /** Did the customer purchasing something choose the option to get expedited shipping - true or false */

    private Boolean expedited_shipping;


    /** The payment gateway used by the client for processing payments */

    private String payment_gateway;


    /** The channel through which the transaction is being made - ecommerce, pos or mpos */

    private String channel;


    /** The product that a customer is trying to buy on a client's site */

    private ArrayList<Product> products;


    /** Device fingerprint token generated by Bayonet's Device fingerprinting API */

    private String bayonet_fingerprint_token;


    /**
     * Getter and Setter methods
     */

    public void setApiKey(String api_key) {
        this.auth = new AuthModel(api_key);
    }

    public EcommerceConsultingRequest setEmail(String email) {
        this.email = email;
        return this;
    }

    public EcommerceConsultingRequest setConsumerName(String consumer_name) {
        this.consumer_name = consumer_name;
        return this;
    }

    public EcommerceConsultingRequest setConsumerInternalId(String consumer_internal_id) {
        this.consumer_internal_id = consumer_internal_id;
        return this;
    }

    public EcommerceConsultingRequest setCardholderName(String cardholder_name) {
        this.cardholder_name = cardholder_name;
        return this;
    }

    public EcommerceConsultingRequest setTelephone(String telephone) {
        this.telephone = telephone;
        return this;
    }

    public EcommerceConsultingRequest setCardNumber(String card_number) {
        this.card_number = card_number;
        return this;
    }

    public EcommerceConsultingRequest setCardBin(String card_bin) {
        this.card_bin = card_bin;
        return this;
    }

    public EcommerceConsultingRequest setCardLast4(String card_last_4) {
        this.card_last_4 = card_last_4;
        return this;
    }

    public EcommerceConsultingRequest setTransactionAmount(Double transaction_amount) {
        this.transaction_amount = transaction_amount;
        return this;
    }

    public EcommerceConsultingRequest setCurrencyCode(String currency_code) {
        this.currency_code = currency_code;
        return this;
    }

    public EcommerceConsultingRequest setShippingAddress(Address shipping_address) {
        this.shipping_address = shipping_address;
        return this;
    }

    public EcommerceConsultingRequest setBillingAddress(Address billing_address) {
        this.billing_address = billing_address;
        return this;
    }

    public EcommerceConsultingRequest setPaymentMethod(String payment_method) {
        this.payment_method = payment_method;
        return this;
    }

    public EcommerceConsultingRequest setTransactionTime(Long transaction_time) {
        this.transaction_time = transaction_time;
        return this;
    }

    public EcommerceConsultingRequest setCoupon(String coupon) {
        this.coupon = coupon;
        return this;
    }

    public EcommerceConsultingRequest setExpeditedShipping(Boolean expedited_shipping) {
        this.expedited_shipping = expedited_shipping;
        return this;
    }

    public EcommerceConsultingRequest setPaymentGateway(String payment_gateway) {
        this.payment_gateway = payment_gateway;
        return this;
    }

    public EcommerceConsultingRequest setChannel(String channel) {
        this.channel = channel;
        return this;
    }

    public EcommerceConsultingRequest setProducts(ArrayList<Product> products) {
        this.products = products;
        return this;
    }

    public EcommerceConsultingRequest setBayonetFingerprintToken(String bayonet_fingerprint_token) {
        this.bayonet_fingerprint_token = bayonet_fingerprint_token;
        return this;
    }
}
