/*
 * Decompiled with CFR 0.152.
 */
package io.axway.iron.spi.kafka;

import io.axway.iron.spi.kafka.KafkaTransactionStore;
import io.axway.iron.spi.storage.TransactionStore;
import io.axway.iron.spi.storage.TransactionStoreFactory;
import java.util.Collections;
import java.util.Properties;
import java.util.UUID;
import org.apache.kafka.clients.consumer.KafkaConsumer;

public class KafkaTransactionStoreFactory
implements TransactionStoreFactory {
    private final Properties m_kafkaProperties;

    public KafkaTransactionStoreFactory(Properties kafkaProperties) {
        this.m_kafkaProperties = kafkaProperties;
    }

    public TransactionStore createTransactionStore(String storeName) {
        this.createKafkaTopic(this.m_kafkaProperties, storeName);
        return new KafkaTransactionStore(this.m_kafkaProperties, storeName);
    }

    private void createKafkaTopic(Properties kafkaProperties, String topicName) {
        Properties localKafkaProperties = (Properties)kafkaProperties.clone();
        localKafkaProperties.put("group.id", "bug-" + UUID.randomUUID());
        localKafkaProperties.put("key.deserializer", "org.apache.kafka.common.serialization.IntegerDeserializer");
        localKafkaProperties.put("value.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        KafkaConsumer consumer = new KafkaConsumer(localKafkaProperties);
        consumer.subscribe(Collections.singletonList(topicName));
        consumer.poll(100L);
        consumer.close();
    }
}

