/*
 * Decompiled with CFR 0.152.
 */
package io.axway.iron.spi.consul;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.axway.iron.spi.consul.ConsulKV;
import io.axway.iron.spi.consul.ConsulOperation;
import io.axway.iron.spi.consul.ConsulTransactionElement;
import io.axway.iron.spi.storage.SnapshotStore;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

class ConsulSnapshotStore
implements SnapshotStore {
    private static final String GET_METHOD = "GET";
    private static final String PUT_METHOD = "PUT";
    private static final String DELETE_METHOD = "DELETE";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String APPLICATION_X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
    private static final String CONSUL_SET = "set";
    private static final int CONSUL_MAX_BASE64_VALUE_SIZE = 512000;
    private static final String IRON_SNAPSHOTS_BASEPATH = "iron-snapshots";
    private final ObjectMapper m_objectMapper;
    private final String m_consulAddress;
    private final String m_storeName;

    ConsulSnapshotStore(ObjectMapper objectMapper, String consulAddress, String storeName) {
        this.m_objectMapper = objectMapper;
        this.m_consulAddress = consulAddress;
        this.m_storeName = storeName;
    }

    public OutputStream createSnapshotWriter(final long transactionId) throws IOException {
        return new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                super.close();
                byte[] snapshot = this.toByteArray();
                int consulMaxValueSize = 384000;
                long chunksCount = (long)Math.ceil((double)snapshot.length / (double)consulMaxValueSize);
                ArrayList<ConsulTransactionElement> consulTransaction = new ArrayList<ConsulTransactionElement>();
                int i = 0;
                while ((long)i < chunksCount) {
                    ConsulOperation consulOperation = new ConsulOperation();
                    consulOperation.setVerb(ConsulSnapshotStore.CONSUL_SET);
                    consulOperation.setKey(String.format("%s/%s/%d/%d", ConsulSnapshotStore.IRON_SNAPSHOTS_BASEPATH, ConsulSnapshotStore.this.m_storeName, transactionId, i));
                    byte[] decodedChunk = Arrays.copyOfRange(snapshot, i * consulMaxValueSize, Math.min(i * consulMaxValueSize + consulMaxValueSize, snapshot.length));
                    consulOperation.setValue(decodedChunk);
                    ConsulTransactionElement consulTransactionElement = new ConsulTransactionElement();
                    consulTransactionElement.setKV(consulOperation);
                    consulTransaction.add(consulTransactionElement);
                    ++i;
                }
                URL url = new URL(String.format("%s/v1/txn", ConsulSnapshotStore.this.m_consulAddress));
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod(ConsulSnapshotStore.PUT_METHOD);
                connection.setDoOutput(true);
                try (OutputStream outputStream = connection.getOutputStream();){
                    ConsulSnapshotStore.this.m_objectMapper.writeValue(outputStream, consulTransaction);
                }
                int responseCode = connection.getResponseCode();
                if (responseCode != 200) {
                    throw new IOException("Snapshot creation error in Consul - response code : " + responseCode);
                }
            }
        };
    }

    public InputStream createSnapshotReader(long transactionId) throws IOException {
        Set chunks;
        String keyPrefix = String.format("%s/%s/%d/", IRON_SNAPSHOTS_BASEPATH, this.m_storeName, transactionId);
        URL url = new URL(String.format("%s/v1/kv/%s?recurse", this.m_consulAddress, keyPrefix));
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(GET_METHOD);
        try (InputStream in = connection.getInputStream();){
            chunks = (Set)this.m_objectMapper.readValue(in, (TypeReference)new TypeReference<Set<ConsulKV>>(){});
        }
        List snapshots = chunks.stream().sorted(Comparator.comparingLong(s -> Long.parseLong(s.getKey().substring(keyPrefix.length())))).map(ConsulKV::getValue).collect(Collectors.toList());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (byte[] snapshot : snapshots) {
            baos.write(snapshot);
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public List<Long> listSnapshots() {
        try {
            Collection keys;
            String keyPrefix = String.format("%s/%s/", IRON_SNAPSHOTS_BASEPATH, this.m_storeName);
            URL url = new URL(String.format("%s/v1/kv/%s/?keys&separator=/", this.m_consulAddress, keyPrefix));
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod(GET_METHOD);
            try (InputStream in = connection.getInputStream();){
                keys = (Collection)this.m_objectMapper.reader().forType(Collection.class).readValue(in);
            }
            return keys.stream().map(key -> Long.parseLong(key.substring(keyPrefix.length(), key.length() - 1))).sorted().collect(Collectors.toList());
        }
        catch (FileNotFoundException e) {
            return Collections.emptyList();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void deleteSnapshot(long transactionId) {
        String urlString = String.format("%s/v1/kv/%s/%s/%d", this.m_consulAddress, IRON_SNAPSHOTS_BASEPATH, this.m_storeName, transactionId);
        try {
            URL url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty(CONTENT_TYPE, APPLICATION_X_WWW_FORM_URLENCODED);
            connection.setRequestMethod(DELETE_METHOD);
            connection.getResponseCode();
        }
        catch (FileNotFoundException url) {
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

