/*
 * Decompiled with CFR 0.152.
 */
package io.axway.alf.slf4j;

import io.axway.alf.Arguments;
import io.axway.alf.formatter.JsonMessageFormatter;
import io.axway.alf.log.Logger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;

final class SLF4JLogger
implements Logger {
    private final org.slf4j.Logger m_logger;

    SLF4JLogger(org.slf4j.Logger logger) {
        this.m_logger = logger;
    }

    public void trace(String message) {
        this.doLog(arg_0 -> ((org.slf4j.Logger)this.m_logger).trace(arg_0), () -> ((org.slf4j.Logger)this.m_logger).isTraceEnabled(), message);
    }

    public void trace(String message, Consumer<Arguments> arguments) {
        this.doLog(arg_0 -> ((org.slf4j.Logger)this.m_logger).trace(arg_0), () -> ((org.slf4j.Logger)this.m_logger).isTraceEnabled(), message, arguments);
    }

    public void trace(String message, Throwable throwable) {
        this.doLog((arg_0, arg_1) -> ((org.slf4j.Logger)this.m_logger).trace(arg_0, arg_1), () -> ((org.slf4j.Logger)this.m_logger).isTraceEnabled(), message, throwable);
    }

    public void trace(String message, Consumer<Arguments> arguments, Throwable throwable) {
        this.doLog((arg_0, arg_1) -> ((org.slf4j.Logger)this.m_logger).trace(arg_0, arg_1), () -> ((org.slf4j.Logger)this.m_logger).isTraceEnabled(), message, arguments, throwable);
    }

    public void debug(String message) {
        this.doLog(arg_0 -> ((org.slf4j.Logger)this.m_logger).debug(arg_0), () -> ((org.slf4j.Logger)this.m_logger).isDebugEnabled(), message);
    }

    public void debug(String message, Consumer<Arguments> arguments) {
        this.doLog(arg_0 -> ((org.slf4j.Logger)this.m_logger).debug(arg_0), () -> ((org.slf4j.Logger)this.m_logger).isDebugEnabled(), message, arguments);
    }

    public void debug(String message, Throwable throwable) {
        this.doLog((arg_0, arg_1) -> ((org.slf4j.Logger)this.m_logger).debug(arg_0, arg_1), () -> ((org.slf4j.Logger)this.m_logger).isDebugEnabled(), message, throwable);
    }

    public void debug(String message, Consumer<Arguments> arguments, Throwable throwable) {
        this.doLog((arg_0, arg_1) -> ((org.slf4j.Logger)this.m_logger).debug(arg_0, arg_1), () -> ((org.slf4j.Logger)this.m_logger).isDebugEnabled(), message, arguments, throwable);
    }

    public void info(String message) {
        this.doLog(arg_0 -> ((org.slf4j.Logger)this.m_logger).info(arg_0), () -> ((org.slf4j.Logger)this.m_logger).isInfoEnabled(), message);
    }

    public void info(String message, Consumer<Arguments> arguments) {
        this.doLog(arg_0 -> ((org.slf4j.Logger)this.m_logger).info(arg_0), () -> ((org.slf4j.Logger)this.m_logger).isInfoEnabled(), message, arguments);
    }

    public void info(String message, Throwable throwable) {
        this.doLog((arg_0, arg_1) -> ((org.slf4j.Logger)this.m_logger).info(arg_0, arg_1), () -> ((org.slf4j.Logger)this.m_logger).isInfoEnabled(), message, throwable);
    }

    public void info(String message, Consumer<Arguments> arguments, Throwable throwable) {
        this.doLog((arg_0, arg_1) -> ((org.slf4j.Logger)this.m_logger).info(arg_0, arg_1), () -> ((org.slf4j.Logger)this.m_logger).isInfoEnabled(), message, arguments, throwable);
    }

    public void warn(String message) {
        this.doLog(arg_0 -> ((org.slf4j.Logger)this.m_logger).warn(arg_0), () -> ((org.slf4j.Logger)this.m_logger).isWarnEnabled(), message);
    }

    public void warn(String message, Consumer<Arguments> arguments) {
        this.doLog(arg_0 -> ((org.slf4j.Logger)this.m_logger).warn(arg_0), () -> ((org.slf4j.Logger)this.m_logger).isWarnEnabled(), message, arguments);
    }

    public void warn(String message, Throwable throwable) {
        this.doLog((arg_0, arg_1) -> ((org.slf4j.Logger)this.m_logger).warn(arg_0, arg_1), () -> ((org.slf4j.Logger)this.m_logger).isWarnEnabled(), message, throwable);
    }

    public void warn(String message, Consumer<Arguments> arguments, Throwable throwable) {
        this.doLog((arg_0, arg_1) -> ((org.slf4j.Logger)this.m_logger).warn(arg_0, arg_1), () -> ((org.slf4j.Logger)this.m_logger).isWarnEnabled(), message, arguments, throwable);
    }

    public void error(String message) {
        this.doLog(arg_0 -> ((org.slf4j.Logger)this.m_logger).error(arg_0), () -> ((org.slf4j.Logger)this.m_logger).isErrorEnabled(), message);
    }

    public void error(String message, Consumer<Arguments> arguments) {
        this.doLog(arg_0 -> ((org.slf4j.Logger)this.m_logger).error(arg_0), () -> ((org.slf4j.Logger)this.m_logger).isErrorEnabled(), message, arguments);
    }

    public void error(String message, Throwable throwable) {
        this.doLog((arg_0, arg_1) -> ((org.slf4j.Logger)this.m_logger).error(arg_0, arg_1), () -> ((org.slf4j.Logger)this.m_logger).isErrorEnabled(), message, throwable);
    }

    public void error(String message, Consumer<Arguments> arguments, Throwable throwable) {
        this.doLog((arg_0, arg_1) -> ((org.slf4j.Logger)this.m_logger).error(arg_0, arg_1), () -> ((org.slf4j.Logger)this.m_logger).isErrorEnabled(), message, arguments, throwable);
    }

    public String getName() {
        return this.m_logger.getName();
    }

    private void doLog(Consumer<String> logFunction, Supplier<Boolean> isEnabled, String message) {
        if (isEnabled.get().booleanValue()) {
            logFunction.accept(JsonMessageFormatter.getFormatter().format(message));
        }
    }

    private void doLog(Consumer<String> logFunction, Supplier<Boolean> isEnabled, String message, Consumer<Arguments> arguments) {
        if (isEnabled.get().booleanValue()) {
            logFunction.accept(JsonMessageFormatter.getFormatter().format(message, arguments));
        }
    }

    private void doLog(BiConsumer<String, Throwable> logFunction, Supplier<Boolean> isEnabled, String message, Throwable throwable) {
        if (isEnabled.get().booleanValue()) {
            logFunction.accept(JsonMessageFormatter.getFormatter().format(message, throwable), throwable);
        }
    }

    private void doLog(BiConsumer<String, Throwable> logFunction, Supplier<Boolean> isEnabled, String message, Consumer<Arguments> arguments, Throwable throwable) {
        if (isEnabled.get().booleanValue()) {
            logFunction.accept(JsonMessageFormatter.getFormatter().format(message, arguments, throwable), throwable);
        }
    }
}

