/*
 * Decompiled with CFR 0.152.
 */
package io.axway.alf.log4j2.layout;

import io.axway.alf.Arguments;
import io.axway.alf.formatter.JsonWriter;
import io.axway.alf.log4j2.Log4j2Message;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Nullable;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.util.ReadOnlyStringMap;

@Plugin(name="AlfJsonLayout", category="Core", elementType="layout", printObject=true)
public final class AlfJsonLayout
extends AbstractStringLayout {
    @Nullable
    private final DateFormat m_dateFormat;
    private final boolean m_threadPrinting;
    private final boolean m_levelPrinting;
    private final boolean m_loggerPrinting;
    private final boolean m_contextPrinting;
    private final String m_messageKey;

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    public AlfJsonLayout(Configuration config, Charset aCharset, AbstractStringLayout.Serializer headerSerializer, AbstractStringLayout.Serializer footerSerializer, @Nullable DateFormat dateFormat, boolean threadPrinting, boolean levelPrinting, boolean loggerPrinting, boolean contextPrinting, String messageKey) {
        super(config, aCharset, headerSerializer, footerSerializer);
        this.m_dateFormat = dateFormat;
        this.m_threadPrinting = threadPrinting;
        this.m_levelPrinting = levelPrinting;
        this.m_loggerPrinting = loggerPrinting;
        this.m_contextPrinting = contextPrinting;
        this.m_messageKey = messageKey;
    }

    public String toSerializable(LogEvent event) {
        Throwable exception;
        Message message;
        ReadOnlyStringMap context;
        StringBuilder sb = new StringBuilder(128);
        JsonWriter jsonWriter = new JsonWriter(sb);
        if (this.m_dateFormat != null) {
            jsonWriter.add("time", this.m_dateFormat.format(new Date(event.getTimeMillis())));
        } else {
            jsonWriter.add("time", event.getTimeMillis());
        }
        if (this.m_threadPrinting) {
            jsonWriter.add("thread", event.getThreadName());
        }
        if (this.m_levelPrinting) {
            jsonWriter.add("level", (Object)event.getLevel());
        }
        if (this.m_loggerPrinting) {
            jsonWriter.add("logger", event.getLoggerName());
        }
        if (this.m_contextPrinting && !(context = event.getContextData()).isEmpty()) {
            jsonWriter.add("context", args -> context.forEach((arg_0, arg_1) -> ((Arguments)args).add(arg_0, arg_1)));
        }
        if ((message = event.getMessage()) instanceof Log4j2Message) {
            Log4j2Message log4j2Message = (Log4j2Message)message;
            jsonWriter.add(this.m_messageKey, log4j2Message.getMessage());
            jsonWriter.add("args", log4j2Message.getArgs());
        } else {
            jsonWriter.add(this.m_messageKey, message.getFormattedMessage());
        }
        Throwable throwable = exception = event.getThrown() != null ? event.getThrown() : message.getThrowable();
        if (exception != null) {
            jsonWriter.add("exception", (Object)exception);
        }
        jsonWriter.end();
        sb.append(System.lineSeparator());
        return sb.toString();
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractStringLayout.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<AlfJsonLayout> {
        @Nullable
        @PluginBuilderAttribute(value="dateFormat")
        private String m_dateFormat;
        @PluginBuilderAttribute(value="threadPrinting")
        private boolean m_threadPrinting = true;
        @PluginBuilderAttribute(value="levelPrinting")
        private boolean m_levelPrinting = true;
        @PluginBuilderAttribute(value="loggerPrinting")
        private boolean m_loggerPrinting = true;
        @PluginBuilderAttribute(value="contextPrinting")
        private boolean m_contextPrinting = true;
        @PluginBuilderAttribute(value="messageKey")
        private String m_messageKey = "message";

        public Builder() {
            this.setCharset(StandardCharsets.UTF_8);
        }

        public AlfJsonLayout build() {
            SimpleDateFormat dateFormat = this.m_dateFormat == null ? null : new SimpleDateFormat(this.m_dateFormat);
            return new AlfJsonLayout(this.getConfiguration(), this.getCharset(), this.getHeaderSerializer(), this.getFooterSerializer(), dateFormat, this.m_threadPrinting, this.m_levelPrinting, this.m_loggerPrinting, this.m_contextPrinting, this.m_messageKey);
        }

        public Builder withDateFormat(String dateFormat) {
            this.m_dateFormat = dateFormat;
            return this;
        }

        public Builder withThreadPrinting(boolean threadPrinting) {
            this.m_threadPrinting = threadPrinting;
            return this;
        }

        public Builder withLevelPrinting(boolean levelPrinting) {
            this.m_levelPrinting = levelPrinting;
            return this;
        }

        public Builder withLoggerPrinting(boolean loggerPrinting) {
            this.m_loggerPrinting = loggerPrinting;
            return this;
        }

        public Builder withContextPrinting(boolean contextPrinting) {
            this.m_contextPrinting = contextPrinting;
            return this;
        }

        public Builder withMessageKey(String messageKey) {
            this.m_messageKey = messageKey;
            return this;
        }
    }
}

