/*
 * Decompiled with CFR 0.152.
 */
package io.axway.alf.log4j2;

import io.axway.alf.Arguments;
import io.axway.alf.formatter.JsonMessageFormatter;
import java.util.function.Consumer;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.util.MessageSupplier;
import org.apache.logging.log4j.util.StringBuilderFormattable;

public final class Log4j2Message
implements MessageSupplier,
Message,
StringBuilderFormattable {
    private final String m_message;
    private final Consumer<Arguments> m_args;
    private String m_formattedMessage;

    Log4j2Message(String message, Consumer<Arguments> args) {
        this.m_message = message;
        this.m_args = args;
    }

    public String getMessage() {
        return this.m_message;
    }

    public Consumer<Arguments> getArgs() {
        return this.m_args;
    }

    public Message get() {
        return this;
    }

    public String getFormattedMessage() {
        if (this.m_formattedMessage == null) {
            this.m_formattedMessage = JsonMessageFormatter.getFormatter().format(this.m_message, this.m_args);
        }
        return this.m_formattedMessage;
    }

    public void formatTo(StringBuilder buffer) {
        if (this.m_formattedMessage == null) {
            JsonMessageFormatter.getFormatter().formatTo(buffer, this.m_message, this.m_args);
        } else {
            buffer.append(this.m_formattedMessage);
        }
    }

    public String getFormat() {
        return "";
    }

    public Object[] getParameters() {
        return null;
    }

    public Throwable getThrowable() {
        return null;
    }
}

