/*
 * Decompiled with CFR 0.152.
 */
package core.uiCore.driverProperties.capabilities;

import core.support.configReader.Config;
import core.support.logger.TestLog;
import core.support.objects.DriverOption;
import core.support.objects.TestObject;
import core.uiCore.driverProperties.browserType;
import core.uiCore.driverProperties.driverType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.remote.DesiredCapabilities;

public class WebCapability {
    private static final String CHROME_OPTIONS_PREFIX = "chrome.options";
    private static final String FIREFOX_OPTIONS_PREFIX = "firefox.options";
    private static final String CHROME_PREF_PREFIX = "chrome.pref";
    private static final String FIREFOX_PREF_PREFIX = "firefox.pref";
    private static final String WEB_CAPABILITIES_PREFIX = "web.capabilities.";
    public DesiredCapabilities capabilities = new DesiredCapabilities();
    public DriverOption options = new DriverOption();
    driverType.DriverType driverType;

    public WebCapability withBrowserOption() {
        System.setProperty("webdriver.chrome.args", "--disable-logging");
        System.setProperty("webdriver.chrome.silentOutput", "true");
        this.setWebCapabilties();
        this.setOptions();
        this.setPreferences();
        this.disableLogs();
        return this;
    }

    public void disableLogs() {
        if (WebCapability.isFirefox()) {
            System.setProperty("webdriver.firefox.marionette", "true");
            System.setProperty("webdriver.firefox.logfile", "/dev/null");
        }
    }

    public void setWebCapabilties() {
        Map<String, Object> propertiesMap = TestObject.getTestInfo().config;
        propertiesMap.put("web.capabilities.recordVideo", "true");
        propertiesMap.put("web.capabilities.takesScreenshot", "true");
        propertiesMap.put("web.capabilities.browserName", WebCapability.getBrowserName());
        propertiesMap.put("web.capabilities.name", TestObject.getTestInfo().testName);
        for (Map.Entry<String, Object> entry : propertiesMap.entrySet()) {
            boolean isWebCapability = entry.getKey().toString().startsWith(WEB_CAPABILITIES_PREFIX);
            if (!isWebCapability) continue;
            String fullKey = entry.getKey().toString();
            String key = fullKey.substring(fullKey.lastIndexOf(".") + 1).trim();
            String value = entry.getValue().toString().trim();
            this.capabilities.setCapability(key, value);
            this.options.getChromeOptions().setCapability(key, value);
            this.options.getFirefoxOptions().setCapability(key, value);
            this.options.getEdgeOptions().setCapability(key, value);
            this.options.getSafariOptions().setCapability(key, value);
            this.options.getOperaOptions().setCapability(key, value);
            this.options.getInternetExplorerOptions().setCapability(key, value);
        }
    }

    private void setPreferences() {
        Map<String, Object> propertiesMap = TestObject.getTestInfo().config;
        HashMap<String, String> chromePreferences = new HashMap<String, String>();
        FirefoxProfile fireFoxProfile = null;
        if (WebCapability.isFirefox()) {
            fireFoxProfile = new FirefoxProfile();
        }
        for (Map.Entry<String, Object> entry : propertiesMap.entrySet()) {
            boolean isPref = entry.getKey().toString().startsWith(CHROME_PREF_PREFIX) || entry.getKey().toString().startsWith(FIREFOX_PREF_PREFIX);
            if (!isPref) continue;
            String fullKey = entry.getKey().toString();
            String[] split = fullKey.split("pref.");
            String key = split[1].trim();
            String value = entry.getValue().toString().trim();
            if (WebCapability.isChrome() && fullKey.contains(CHROME_PREF_PREFIX)) {
                chromePreferences.put(key, value);
                continue;
            }
            if (!WebCapability.isFirefox() || !fullKey.contains(FIREFOX_PREF_PREFIX)) continue;
            fireFoxProfile.setPreference(key, value);
        }
        if (WebCapability.isChrome()) {
            this.options.getChromeOptions().setExperimentalOption("prefs", chromePreferences);
        } else if (WebCapability.isFirefox()) {
            this.options.getFirefoxOptions().setProfile(fireFoxProfile);
        }
    }

    private void setOptions() {
        Map<String, Object> propertiesMap = TestObject.getTestInfo().config;
        for (Map.Entry<String, Object> entry : propertiesMap.entrySet()) {
            String[] keywords;
            boolean isOption = entry.getKey().toString().startsWith(CHROME_OPTIONS_PREFIX) || entry.getKey().toString().startsWith(FIREFOX_OPTIONS_PREFIX);
            if (!isOption) continue;
            ArrayList<String> optionsList = new ArrayList<String>();
            String fullKey = entry.getKey().toString();
            for (String keyword : keywords = StringUtils.substringsBetween((String)entry.getValue().toString(), (String)"[", (String)"]")) {
                if (WebCapability.isChrome() && fullKey.contains(CHROME_OPTIONS_PREFIX)) {
                    this.options.getChromeOptions().addArguments(new String[]{keyword});
                    optionsList.add(keyword);
                    continue;
                }
                if (!WebCapability.isFirefox() || !fullKey.contains(FIREFOX_OPTIONS_PREFIX)) continue;
                this.options.getFirefoxOptions().addArguments(new String[]{keyword});
                optionsList.add(keyword);
            }
            if (keywords.length <= 0) continue;
            TestLog.ConsoleLog("browser options" + Arrays.toString(optionsList.toArray()), new Object[0]);
        }
    }

    public DesiredCapabilities getCapability() {
        return this.capabilities;
    }

    public DriverOption getDriverOption() {
        return this.options;
    }

    public String getUrl(String app, String defaultUrl) {
        String value = Config.getValue(app);
        if (defaultUrl.isEmpty()) {
            return value;
        }
        return defaultUrl;
    }

    public static browserType.BrowserType getBrowser() {
        String value = Config.getValue("web.browserType");
        return Enum.valueOf(browserType.BrowserType.class, value);
    }

    public static String getBrowserName() {
        String browsername = WebCapability.getBrowser().toString().toLowerCase();
        if ((browsername = browsername.replace("_", "")).contains("chrome")) {
            browsername = "chrome";
        } else if (browsername.contains("firefox")) {
            browsername = "firefox";
        } else if (browsername.contains("microsoftedge")) {
            browsername = "MicrosoftEdge";
        }
        return browsername;
    }

    public static boolean isChrome() {
        return WebCapability.getBrowserName().equals("chrome");
    }

    public static boolean isFirefox() {
        return WebCapability.getBrowserName().equals("firefox");
    }

    public static boolean isInternetExplorer() {
        return WebCapability.getBrowserName().equals("internet explorer");
    }

    public static boolean isSafari() {
        return WebCapability.getBrowserName().equals("safari");
    }

    public static boolean isMicrosoftEdge() {
        return WebCapability.getBrowserName().equals("MicrosoftEdge");
    }

    public String getDriverVersion() {
        String value = Config.getValue("web.driver.manager.version");
        return value;
    }

    public driverType.DriverType getWebDriverType() {
        String value = Config.getValue("web.webdriverType");
        return Enum.valueOf(driverType.DriverType.class, value);
    }

    public static boolean printWebDriverVersionHelp(Exception e) {
        if (e.getMessage().contains("This version of") && e.getMessage().contains("only supports") && e.getMessage().contains("version")) {
            String[] message = e.getMessage().split("\n");
            String shortErrorMessage = "";
            if (message.length > 1) {
                shortErrorMessage = message[0];
            }
            TestLog.logWarning("\n\n" + shortErrorMessage + "\n\nLooks like webdriver manager is not able to find the new browser version \n\n*** Please try setting browser version manually at web.driver.manager.version at web.property ***\n\nAlternatively, you can set the webdriver manual path at web.driver.manual.path at web.property ***\n\n", new Object[0]);
            return true;
        }
        return false;
    }
}

