/*
 * Decompiled with CFR 0.152.
 */
package core.support.annotation.helper.utils;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;

public class SourceChangeDetector {
    public static String GENERATED_SOURCE_DIR = SourceChangeDetector.getRootDir() + "target" + File.separator + "generated-sources" + File.separator;
    public static String SOURCE_DIR = SourceChangeDetector.getRootDir() + "src" + File.separator + "main";
    public static String RESOURCE_DIR = SourceChangeDetector.getRootDir() + "resources" + File.separator;
    public static String MARKER_FILE = GENERATED_SOURCE_DIR + "annotations" + File.separator + "marker" + File.separator + "marker.java";
    public static String MAVEN_STATUS_DIR = SourceChangeDetector.getRootDir() + "target" + File.separator + "maven-status";

    public static void main(String[] args) {
        SourceChangeDetector.hasSourceChanged();
        System.out.println("<<<<<<<<< running test file change class >>>>>>>>>");
    }

    public static boolean hasSourceChanged() {
        boolean hasSourceChanged = SourceChangeDetector.hasSourceDirChanged();
        boolean isMarker = new File(MARKER_FILE).exists();
        if (hasSourceChanged || !isMarker) {
            System.out.println("************ Changes detected, initiating new source generation ************");
            SourceChangeDetector.deleteFile(MARKER_FILE);
            SourceChangeDetector.deleteFile(MAVEN_STATUS_DIR);
            return true;
        }
        return false;
    }

    private static boolean hasSourceDirChanged() {
        ArrayList<String> sourceListStringArray = SourceChangeDetector.getSourceFileList();
        String targetFile = GENERATED_SOURCE_DIR + "src_dir.txt";
        String oldFileList = "";
        boolean hasSourceChanged = true;
        if (new File(targetFile).exists()) {
            oldFileList = SourceChangeDetector.getFileContent(targetFile);
            ArrayList<String> oldDirList = new ArrayList<String>(Arrays.asList(oldFileList.split(",")));
            hasSourceChanged = SourceChangeDetector.hasChangeDetected(oldDirList, sourceListStringArray);
        }
        return hasSourceChanged;
    }

    private static ArrayList<String> getSourceFileList() {
        System.out.println("sourceDir : " + SOURCE_DIR);
        System.out.println("keywordDir : " + RESOURCE_DIR);
        ArrayList<String> sourceList = SourceChangeDetector.getFileList(SOURCE_DIR);
        ArrayList<String> keywordList = SourceChangeDetector.getFileList(RESOURCE_DIR);
        sourceList.addAll(keywordList);
        ArrayList<String> sourceListStringArray = SourceChangeDetector.getFileString(sourceList);
        return sourceListStringArray;
    }

    private static boolean hasChangeDetected(ArrayList<String> oldDirList, ArrayList<String> newDirList) {
        boolean hasChanged;
        String oldDir = String.join((CharSequence)", ", oldDirList);
        String newDir = String.join((CharSequence)", ", newDirList);
        ArrayList<String> differenceList = SourceChangeDetector.listDifference(oldDirList, newDirList);
        boolean bl = hasChanged = !oldDir.equals(newDir);
        if (hasChanged) {
            System.out.println("changes in (src, or keyword) directory detected: \n changes: ");
            differenceList.forEach(System.out::println);
        }
        return hasChanged;
    }

    private static ArrayList<String> listDifference(ArrayList<String> oldDirList, ArrayList<String> newDirList) {
        ArrayList<String> newList = new ArrayList<String>(newDirList);
        newDirList.removeAll(oldDirList);
        oldDirList.removeAll(newList);
        newDirList.addAll(oldDirList);
        return newDirList;
    }

    private static ArrayList<String> getFileList(String directory) {
        ArrayList<String> array = new ArrayList<String>();
        File file = new File(directory);
        array = SourceChangeDetector.getFileList(file, array);
        return array;
    }

    private static ArrayList<String> getFileString(ArrayList<String> list) {
        ArrayList<String> dirList = new ArrayList<String>();
        for (String file : list) {
            dirList.add(file);
        }
        return dirList;
    }

    private static ArrayList<String> getFileList(File curDir, ArrayList<String> array) {
        File[] filesList;
        for (File f : filesList = curDir.listFiles()) {
            if (f.isDirectory()) {
                SourceChangeDetector.getFileList(f, array);
            }
            if (!f.isFile()) continue;
            array.add(f.getPath());
        }
        return array;
    }

    private static String getRootDir() {
        String root = "";
        try {
            root = new File(SourceChangeDetector.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParentFile().getParent();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return root + File.separator;
    }

    private static String getFileContent(String absolutePath) {
        String content = "";
        File file = new File(absolutePath);
        if (!file.exists()) {
            return content;
        }
        try {
            content = new String(Files.readAllBytes(Paths.get(absolutePath, new String[0])));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return content;
    }

    private static void deleteFile(String absolutePath) {
        File file = new File(absolutePath);
        if (file.isDirectory()) {
            File fileDir = new File(absolutePath);
            SourceChangeDetector.deleteDirectory(fileDir);
        } else {
            SourceChangeDetector.deleteSingleFile(absolutePath);
        }
    }

    private static void deleteDirectory(File file) {
        File[] contents = file.listFiles();
        if (contents != null) {
            for (File f : contents) {
                SourceChangeDetector.deleteDirectory(f);
            }
        }
        file.delete();
    }

    private static void deleteSingleFile(String absolutePath) {
        File file = new File(absolutePath);
        file.delete();
    }
}

