/*
 * Decompiled with CFR 0.152.
 */
package core.helpers;

import core.helpers.AssertHelper;
import core.helpers.Element;
import core.helpers.Helper;
import core.support.logger.TestLog;
import core.uiCore.drivers.AbstractDriver;
import core.uiCore.webElement.EnhancedBy;
import core.uiCore.webElement.EnhancedWebElement;
import java.util.Arrays;

public class VerifyHelper {
    public void verifyElementIsDisplayed(EnhancedBy by) {
        Helper.wait.waitForElementToLoad(by, 3);
        Helper.mobile.mobile_scrollToElement(by);
        TestLog.logPass("I verify '" + by.name + "' is displayed", new Object[0]);
        Helper.wait.waitForElementToLoad(by);
        EnhancedWebElement elements = Element.findElements(by);
        AssertHelper.assertTrue("element '" + by.name + "' is not displayed", elements.count() > 0);
    }

    public boolean isPresent(EnhancedBy element) {
        EnhancedWebElement expectedElement = Element.findElements(element);
        expectedElement.scrollToView();
        boolean isPresent = expectedElement.isExist(new int[0]);
        if (!isPresent) {
            TestLog.ConsoleLog("isPresent:  " + element.name + " :" + isPresent, new Object[0]);
        }
        return isPresent;
    }

    public boolean isElementContainingText(EnhancedBy element, String text) {
        return Helper.list.isContainedInList(element, text);
    }

    public boolean isElementHasExactText(EnhancedBy element, int index, String text) {
        Helper.waitForElementToLoad(element);
        String actualText = Helper.getTextValue(element, index);
        return actualText.equals(text);
    }

    public boolean isElementInList(EnhancedBy list, EnhancedBy target) {
        return Helper.list.getElementIndexInList(list, target) != -1;
    }

    public boolean isElementInList(EnhancedBy list, String option, EnhancedBy target) {
        Helper.wait.waitForElementToLoad(list);
        int index = Helper.list.getElementIndexContainByText(list, option);
        AssertHelper.assertTrue("option not found in list: " + list.name, index > -1);
        EnhancedWebElement targetElement = Element.findElements(list, index, target);
        return targetElement.isExist(new int[0]);
    }

    public void verifyElementHasExactText(EnhancedBy element, int index, String text) {
        Helper.waitForElementToLoad(element);
        String actualText = Helper.getTextValue(element, index);
        Helper.assertEquals(text, actualText);
    }

    public void verifyElementContainingText(EnhancedBy element, String text) {
        Helper.waitForElementToLoad(element);
        Helper.assertTrue("element does not contain text: " + text, this.isElementContainingText(element, text));
    }

    public void verifyTextDisplayed(String text) {
        EnhancedBy elementText = Element.byXpath("//*[contains(text(),'" + text + "')]", "page source");
        Helper.waitForElementToLoad(elementText);
        boolean isText = this.isTextDisplayed(text);
        Helper.assertTrue("text: " + text + " is not displayed", isText);
    }

    public boolean isTextDisplayed(String text) {
        try {
            EnhancedBy elementText = Element.byXpath("//*[contains(text(),'" + text + "')]", "page source");
            boolean b = Helper.isPresent(elementText);
            return b;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void verifyToolTip(EnhancedBy tooltip, int index, String text) {
        Helper.hoverBy(tooltip, index);
        Helper.verifyTextDisplayed(text);
    }

    public void verifyElementIsNotDisplayed(EnhancedBy by) {
        EnhancedWebElement elements = Element.findElements(by);
        TestLog.logPass("I verify element '" + by.name + "' is not displayed", new Object[0]);
        Helper.wait.waitForElementToBeRemoved(by);
        AssertHelper.assertTrue("element '" + by.name + "' is displayed", !elements.isExist(new int[0]));
    }

    public void verifyElementText(EnhancedBy by, String value) {
        if (!value.isEmpty()) {
            Helper.wait.waitForElementToLoad(by);
            EnhancedWebElement elements = Element.findElements(by);
            Helper.assertTrue("text value not found expected: " + value + " actual: " + elements.get(0).getText(), elements.get(0).getText().equals(value));
        }
    }

    public void verifyElementCount(EnhancedBy by, int value, int ... correction) {
        int correctValue = 0;
        if (correction.length > 0) {
            correctValue = correction[0];
        }
        TestLog.logPass("I verify element '" + by.name + "'  occurs " + (value - correctValue) + " times", new Object[0]);
        Helper.wait.waitForElementToLoad(by, AbstractDriver.TIMEOUT_SECONDS, value);
        int count = Helper.list.getListCount(by);
        Helper.assertEquals(value, count);
    }

    public void verifyAnyTextContaining(EnhancedBy target, String ... values) {
        TestLog.logPass("I verify element '" + target.name + "'  contains " + Arrays.toString(values), new Object[0]);
        Helper.waitForAnyTextToLoadContaining(target, values);
        EnhancedWebElement elements = Element.findElements(target);
        String actualValue = elements.getText();
        for (String value : values) {
            if (!actualValue.contains(value)) continue;
            TestLog.logPass("value found: " + value, new Object[0]);
            return;
        }
        Helper.assertFalse("element: " + target.name + " did not display any text, text values: " + Arrays.toString(values));
    }

    public void verifyAnyText(EnhancedBy target, String ... values) {
        TestLog.logPass("I verify element '" + target.name + "'  contains " + Arrays.toString(values), new Object[0]);
        Helper.waitForAnyTextToLoadContaining(target, values);
        EnhancedWebElement elements = Element.findElements(target);
        String actualValue = elements.getText();
        for (String value : values) {
            if (!actualValue.equals(value)) continue;
            TestLog.logPass("value found: " + value, new Object[0]);
            return;
        }
        Helper.assertFalse("element: " + target.name + " did not display any text, text values: " + Arrays.toString(values));
    }

    public boolean isContainedInList(EnhancedBy list, String option) {
        return Helper.isContainedInList(list, option);
    }

    public boolean isExactMatchInList(EnhancedBy list, String option) {
        return Helper.isExactMatchInList(list, option);
    }
}

