/*
 * Decompiled with CFR 0.152.
 */
package core.uiCore.drivers;

import com.aventstack.extentreports.ExtentReports;
import com.aventstack.extentreports.ExtentTest;
import com.microsoft.appcenter.appium.EnhancedAndroidDriver;
import com.microsoft.appcenter.appium.Factory;
import core.helpers.Helper;
import core.support.configReader.Config;
import core.support.logger.ExtentManager;
import core.support.logger.TestLog;
import core.support.objects.DriverObject;
import core.support.objects.TestObject;
import core.support.rules.RetryTest;
import core.uiCore.WebDriverSetup;
import core.uiCore.driverProperties.capabilities.AndroidCapability;
import core.uiCore.driverProperties.driverType;
import core.uiCore.driverProperties.globalProperties.CrossPlatformProperties;
import core.uiCore.drivers.AbstractDriver;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.junit.rules.TestWatcher;
import org.junit.rules.Timeout;
import org.openqa.selenium.WebDriver;

public class AbstractDriverJunit {
    public static ExtentReports extent;
    public static ThreadLocal<ExtentTest> step;
    private static boolean isBeforeTestRun;
    public static Map<String, ExtentTest> testList;
    private static ThreadLocal<WebDriver> webDriver;
    private static boolean setUpIsDone;
    @Rule
    public TestWatcher watcher = Factory.createWatcher();
    @Rule
    public RetryTest retry = new RetryTest(RetryTest.RETRYCOUNTER);
    @Rule
    public Timeout globalTimeout = new Timeout(360000000);
    @Rule
    public TestName testName = new TestName();

    public WebDriver setupWebDriver(DriverObject driverObject) throws Exception {
        boolean condition3;
        this.initTest(driverObject);
        ExtentManager.reportSetup();
        TestLog.ConsoleLog("driverObject.driverType: " + (Object)((Object)driverObject.driverType), new Object[0]);
        if (driverObject.driverType != null && driverObject.driverType.equals((Object)driverType.DriverType.API)) {
            return null;
        }
        AbstractDriverJunit.setWebDriver(DriverObject.getFirstAvailableDriver());
        TestLog.ConsoleLog("isForcedRestart: " + TestObject.getTestInfo().isForcedRestart + " isSingleSignIn(): " + CrossPlatformProperties.isSingleSignIn() + " webDriver: " + AbstractDriver.getWebDriver(), new Object[0]);
        boolean condition1 = TestObject.getTestInfo().isForcedRestart != false && CrossPlatformProperties.isSingleSignIn() != false;
        boolean condition2 = CrossPlatformProperties.isSingleSignIn() == false;
        boolean bl = condition3 = AbstractDriver.getWebDriver() == null;
        if (condition1 || condition2 || condition3) {
            AbstractDriverJunit.setWebDriver(AbstractDriverJunit.createDriver(driverObject));
            driverObject.withIsAvailable(false);
            DriverObject.initializeDriverList(driverObject, TestObject.getTestInfo().testId);
            TestObject.getTestInfo().withIsFirstRun(true);
        }
        TestObject.getTestInfo().withWebDriver(AbstractDriver.getWebDriver());
        TestObject.updateAppName(driverObject);
        this.getURL(driverObject.initialURL);
        AbstractDriverJunit.setFullScreen();
        return AbstractDriver.getWebDriver();
    }

    public void setupWebDriver(String testId, DriverObject driver) {
        TestObject.setTestId(testId);
        try {
            this.setupWebDriver(driver);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TestObject.testInfo.get((Object)testId).app = driver.app;
    }

    public static void setFullScreen() {
        if (!Helper.mobile.isMobile() && Config.getValue("web.maximizeBrowser").equals("true")) {
            Helper.page.maximizePage();
        }
    }

    public void initTest(DriverObject driverObject) {
        Logger log;
        String testId = TestObject.getTestId();
        TestLog.removeLogUtilHandler();
        TestObject.initializeTest(driverObject, testId);
        TestObject.getTestInfo().log = log = Logger.getLogger((String)testId);
        TestObject.getTestInfo().withCurrentDriver(driverObject);
        DriverObject.initializeDriverList(driverObject, testId);
    }

    public void setTestId() {
        TestObject.setTestName(this.testName.getMethodName());
        String className = this.getClass().toString().substring(this.getClass().toString().lastIndexOf(".") + 1);
        String testName = TestObject.currentTestName.get();
        if (testName.isEmpty()) {
            TestObject.setTestId(className);
        } else {
            TestObject.setTestId(className + "-" + TestObject.currentTestName.get());
        }
        TestObject.getTestInfo().withClassName(this.getClassName());
        TestObject.getTestInfo().testFileClassName = this.getClassName();
    }

    @Before
    public void handleTestMethodName() {
        TestObject.setTestName(this.testName.getMethodName());
        TestObject.setTestId(this.getClassName(), TestObject.currentTestName.get());
        DriverObject driver = new DriverObject().withDriverType(driverType.DriverType.API);
        new AbstractDriverJunit().setupWebDriver(this.getClassName() + "-" + this.testName.getMethodName(), driver);
    }

    public static void setWebDriver(WebDriver webDriver) {
        AbstractDriverJunit.webDriver.set(webDriver);
    }

    @BeforeClass
    public static void beforeClass() {
        if (!setUpIsDone) {
            DriverObject driver = new DriverObject().withDriverType(driverType.DriverType.API).withApp("Autonomx-default");
            new AbstractDriverJunit().setupWebDriver(TestObject.getDefaultTestObjectId(), driver);
            ExtentManager.clearTestReport();
            setUpIsDone = true;
        }
    }

    public static void setupReportPage() {
        if (isBeforeTestRun) {
            extent = ExtentManager.getReporter();
            isBeforeTestRun = false;
        }
    }

    public boolean isBeforeTest() {
        return TestObject.getTestInfo().testScenerio == null;
    }

    public static String parseTestName(String value) {
        String formatted = "";
        value = value.replace("_", " ");
        for (String w : value.split("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])")) {
            w = w.substring(0, 1).toUpperCase() + w.substring(1).toLowerCase();
            formatted = formatted + " " + w;
        }
        return formatted.trim();
    }

    public String getClassName() {
        return this.getClass().getSimpleName();
    }

    public static WebDriver createDriver(DriverObject driverObject) throws Exception {
        int retry = 3;
        WebDriver driver = null;
        do {
            try {
                --retry;
                Helper.killWindowsProcess("node.exe");
                driver = new WebDriverSetup().getWebDriverByType(driverObject);
                driver.manage().timeouts().implicitlyWait(5L, TimeUnit.SECONDS);
                driver.manage().timeouts().pageLoadTimeout((long)AbstractDriver.TIMEOUT_SECONDS, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                if (retry != 0) continue;
                if (driverObject.driverType.equals((Object)driverType.DriverType.ANDROID_DRIVER)) {
                    AndroidCapability.printAndroidHelp(e);
                }
                throw e;
            }
        } while (driver == null && retry > 0);
        Assert.assertTrue((String)"driver was not created", (driver != null ? 1 : 0) != 0);
        return driver;
    }

    public void getURL(String url) {
        if (!url.isEmpty()) {
            TestLog.And("I am the site '" + url + "'", new Object[0]);
            Helper.getUrl(url);
        }
    }

    public static WebDriver getWebDriver() {
        try {
            return webDriver.get();
        }
        catch (Exception e) {
            return null;
        }
    }

    @After
    public void shutdown() {
        this.letRetryKnowAboutReports();
    }

    public void takeAppcenterScreenshot(String label) {
        try {
            ((EnhancedAndroidDriver)AbstractDriverJunit.getWebDriver()).label(label);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void letRetryKnowAboutReports() {
        this.retry.setExtendReport(TestObject.getTestInfo().testScenerio, step.get(), extent);
        this.retry.setWebDriver(AbstractDriverJunit.getWebDriver());
    }

    static {
        step = new ThreadLocal();
        isBeforeTestRun = true;
        testList = new ConcurrentHashMap<String, ExtentTest>();
        webDriver = new ThreadLocal();
        setUpIsDone = false;
    }
}

