/*
 * Decompiled with CFR 0.152.
 */
package core.support.listeners;

import com.google.common.base.Joiner;
import core.apiCore.ServiceManager;
import core.apiCore.driver.ApiTestDriver;
import core.helpers.Helper;
import core.helpers.ScreenRecorderHelper;
import core.support.configReader.Config;
import core.support.listeners.RetryTest;
import core.support.logger.ExtentManager;
import core.support.logger.TestLog;
import core.support.objects.DeviceManager;
import core.support.objects.DriverObject;
import core.support.objects.TestObject;
import core.uiCore.driverProperties.driverType;
import core.uiCore.driverProperties.globalProperties.CrossPlatformProperties;
import core.uiCore.drivers.AbstractDriverTestNG;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.testng.IClassListener;
import org.testng.IConfigurationListener;
import org.testng.IRetryAnalyzer;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.SkipException;
import org.testng.TestListenerAdapter;
import org.testng.TestNG;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class TestListener
implements ITestListener,
IClassListener,
ISuiteListener,
IConfigurationListener {
    public static boolean isTestNG = false;
    public static final String PARALLEL_TEST_TYPE = "global.parallel.type";
    public static final String CONSOLE_PAGESOURCE_ON_FAIL = "console.pageSource.onFail";
    public static final String GLOBAL_SKIP_TESTS = "global.skipTests";
    public static final String GLOBAL_SKIP_TESTS_MESSAGE = "skipped on purpose";
    public static final String FAILED_RERUN_SUITE_NAME = "failed_rerun_suite";
    public static final String FAILED_RERUN_OPTION = "global.ui.rerun.failed.after.suite ";
    public static List<String> FAILED_RERUN_SUITE_PASSED_TESTS = new ArrayList<String>();

    public void onStart(ITestContext iTestContext) {
        isTestNG = true;
        iTestContext.setAttribute("WebDriver", (Object)AbstractDriverTestNG.getWebDriver());
        String testId = this.getSuiteName(iTestContext.getSuite().getName().toString()) + TestObject.BEFORE_SUITE_PREFIX;
        TestLog.printBatchToConsole(testId);
        this.cleanupProcessess();
        iTestContext.setAttribute("platform", (Object)"");
        for (ITestNGMethod method : iTestContext.getAllTestMethods()) {
            method.setRetryAnalyzer((IRetryAnalyzer)new RetryTest());
        }
        this.setParallelRun(iTestContext);
        ExtentManager.clearTestReport(iTestContext.getSuite().getName());
        ExtentManager.clearOldTestReports();
        ScreenRecorderHelper.deleteScreenRecorderTempDir();
    }

    private void setParallelRun(ITestContext iTestContext) {
        String parallelType = CrossPlatformProperties.getParallelTestType();
        if (parallelType.equals("CLASSES")) {
            iTestContext.getCurrentXmlTest().setParallel(XmlSuite.ParallelMode.CLASSES);
        } else {
            iTestContext.getCurrentXmlTest().setParallel(XmlSuite.ParallelMode.METHODS);
        }
        int threadCount = CrossPlatformProperties.getParallelTests();
        iTestContext.getCurrentXmlTest().setThreadCount(threadCount);
        iTestContext.getCurrentXmlTest().getSuite().setDataProviderThreadCount(threadCount);
        iTestContext.getCurrentXmlTest().getSuite().setPreserveOrder(Boolean.valueOf(true));
    }

    public void onFinish(ITestContext iTestContext) {
        ExtentManager.writeTestReport();
        DriverObject.quitAllDrivers();
        ExtentManager.launchReportAfterTest();
        ExtentManager.printReportLink();
        this.sendReport(iTestContext);
        String suitename = this.getSuiteName(iTestContext.getSuite().getName());
        DriverObject driver = new DriverObject().withDriverType(driverType.DriverType.API);
        new AbstractDriverTestNG().setupWebDriver(suitename + TestObject.AFTER_SUITE_PREFIX, driver);
        if (iTestContext.getFailedTests().size() == 0) {
            TestLog.printLogoOnSuccess();
        }
    }

    private void sendReport(ITestContext iTestContext) {
        String message = this.generateTestMessage(iTestContext);
        boolean hasErrors = iTestContext.getFailedTests().size() > 0;
        boolean slackNotifyOnFailOnly = Config.getBooleanValue("slack.notifyOnFailureOnly");
        boolean emailNotifyOnFailOnly = Config.getBooleanValue("email.notifyOnFailureOnly");
        if (slackNotifyOnFailOnly && hasErrors) {
            ExtentManager.slackNotification(message);
        } else if (!slackNotifyOnFailOnly) {
            ExtentManager.slackNotification(message);
        }
        if (emailNotifyOnFailOnly && hasErrors) {
            ExtentManager.emailTestReport(message);
        } else if (!emailNotifyOnFailOnly) {
            ExtentManager.emailTestReport(message);
        }
    }

    public void onTestStart(ITestResult iTestResult) {
        ArrayList<String> skipTestName = Config.getValueList(GLOBAL_SKIP_TESTS);
        if (skipTestName.contains(TestObject.getTestInfo().testId)) {
            throw new SkipException(GLOBAL_SKIP_TESTS_MESSAGE);
        }
        this.setTestClassName(iTestResult);
        ScreenRecorderHelper.startRecording();
    }

    public void onTestSuccess(ITestResult iTestResult) {
        this.setTestClassName(iTestResult);
        TestObject.getTestInfo().withIsTestPass(true);
        this.setTestComplete();
        ScreenRecorderHelper.stopRecording();
        if (CrossPlatformProperties.isSingleSignIn().booleanValue() && AbstractDriverTestNG.getWebDriver() != null) {
            DriverObject.setDriverAvailabiltity(AbstractDriverTestNG.getWebDriver(), true);
        }
        DeviceManager.setDeviceAvailability(true);
        ApiTestDriver.parentTrackChildTests();
        ApiTestDriver.trackBatchTestLogs();
        TestLog.Then("Test is finished successfully", new Object[0]);
        TestLog.printBatchLogsToConsole();
    }

    public void onTestFailure(ITestResult iTestResult) {
        TestObject.getGlobalTestInfo().failedTests.add(iTestResult);
        this.setTestClassName(iTestResult);
        TestObject.getTestInfo().withIsForcedRestart(true);
        TestObject.getTestInfo().isFirstRun = true;
        TestObject.getTestInfo().withIsTestPass(false);
        this.setTestComplete();
        DeviceManager.setDeviceAvailability(true);
        ScreenRecorderHelper.stopRecording();
        ApiTestDriver.parentTrackChildTests();
        ApiTestDriver.trackBatchTestLogs();
        TestLog.Then("Test failed", new Object[0]);
        TestLog.printBatchLogsToConsole();
        if (Config.getBooleanValue(CONSOLE_PAGESOURCE_ON_FAIL).booleanValue()) {
            Helper.printPageSource();
        }
        Helper.quitCurrentDriver();
    }

    public void onTestSkipped(ITestResult iTestResult) {
        TestObject.getTestInfo().withIsForcedRestart(true);
        TestObject.getTestInfo().isFirstRun = true;
        TestObject.getTestInfo().withIsTestPass(false);
        int status = this.getTestngStatus(iTestResult);
        if (status == 8) {
            iTestResult.setStatus(2);
        } else {
            iTestResult.setStatus(3);
        }
        DeviceManager.setDeviceAvailability(true);
        ScreenRecorderHelper.stopRecording();
        if (Config.getBooleanValue(CONSOLE_PAGESOURCE_ON_FAIL).booleanValue()) {
            Helper.printPageSource();
        }
        Helper.quitCurrentDriver();
    }

    private int getTestngStatus(ITestResult iTestResult) {
        try {
            boolean isSkipOnPurpose = iTestResult.getThrowable().getMessage().equals(GLOBAL_SKIP_TESTS_MESSAGE);
            if (isSkipOnPurpose) {
                return 3;
            }
            return TestNG.getDefault().getStatus();
        }
        catch (Exception e) {
            e.getMessage();
            return -1;
        }
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult iTestResult) {
        TestLog.ConsoleLog("Test failed But it is in defined success ratio " + TestObject.getTestInfo().testName, new Object[0]);
    }

    public void cleanupProcessess() {
        if (Helper.isWindows()) {
            if (Helper.mobile.isMobile()) {
                Helper.killWindowsProcess("node.exe");
            }
            Helper.killWindowsProcess("IEDriverServer.exe");
            Helper.killWindowsProcess("chromedriver.exe");
            Helper.killWindowsProcess("MicrosoftWebDriver.exe");
        } else if (Helper.isMac()) {
            Helper.killMacProcess("chromedriver");
        }
    }

    public String generateTestMessage(ITestContext iTestContext) {
        int testCount = iTestContext.getPassedTests().size() + iTestContext.getFailedTests().size();
        String message = iTestContext.getPassedTests().size() + " of " + testCount + " tests passed.";
        if (iTestContext.getFailedTests().size() > 0) {
            ArrayList<String> failedMessage = this.getAllResults(iTestContext.getFailedTests().getAllResults());
            message = message + " Failed test(s): " + Joiner.on((String)",").join(failedMessage);
        }
        return message;
    }

    private ArrayList<String> getAllResults(Collection<ITestResult> results) {
        ArrayList<String> tests = new ArrayList<String>();
        for (ITestResult result : results) {
            String className = result.getInstanceName().substring(result.getInstanceName().lastIndexOf(".") + 1);
            tests.add(className + "." + result.getMethod().getMethodName());
        }
        return tests;
    }

    public void onBeforeClass(ITestClass testClass) {
        String classname = this.getClassName(testClass.getName());
        DriverObject driver = new DriverObject().withDriverType(driverType.DriverType.API);
        new AbstractDriverTestNG().setupWebDriver(classname + TestObject.BEFORE_CLASS_PREFIX, driver);
    }

    public void onAfterClass(ITestClass testClass) {
        String classname = this.getClassName(testClass.getName());
        DriverObject driver = new DriverObject().withDriverType(driverType.DriverType.API);
        new AbstractDriverTestNG().setupWebDriver(classname + TestObject.AFTER_CLASS_PREFIX, driver);
    }

    public void onConfigurationSuccess(ITestResult itr) {
    }

    public void onConfigurationFailure(ITestResult itr) {
    }

    public void onConfigurationSkip(ITestResult itr) {
    }

    public void setTestClassName(ITestResult iTestResult) {
        String classname = iTestResult.getMethod().getTestClass().getName();
        TestObject.getTestInfo().testFileClassName = classname = classname.substring(classname.lastIndexOf(".") + 1);
    }

    public void onStart(ISuite suite) {
        TestLog.setupLog4j();
        TestObject.setupDefaultDriver();
        TestLog.ConsoleLog("Autonomx initiating...", new Object[0]);
        String suitename = this.getSuiteName(suite.getName());
        TestObject.APP_IDENTIFIER = this.getTestPackage(suite);
        TestObject.SUITE_NAME = suitename;
        DriverObject driver = new DriverObject().withDriverType(driverType.DriverType.API);
        new AbstractDriverTestNG().setupWebDriver(TestObject.SUITE_NAME + TestObject.BEFORE_SUITE_PREFIX, driver);
        if (this.isServiceSuite(suite)) {
            ServiceManager.runServiceBeforeSuite();
        }
    }

    private boolean isServiceSuite(ISuite suite) {
        List methods = suite.getAllMethods();
        if (methods.size() == 0 || methods.size() > 1) {
            return false;
        }
        return ((ITestNGMethod)methods.get(0)).getMethodName().contains("serviceRunner");
    }

    private String getTestPackage(ISuite suite) {
        String testPackageName = "";
        try {
            testPackageName = ((ITestNGMethod)suite.getAllMethods().get(0)).getInstance().toString();
            testPackageName = testPackageName.substring(testPackageName.indexOf(".") + 1);
            int lastIndex = testPackageName.lastIndexOf(46);
            testPackageName = testPackageName.substring(0, lastIndex);
        }
        catch (Exception e) {
            e.getMessage();
        }
        return testPackageName;
    }

    public void onFinish(ISuite suite) {
        String testId = this.getSuiteName(suite.getName()) + TestObject.AFTER_SUITE_PREFIX;
        TestLog.printBatchToConsole(testId);
        if (this.isServiceSuite(suite)) {
            ServiceManager.runServiceAfterSuite();
        }
        Config.printMissingConfigVariables();
        this.runFailedTests(suite);
        TestLog.checkLatestAutonomxMavenVersion();
    }

    private String getSuiteName(String suitename) {
        suitename = suitename.replaceAll("\\s", "");
        return suitename;
    }

    private String getClassName(String className) {
        className = className.substring(className.lastIndexOf(".") + 1);
        return className;
    }

    private void setTestComplete() {
        TestObject.getTestInfo().withIsTestComplete(ApiTestDriver.isCsvTestComplete());
        if (ApiTestDriver.isRunningUITest()) {
            TestObject.getTestInfo().withIsTestComplete(true);
        }
    }

    public void runFailedTests(ISuite suite) {
        if (!ApiTestDriver.isRunningUITest()) {
            return;
        }
        if (!Config.getBooleanValue(FAILED_RERUN_OPTION).booleanValue()) {
            return;
        }
        if (suite.getName().equals(FAILED_RERUN_SUITE_NAME)) {
            return;
        }
        ArrayList<ITestResult> failedTests = TestObject.getGlobalTestInfo().failedTests;
        if (failedTests.isEmpty()) {
            return;
        }
        HashMap classToMethodsMap = new HashMap();
        for (ITestResult iTestResult : failedTests) {
            if (classToMethodsMap.get(iTestResult.getTestClass().getName()) == null) {
                ArrayList<XmlInclude> methods = new ArrayList<XmlInclude>();
                methods.add(new XmlInclude(iTestResult.getMethod().getMethodName()));
                classToMethodsMap.put(iTestResult.getTestClass().getName(), methods);
                continue;
            }
            ((List)classToMethodsMap.get(iTestResult.getTestClass().getName())).add(new XmlInclude(iTestResult.getTestClass().getName()));
        }
        ArrayList<XmlClass> xmlClasses = new ArrayList<XmlClass>();
        for (String className : classToMethodsMap.keySet()) {
            XmlClass xmlClassToAdd = new XmlClass(className);
            xmlClassToAdd.setIncludedMethods((List)classToMethodsMap.get(className));
            xmlClasses.add(xmlClassToAdd);
        }
        TestObject.getGlobalTestInfo().failedTests = new ArrayList();
        XmlSuite xmlSuite = new XmlSuite();
        xmlSuite.setName(FAILED_RERUN_SUITE_NAME);
        XmlTest test = new XmlTest(xmlSuite);
        test.setXmlClasses(xmlClasses);
        test.setSuite(xmlSuite);
        ArrayList<XmlSuite> suitesList = new ArrayList<XmlSuite>();
        suitesList.add(xmlSuite);
        TestNG tng = new TestNG();
        ArrayList<Class<TestListenerAdapter>> listener = new ArrayList<Class<TestListenerAdapter>>();
        listener.add(TestListenerAdapter.class);
        tng.setXmlSuites(suitesList);
        tng.setListenerClasses(listener);
        tng.run();
    }
}

