/*
 * Decompiled with CFR 0.152.
 */
package core.support.configReader;

import core.helpers.Helper;
import core.support.objects.TestObject;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class PropertiesReader {
    public static String LOCAL_ROOT_PATH = Helper.getRootDir();
    private static String LOCAL_RESOURCE_PATH = "resources";
    private static String LOCAL_RESOURCE_CLOUD_PATH = "test-classes" + File.separator + "testData" + File.separator + "resources" + File.separator;
    public static String PROPERTIES_TYPE_PROPERTIES = ".property";
    public static String PROPERTIES_TYPE_CONF = ".conf";

    public static List<Properties> Property(String path) throws Exception {
        ArrayList<Properties> properties = new ArrayList<Properties>();
        if (new File(path = PropertiesReader.getPropertyPath(path)).isFile()) {
            properties.addAll(PropertiesReader.getPropertiesByFileType(path, ""));
        } else {
            properties.addAll(PropertiesReader.getPropertiesByFileType(path, PROPERTIES_TYPE_PROPERTIES));
            properties.addAll(PropertiesReader.getPropertiesByFileType(path, PROPERTIES_TYPE_CONF));
            if (Helper.getFileList(path).isEmpty()) {
                Helper.assertFalse("path: '" + path + "' does not have any property files, please verify resources/properties.property for correct path");
            }
        }
        return properties;
    }

    public static String getPropertyPath(String path) {
        Path file = new File(path = Helper.getFullPath(path)).toPath();
        if (Files.isDirectory(file, new LinkOption[0]) || Files.isRegularFile(file, new LinkOption[0])) {
            return path;
        }
        if (!path.endsWith(".property") && !path.endsWith(".config")) {
            path = path + ".property";
        }
        path = Helper.getFullPath(path);
        return path;
    }

    public static List<Properties> getPropertiesByFileType(String path, String fileType) throws Exception {
        ArrayList<Properties> properties = new ArrayList<Properties>();
        ArrayList<Object> files = new ArrayList<File>();
        if (fileType.isEmpty()) {
            File file = Helper.getFile(path);
            files.add(file);
        } else {
            files = Helper.getFileListByType(path, fileType);
        }
        for (final File file : files) {
            Properties prop = new Properties(){

                @Override
                public synchronized Object put(Object key, Object value) {
                    TestObject.getTestInfo().configKeys.put((Object)key.toString(), (Object)file.getName());
                    return super.put(key, value);
                }
            };
            try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));){
                prop.load(bis);
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
            }
            properties.add(prop);
        }
        return properties;
    }

    public static List<Properties> getPropertiesByFileType(String path) throws Exception {
        return PropertiesReader.getPropertiesByFileType(path, "");
    }

    public static String getLocalResourcePath() {
        if (PropertiesReader.isUsingCloud()) {
            return Helper.getFullPath(LOCAL_RESOURCE_CLOUD_PATH);
        }
        return Helper.getFullPath(LOCAL_RESOURCE_PATH);
    }

    public static boolean isUsingCloud() {
        File f = new File(Helper.getFullPath(LOCAL_RESOURCE_CLOUD_PATH));
        return f.exists() && f.isDirectory();
    }

    public static String getStringProperty(String key, Properties Property) {
        try {
            return Property.getProperty(key, "").replace("\"", "").trim();
        }
        catch (Exception e) {
            e.getMessage();
            return "";
        }
    }

    public static ArrayList<String> getAllFiles(File curDir) {
        ArrayList<String> array = new ArrayList<String>();
        array = PropertiesReader.getFileList(curDir, array);
        return array;
    }

    public static ArrayList<String> getFileList(File curDir, ArrayList<String> array) {
        File[] filesList;
        for (File f : filesList = curDir.listFiles()) {
            if (f.isDirectory()) {
                PropertiesReader.getFileList(f, array);
            }
            if (!f.isFile()) continue;
            array.add(f.getPath());
        }
        return array;
    }
}

