/*
 * Decompiled with CFR 0.152.
 */
package core.helpers;

import core.helpers.Helper;
import core.support.configReader.Config;
import core.support.logger.ExtentManager;
import core.support.logger.TestLog;
import core.support.objects.TestObject;
import io.appium.java_client.android.AndroidStartScreenRecordingOptions;
import io.appium.java_client.ios.IOSStartScreenRecordingOptions;
import io.appium.java_client.screenrecording.BaseStartScreenRecordingOptions;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.monte.media.Format;
import org.monte.media.FormatKeys;
import org.monte.media.VideoFormatKeys;
import org.monte.media.math.Rational;
import org.monte.screenrecorder.ScreenRecorder;

public class ScreenRecorderHelper {
    public static final String RECORDER_ENABLE_RECORDING = "recorder.enableRecording";
    public static final String RECORDER_ON_FAIL_TEST_ONLY = "recorder.onFailedTestsOnly";
    public static final String RECORDER_MAX_TIME_SECONDS = "recorder.maxTimeInSeconds";
    public static final String RECORDER_ANDROID_VIDEO_SIZE = "recorder.android.videoSize";
    public static final String RECORDER_IOS_QUALITY = "recorder.ios.quality";
    public static final String RECORDER_IOS_TYPE = "recorder.ios.type";

    public static synchronized void startRecording() {
        if (!Config.getBooleanValue(RECORDER_ENABLE_RECORDING).booleanValue()) {
            return;
        }
        if (Config.getBooleanValue(RECORDER_ON_FAIL_TEST_ONLY).booleanValue() && !TestObject.getTestInfo().isTestFail.booleanValue()) {
            return;
        }
        Helper.bringPageToFront();
        TestLog.ConsoleLog("initiating screen recording", new Object[0]);
        TestObject.getTestInfo().isScreenRecorderInitiated = true;
        int maxTime = Config.getIntValue(RECORDER_MAX_TIME_SECONDS);
        String androidVideoSize = Config.getValue(RECORDER_ANDROID_VIDEO_SIZE);
        IOSStartScreenRecordingOptions.VideoQuality iosQuality = IOSStartScreenRecordingOptions.VideoQuality.valueOf((String)Config.getValue(RECORDER_IOS_QUALITY));
        if (Helper.mobile.isAndroid()) {
            Helper.mobile.getAndroidDriver().stopRecordingScreen();
            AndroidStartScreenRecordingOptions record = new AndroidStartScreenRecordingOptions();
            record.withTimeLimit(Duration.ofSeconds(maxTime));
            record.withVideoSize(androidVideoSize);
            Helper.mobile.getAndroidDriver().startRecordingScreen((BaseStartScreenRecordingOptions)record);
        } else if (Helper.mobile.isIOS()) {
            Helper.mobile.getiOSDriver().stopRecordingScreen();
            IOSStartScreenRecordingOptions record = new IOSStartScreenRecordingOptions();
            record.withTimeLimit(Duration.ofSeconds(maxTime));
            record.withVideoQuality(iosQuality);
            record.withVideoType("libx264");
            Helper.mobile.getiOSDriver().startRecordingScreen((BaseStartScreenRecordingOptions)record);
        } else if (Helper.mobile.isWebDriver()) {
            ScreenRecorderHelper.startWebScreenRecording();
        }
    }

    public static synchronized void stopRecording() {
        if (!TestObject.getTestInfo().isScreenRecorderInitiated) {
            return;
        }
        if (!Config.getBooleanValue(RECORDER_ENABLE_RECORDING).booleanValue()) {
            return;
        }
        if (Config.getBooleanValue(RECORDER_ON_FAIL_TEST_ONLY).booleanValue() && TestObject.getTestInfo().isTestPass.booleanValue()) {
            return;
        }
        TestLog.ConsoleLog("stopping screen recording", new Object[0]);
        if (Helper.mobile.isMobile()) {
            ScreenRecorderHelper.stopMobileScreenRecorder();
        } else if (Helper.mobile.isWebDriver()) {
            ScreenRecorderHelper.stopWebScreenRecorder();
        }
    }

    private static void startWebScreenRecording() {
        File output = new File(ScreenRecorderHelper.getScreenRecorderTempDir().getAbsoluteFile() + File.separator + TestObject.getTestInfo().getTestName());
        output.deleteOnExit();
        GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        try {
            TestObject.getTestInfo().screenRecorder = new ScreenRecorder(gc, null, new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE, FormatKeys.MimeTypeKey, "video/avi"}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.EncodingKey, "tscc", VideoFormatKeys.CompressorNameKey, "Techsmith Screen Capture", VideoFormatKeys.DepthKey, 24, FormatKeys.FrameRateKey, Rational.valueOf((double)15.0), VideoFormatKeys.QualityKey, Float.valueOf(1.0f), FormatKeys.KeyFrameIntervalKey, 900}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.EncodingKey, "black", FormatKeys.FrameRateKey, Rational.valueOf((double)30.0)}), null, output);
            TestObject.getTestInfo().screenRecorder.start();
        }
        catch (Exception e) {
            TestLog.ConsoleLog("Recorder Object cannot be intialized " + e, new Object[0]);
        }
    }

    private static void stopMobileScreenRecorder() {
        String recording = null;
        if (Helper.mobile.isAndroid()) {
            recording = Helper.mobile.getAndroidDriver().stopRecordingScreen();
        } else if (Helper.mobile.isIOS()) {
            recording = Helper.mobile.getiOSDriver().stopRecordingScreen();
        }
        byte[] decodedBytes = Base64.decodeBase64((byte[])recording.getBytes());
        try {
            String mediaName = ScreenRecorderHelper.getMediaName() + ".mp4";
            String extentMediaRelativePathFromReport = ExtentManager.getMediaFolderRelativePathFromHtmlReport() + mediaName;
            String extentReportImageFullPath = ExtentManager.getMediaFolderFullPath() + mediaName;
            File media = new File(extentReportImageFullPath);
            Helper.createFileFromPath(media.getAbsolutePath());
            FileOutputStream out = new FileOutputStream(media, false);
            out.write(decodedBytes);
            out.close();
            TestLog.ConsoleLog("Test Recording is saved at: " + extentReportImageFullPath, new Object[0]);
            TestLog.attachVideoLog(extentMediaRelativePathFromReport, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void stopWebScreenRecorder() {
        if (TestObject.getTestInfo().screenRecorder != null) {
            try {
                TestObject.getTestInfo().screenRecorder.stop();
                List createdMovieFiles = TestObject.getTestInfo().screenRecorder.getCreatedMovieFiles();
                for (File movie : createdMovieFiles) {
                    File dir = new File(ExtentManager.getMediaFolderFullPath());
                    dir.mkdirs();
                    String mediaName = ScreenRecorderHelper.getMediaName() + ".avi";
                    try {
                        Path path = Files.move(movie.toPath(), dir.toPath().resolve(mediaName), StandardCopyOption.REPLACE_EXISTING);
                        TestLog.ConsoleLog("Test Recording is saved at: " + path, new Object[0]);
                        String extentReportImageRelativePath = ExtentManager.getMediaFolderRelativePathFromHtmlReport() + mediaName;
                        TestLog.attachVideoLog(extentReportImageRelativePath, false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static String getMediaName() {
        String format = new SimpleDateFormat("yyyy-MM-dd'T'HH-mm-ss", Locale.ENGLISH).format(new Date());
        String fileName = TestObject.getTestInfo().testName + "-" + format;
        return fileName;
    }

    public static File getScreenRecorderTempDir() {
        File output = new File(System.getProperty("java.io.tmpdir") + File.separator + "screenrecorder" + File.separator);
        return output;
    }

    public static void deleteScreenRecorderTempDir() {
        try {
            FileUtils.deleteDirectory((File)ScreenRecorderHelper.getScreenRecorderTempDir());
        }
        catch (IOException e) {
            TestLog.ConsoleLogDebug(e.getMessage(), new Object[0]);
        }
    }
}

