/*
 * Decompiled with CFR 0.152.
 */
package core.helpers;

import core.apiCore.helpers.JsonHelper;
import core.apiCore.interfaces.RestApiInterface;
import core.helpers.Helper;
import core.support.configReader.Config;
import core.support.logger.TestLog;
import core.support.objects.ServiceObject;
import core.support.objects.TestObject;
import io.restassured.response.Response;
import org.json.JSONArray;
import org.json.JSONException;

public class RestApiHelper {
    protected static void runApiContaining(String identifier, String prefix, String getApi, String targetApiId, String variable, String targerApi) throws JSONException {
        ServiceObject api = TestObject.getApiDef(getApi);
        Response response = RestApiInterface.RestfullApiInterface(api);
        JSONArray valueArray = new JSONArray(response.body().asString());
        String responseString = response.body().asString();
        for (int i = 0; i < valueArray.length(); ++i) {
            String name = JsonHelper.getJsonValue(responseString, identifier).split(",")[i];
            String id = JsonHelper.getJsonValue(responseString, targetApiId).split(",")[i];
            if (!name.contains(prefix)) continue;
            TestLog.logPass("calling: " + targerApi + ": with identifier: " + name, new Object[0]);
            Config.putValue(variable, Helper.getIntFromString(id));
            api = TestObject.getApiDef(targerApi);
            RestApiInterface.RestfullApiInterface(api);
        }
    }

    protected static void runApiEquals(String identifier, String value, String getApi, String targetApiId, String variable, String targerApi) throws JSONException {
        ServiceObject api = TestObject.getApiDef(getApi);
        Response response = RestApiInterface.RestfullApiInterface(api);
        JSONArray valueArray = new JSONArray(response.body().asString());
        for (int i = 0; i < valueArray.length(); ++i) {
            String name = valueArray.getJSONObject(i).getString(identifier);
            String id = valueArray.getJSONObject(i).getString(targetApiId);
            if (!name.equals(value)) continue;
            TestLog.logPass("calling: " + targerApi + ": with identifier: " + name, new Object[0]);
            Config.putValue(variable, id);
            api = TestObject.getApiDef(targerApi);
            RestApiInterface.RestfullApiInterface(api);
        }
    }
}

