/*
 * Decompiled with CFR 0.152.
 */
package core.apiCore.interfaces;

import core.apiCore.helpers.DataHelper;
import core.helpers.Helper;
import core.support.logger.TestLog;
import core.support.objects.KeyValue;
import core.support.objects.ServiceObject;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ExternalInterface {
    private static final String METHOD = "method";

    public static Object ExternalInterfaceRunner(ServiceObject serviceObject) {
        try {
            return ExternalInterface.evaluateTestMethod(serviceObject);
        }
        catch (Exception e) {
            e.printStackTrace();
            Helper.assertFalse(e.getMessage());
            return null;
        }
    }

    public static Object evaluateTestMethod(ServiceObject serviceObject) throws Exception {
        if (serviceObject.getMethod().isEmpty()) {
            return null;
        }
        serviceObject.withRequestBody(DataHelper.getRequestBodyIncludingTemplate(serviceObject));
        List<KeyValue> parameterList = DataHelper.getValidationMap(serviceObject.getRequestBody());
        List<KeyValue> keywords = DataHelper.getValidationMap(serviceObject.getMethod());
        for (KeyValue keyword : keywords) {
            switch (keyword.key.toLowerCase()) {
                case "method": {
                    Object object = ExternalInterface.runExernalMethod(keyword.value.toString(), parameterList);
                    return object;
                }
            }
        }
        return null;
    }

    public static Object runExernalMethod(String classmethod, List<KeyValue> parameterList) throws Exception {
        String[] methodInfo = classmethod.split("\\.");
        if (methodInfo.length < 2) {
            Helper.assertFalse("wrong method format. must be class.method");
        }
        String className = methodInfo[0];
        String methodName = methodInfo[1];
        TestLog.logPass("invoking method: " + methodName + " at class: " + className, new Object[0]);
        String sourcePath = ExternalInterface.getExternalMethodPath(className);
        return Helper.runInternalClass(sourcePath, methodName, parameterList);
    }

    public static String getExternalMethodPath(String classmethod) {
        String path = "module" + File.separator + "services" + File.separator + METHOD;
        File folder = new File(Helper.getFullPath("src" + File.separator + "main"));
        String classPath = "module.services.method." + classmethod;
        List<File> listOfFiles = new ArrayList<File>();
        listOfFiles = ExternalInterface.getAllFiles(folder, listOfFiles);
        for (File file : listOfFiles) {
            if (!file.getAbsolutePath().contains(path + File.separator + classmethod)) continue;
            return classPath;
        }
        Helper.assertFalse("directory for external test method not found: " + path);
        return null;
    }

    private static List<File> getAllFiles(File pathToDir, List<File> listOfFiles) {
        if (pathToDir.isDirectory()) {
            String[] subdirs = pathToDir.list();
            for (int i = 0; i < subdirs.length; ++i) {
                ExternalInterface.getAllFiles(new File(pathToDir, subdirs[i]), listOfFiles);
            }
        } else {
            listOfFiles.add(pathToDir);
        }
        return listOfFiles;
    }
}

