/*
 * Decompiled with CFR 0.152.
 */
package core.apiCore.driver;

import core.apiCore.helpers.CsvReader;
import core.support.logger.LogObject;
import core.support.logger.TestLog;
import core.support.objects.ServiceObject;
import core.support.objects.TestObject;
import core.uiCore.drivers.AbstractDriverTestNG;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;

public class ApiTestDriver {
    public static void setTestId(ServiceObject serviceObject) {
        String csvFileName = ApiTestDriver.getTestClass(serviceObject);
        TestObject.setTestName(serviceObject.getTestCaseID());
        TestObject.setTestId(csvFileName + "-" + serviceObject.getTestCaseID());
    }

    public static String getTestClass(ServiceObject serviceObject) {
        String testClass = serviceObject.getTcName();
        return ApiTestDriver.getTestClass(testClass);
    }

    public static String getTestClass(String csvFilename) {
        if (StringUtils.isBlank((CharSequence)csvFilename)) {
            return csvFilename;
        }
        String testClass = csvFilename.split("\\.")[0];
        testClass = testClass.replace(CsvReader.SERVICE_CSV_FILE_PREFIX, "");
        return testClass;
    }

    public void initTest(ServiceObject serviceObject) {
        String APP = "ServiceManager";
        ApiTestDriver.setTestId(serviceObject);
        String testId = TestObject.currentTestId.get();
        TestLog.removeLogUtilHandler();
        TestObject.initializeTest(testId);
        TestObject.getTestInfo().config = ApiTestDriver.getParentTestObject((ServiceObject)serviceObject).config;
        TestObject.getTestInfo().type = TestObject.testType.service;
        TestObject.getTestInfo().app = APP;
        TestObject.getTestInfo().testCsvFileName = serviceObject.getTcName();
        TestObject.getTestInfo().className = ApiTestDriver.getTestClass(serviceObject);
        TestObject.getTestInfo().testName = serviceObject.getTestCaseID();
        TestObject.getTestInfo().currentTestIndex = Integer.valueOf(serviceObject.getTcIndex());
        TestObject.getTestInfo().testCountInCsvFile = Integer.valueOf(serviceObject.getTcCount());
        TestObject.getTestInfo().serviceObject = serviceObject;
    }

    public static TestObject getParentTestObject(ServiceObject serviceObject) {
        return TestObject.getTestInfo(serviceObject.getParent());
    }

    public static TestObject getParentTestObject(String parentId) {
        return TestObject.getTestInfo(parentId);
    }

    public static TestObject getParentTestObject() {
        return ApiTestDriver.getParentTestObject(TestObject.getTestInfo().serviceObject);
    }

    public static void parentTrackChildTests() {
        if (TestObject.getTestInfo().serviceObject == null) {
            return;
        }
        String parentId = TestObject.getTestInfo().serviceObject.getParent();
        if (!TestObject.isTestObjectSet(parentId)) {
            return;
        }
        ApiTestDriver.getParentTestObject((String)parentId).testObjects.add(TestObject.getTestInfo());
    }

    public static void trackBatchTestLogs() {
        TestObject.getTestInfo().testLogAll = new ArrayList<LogObject>();
        if (ApiTestDriver.isRunningServiceTest()) {
            ApiTestDriver.getParentTestObject().testLog.addAll(TestObject.getTestInfo().testLog);
            TestObject.getTestInfo().testLogAll.addAll(ApiTestDriver.getParentTestObject().testLog);
        } else {
            TestObject.getTestInfo().testLogAll.addAll(TestObject.getTestInfo().testLog);
        }
    }

    public static boolean isCsvTestComplete() {
        if (TestObject.getTestInfo().currentTestIndex == TestObject.getTestInfo().testCountInCsvFile - 1) {
            TestObject.getTestInfo().isTestComplete = true;
            return true;
        }
        return false;
    }

    public static boolean isCsvTestComplete(ServiceObject service) {
        return Integer.valueOf(service.getTcIndex()) == Integer.valueOf(service.getTcCount()) - 1;
    }

    public static boolean isCsvTestStarted() {
        return TestObject.getTestInfo().currentTestIndex == 0;
    }

    public static boolean isCsvTestStarted(int index) {
        return index == 0;
    }

    public String getClassName() {
        String className = this.getClass().toString().substring(this.getClass().toString().lastIndexOf(".") + 1);
        return className;
    }

    public static boolean isRunningServiceTest() {
        return TestObject.getTestInfo().type.equals((Object)TestObject.testType.service);
    }

    public static boolean isRunningUITest() {
        return TestObject.getTestInfo().type.equals((Object)TestObject.testType.uiTest);
    }

    public static boolean isRunningServiceTest(Object[] testData) {
        Object[] data = ApiTestDriver.getTestData(testData);
        if (data.length != CsvReader.SERVICE_CSV_COLUMN_COUNT) {
            return false;
        }
        if (testData[testData.length - 1] == null) {
            return false;
        }
        ServiceObject ServiceObject2 = CsvReader.mapToServiceObject(data);
        return ServiceObject2.getTcType().equals(TestObject.testType.service.name());
    }

    public static void setServiceTestName(Object[] testData) {
        if (ApiTestDriver.isRunningServiceTest(testData)) {
            Object[] data = ApiTestDriver.getTestData(testData);
            ServiceObject apiObject = CsvReader.mapToServiceObject(data);
            String testClass = ApiTestDriver.getTestClass(apiObject.getTcName());
            AbstractDriverTestNG.testName.set(testClass + "-" + apiObject.getTestCaseID());
        }
    }

    public static Object[] getTestData(Object[] testData) {
        Object[] data = null;
        data = testData.length == 1 ? (Object[])testData[0] : testData;
        return data;
    }
}

