/*
 * Decompiled with CFR 0.152.
 */
package core.uiCore.drivers;

import com.aventstack.extentreports.ExtentReports;
import com.aventstack.extentreports.ExtentTest;
import core.apiCore.driver.ApiTestDriver;
import core.helpers.Helper;
import core.support.configReader.Config;
import core.support.listeners.RetryTest;
import core.support.listeners.TestListener;
import core.support.listeners.TestResultListener;
import core.support.logger.ExtentManager;
import core.support.logger.TestLog;
import core.support.objects.DriverObject;
import core.support.objects.ServiceObject;
import core.support.objects.TestObject;
import core.uiCore.WebDriverSetup;
import core.uiCore.driverProperties.capabilities.AndroidCapability;
import core.uiCore.driverProperties.capabilities.WebCapability;
import core.uiCore.driverProperties.driverType;
import core.uiCore.driverProperties.globalProperties.CrossPlatformProperties;
import core.uiCore.drivers.AbstractDriver;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.openqa.selenium.WebDriver;
import org.testng.ITest;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Listeners;
import org.testng.internal.BaseTestMethod;

@Listeners(value={TestListener.class, TestResultListener.class})
public class AbstractDriverTestNG
implements ITest {
    public static ExtentReports extent;
    public static ThreadLocal<ExtentTest> step;
    private static ThreadLocal<WebDriver> webDriver;
    public static ThreadLocal<String> testClassname;
    public static ThreadLocal<String> testName;
    public RetryTest retry = new RetryTest();

    public void setupApiDriver(ServiceObject apiObject) throws Exception {
        Logger log;
        new ApiTestDriver().initTest(apiObject);
        TestObject.getTestInfo().log = log = Logger.getLogger((String)"");
        ExtentManager.reportSetup();
    }

    public static WebDriver setupWebDriver(DriverObject driverObject) throws Exception {
        boolean condition3;
        AbstractDriverTestNG.initTest(driverObject);
        ExtentManager.reportSetup();
        TestLog.ConsoleLogDebug("driverObject.driverType: " + (Object)((Object)driverObject.driverType), new Object[0]);
        if (driverObject.driverType != null && driverObject.driverType.equals((Object)driverType.DriverType.API)) {
            return null;
        }
        AbstractDriverTestNG.setWebDriver(DriverObject.getFirstAvailableDriver());
        TestLog.ConsoleLogDebug("isForcedRestart: " + TestObject.getTestInfo().isForcedRestart + " isSingleSignIn(): " + CrossPlatformProperties.isSingleSignIn() + " webDriver: " + AbstractDriver.getWebDriver(), new Object[0]);
        boolean condition1 = TestObject.getTestInfo().isForcedRestart != false && CrossPlatformProperties.isSingleSignIn() != false;
        boolean condition2 = CrossPlatformProperties.isSingleSignIn() == false;
        boolean bl = condition3 = AbstractDriver.getWebDriver() == null;
        if (condition1 || condition2 || condition3) {
            AbstractDriverTestNG.setWebDriver(AbstractDriverTestNG.createDriver(driverObject));
            driverObject.withIsAvailable(false);
            DriverObject.initializeDriverList(driverObject, TestObject.getTestInfo().testId);
            TestObject.getTestInfo().withIsFirstRun(true);
        }
        TestObject.getTestInfo().withWebDriver(AbstractDriver.getWebDriver());
        AbstractDriverTestNG.getURL(driverObject.initialURL);
        AbstractDriverTestNG.setFullScreen();
        return AbstractDriver.getWebDriver();
    }

    public void setupWebDriver(String testId, DriverObject driver) {
        TestObject.setTestId(testId);
        try {
            AbstractDriverTestNG.setupWebDriver(driver);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void setFullScreen() {
        if (!Helper.mobile.isMobile() && Config.getValue("web.maximizeBrowser").equals("true")) {
            Helper.page.maximizePage();
        }
    }

    public static void initTest(DriverObject driverObject) {
        String testId = TestObject.getTestId();
        TestLog.removeLogUtilHandler();
        TestObject.initializeTest(driverObject, testId);
        TestObject.setLogging();
        TestObject.getTestInfo().withCurrentDriver(driverObject);
        DriverObject.initializeDriverList(driverObject, testId);
    }

    public static void setWebDriver(WebDriver webDriver) {
        AbstractDriverTestNG.webDriver.set(webDriver);
    }

    @BeforeMethod(alwaysRun=true)
    public synchronized void handleTestMethodName(Method method, ITestResult iTestResult, Object[] testData) {
        TestObject.setTestName(method.getName());
        TestObject.setTestId(this.getClassName(), TestObject.currentTestName.get());
        ApiTestDriver.setServiceTestName(testData);
        this.setAndIncremenetDataProviderTestExtention(method, testData);
        this.setUiTestname(method, testData);
        DriverObject driver = new DriverObject().withDriverType(driverType.DriverType.API);
        new AbstractDriverTestNG().setupWebDriver(TestObject.getTestId(), driver);
        this.setResultTestName(testData, iTestResult);
    }

    public void setResultTestName(Object[] testData, ITestResult result) {
        if (!ApiTestDriver.isRunningServiceTest(testData)) {
            return;
        }
        try {
            Field methodName = BaseTestMethod.class.getDeclaredField("m_methodName");
            methodName.setAccessible(true);
            methodName.set(result.getMethod(), testName.get());
        }
        catch (Exception e) {
            e.printStackTrace();
            Reporter.log((String)("Exception : " + e.getMessage()));
        }
    }

    private void setAndIncremenetDataProviderTestExtention(Method method, Object[] testData) {
        if (ApiTestDriver.isRunningServiceTest(testData)) {
            return;
        }
        if (this.isDataProviderRunning(method)) {
            int invocationCount = TestObject.getTestInvocationCount(TestObject.getTestId());
            TestObject.setTestName(method.getName() + TestObject.DATAPROVIDER_TEST_SUFFIX + ++invocationCount);
            TestObject.setTestId(this.getClassName(), TestObject.currentTestName.get());
            testName.set(TestObject.getTestId());
        }
    }

    private void setUiTestname(Method method, Object[] testData) {
        if (ApiTestDriver.isRunningServiceTest(testData)) {
            return;
        }
        if (this.isDataProviderRunning(method)) {
            return;
        }
        testName.set(TestObject.getTestId());
    }

    private boolean isDataProviderRunning(Method method) {
        return method.getParameterCount() > 0;
    }

    private String getClassName() {
        String className = this.getClass().toString().substring(this.getClass().toString().lastIndexOf(".") + 1);
        testClassname.set(className);
        return className;
    }

    private static WebDriver createDriver(DriverObject driverObject) throws Exception {
        int retry = 3;
        WebDriver driver = null;
        do {
            try {
                --retry;
                driver = new WebDriverSetup().getWebDriverByType(driverObject);
                driver.manage().timeouts().implicitlyWait((long)AbstractDriver.TIMEOUT_IMPLICIT_SECONDS, TimeUnit.SECONDS);
                if (!Helper.mobile.isWebDriver()) continue;
                driver.manage().timeouts().pageLoadTimeout((long)AbstractDriver.TIMEOUT_SECONDS, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                if (retry > 0) {
                    TestLog.ConsoleLog("driver failed to start. retrying " + retry + " more time(s) ...", new Object[0]);
                }
                if (retry == 0) {
                    if (driverObject.driverType.equals((Object)driverType.DriverType.ANDROID_DRIVER)) {
                        AndroidCapability.printAndroidHelp(e);
                    }
                    throw e;
                }
                WebCapability.printWebDriverVersionHelp(e);
                e.printStackTrace();
                Helper.wait.waitForSeconds(3.0);
            }
        } while (driver == null && retry > 0);
        TestLog.ConsoleLog("driver created successfully", new Object[0]);
        Helper.assertTrue("driver was not created", driver != null);
        return driver;
    }

    private static void getURL(String url) {
        if (!url.isEmpty()) {
            TestLog.logPass("I am the site '" + url + "'", new Object[0]);
            AbstractDriverTestNG.getWebDriver().get(url);
        }
    }

    public static WebDriver getWebDriver() {
        return webDriver.get();
    }

    @AfterMethod
    public void shutdown(ITestResult iTestResult) {
        TestLog.printBatchLogsToConsole();
        this.letRetryKnowAboutReports();
        DriverObject.shutDownDriver(iTestResult.isSuccess());
    }

    @AfterClass
    public synchronized void afterClassMethod(ITestContext iTestContext) {
        String name = this.getClassName();
        String testId = name + TestObject.AFTER_CLASS_PREFIX;
        TestLog.printBatchToConsole(testId);
    }

    private void letRetryKnowAboutReports() {
        this.retry.setExtendReport(TestObject.getTestInfo().testScenerio, step.get());
    }

    public String getTestName() {
        if (testName.get() == null) {
            testName.set("");
        }
        return testName.get();
    }

    static {
        step = new ThreadLocal();
        webDriver = new ThreadLocal();
        testClassname = new ThreadLocal();
        testName = new ThreadLocal();
    }
}

