/*
 * Decompiled with CFR 0.152.
 */
package core.support.configReader;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import core.helpers.Helper;
import core.support.configReader.MavenReader;
import core.support.configReader.PropertiesReader;
import core.support.logger.TestLog;
import core.support.objects.ServiceObject;
import core.support.objects.TestObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class Config {
    private static final String CONFIG_GROUP_PREFIX = "config.group.";
    private static final String CONFIG_PROFILE_PREFIX = "config.profile.";
    private static final String CONFIG_PREFIX = "config.";
    private static final String PROFILE_PREFIX = "profile.";
    private static final String GROUP_PREFIX = "profile.group.";
    public static String RESOURCE_PATH = PropertiesReader.getLocalResourcePath();

    private static String getStringProperty(String key, Properties property) {
        if (StringUtils.isNotBlank((String)MavenReader.getStringProperty(key))) {
            return MavenReader.getStringProperty(key);
        }
        if (!PropertiesReader.getStringProperty(key, property).isEmpty()) {
            return PropertiesReader.getStringProperty(key, property);
        }
        return "";
    }

    public static void getAllFiles(File curDir) {
        File[] filesList;
        for (File f : filesList = curDir.listFiles()) {
            if (f.isDirectory()) {
                Config.getAllFiles(f);
            }
            if (!f.isFile()) continue;
            System.out.println("All files: " + f.getPath() + " : " + f.getName());
        }
    }

    public static Map<String, String> getAllKeys(String path) {
        ConcurrentHashMap<String, String> config = new ConcurrentHashMap<String, String>();
        try {
            List<Properties> properties = PropertiesReader.Property(path);
            for (Properties property : properties) {
                for (String key : property.stringPropertyNames()) {
                    String value = Config.getStringProperty(key, property);
                    config.put(key, value);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return config;
    }

    public static void loadConfig(String testId) {
        Map<String, Object> config = Config.loadConfigProperties();
        TestObject.getTestInfo((String)testId).config.putAll(config);
    }

    public static Map<String, Object> loadConfigProperties() {
        ConcurrentHashMap<String, Object> config = new ConcurrentHashMap<String, Object>();
        TestObject.getTestInfo().configKeys = ArrayListMultimap.create();
        Map<String, String> propertiesMap = Config.getAllKeys(RESOURCE_PATH);
        ArrayList<String> configPath = new ArrayList<String>();
        configPath.addAll(Config.getConfigs(propertiesMap));
        configPath.addAll(Config.getConfigProfiles(propertiesMap));
        configPath.addAll(Config.getConfigGroup(propertiesMap));
        for (String path : configPath) {
            propertiesMap = Config.getAllKeys(path);
            config.putAll(propertiesMap);
        }
        Config.checkForDuplicateKeys();
        return config;
    }

    public static List<String> checkForDuplicateKeys() {
        Multimap<String, String> keys = TestObject.getTestInfo().configKeys;
        ArrayList<String> dupicateKeys = new ArrayList<String>();
        Set keySet = keys.keySet();
        for (String key : keySet) {
            Collection values = keys.get((Object)key);
            if (values.size() <= 1) continue;
            dupicateKeys.add(key);
            TestLog.logWarning("Duplicate key found: " + key + " at property files: " + Arrays.toString(values.toArray()), new Object[0]);
        }
        return dupicateKeys;
    }

    public static List<String> getConfigs(Map<String, String> propertiesMap) {
        ArrayList<String> configPath = new ArrayList<String>();
        for (Map.Entry<String, String> entry : propertiesMap.entrySet()) {
            String key = entry.getKey().toString();
            boolean isConfig = key.startsWith(CONFIG_PREFIX) && !key.startsWith(CONFIG_PROFILE_PREFIX) && !key.startsWith(CONFIG_GROUP_PREFIX);
            if (!isConfig) continue;
            configPath.add(entry.getValue());
        }
        return configPath;
    }

    public static List<String> getConfigProfiles(Map<String, String> propertiesMap) {
        ArrayList profiles = new ArrayList();
        ArrayList<String> profilePath = new ArrayList<String>();
        for (Map.Entry<String, String> entry : propertiesMap.entrySet()) {
            boolean isCorrectLength;
            boolean isProfile = entry.getKey().toString().startsWith(PROFILE_PREFIX);
            boolean bl = isCorrectLength = entry.getKey().toString().split("\\.").length == 2;
            if (!isProfile || !isCorrectLength) continue;
            String profile = entry.getKey().split("\\.")[1];
            ArrayList<String> values = new ArrayList<String>(Arrays.asList(entry.getValue().split(",")));
            profiles.addAll(values.stream().map(c -> profile + "." + c).collect(Collectors.toList()));
        }
        for (String profile : profiles) {
            String profileValue = profile.split("\\.")[0];
            String propertyFile = profile.split("\\.")[1];
            if (propertyFile.equals("none")) continue;
            if (propertiesMap.get(CONFIG_PROFILE_PREFIX + profileValue) == null) {
                Helper.assertFalse("profile not found: " + profile + ". Please add profile to properties.property file as profile." + profile);
            }
            String path = propertiesMap.get(CONFIG_PROFILE_PREFIX + profileValue);
            File file = Helper.getFileByName(path, propertyFile);
            profilePath.add(file.getPath());
        }
        return profilePath;
    }

    public static List<String> getConfigGroup(Map<String, String> propertiesMap) {
        ArrayList profiles = new ArrayList();
        ArrayList<String> groupPath = new ArrayList<String>();
        for (Map.Entry<String, String> entry : propertiesMap.entrySet()) {
            boolean isCorrectLength;
            boolean isProfile = entry.getKey().toString().startsWith(GROUP_PREFIX);
            boolean bl = isCorrectLength = entry.getKey().toString().split("\\.").length == 3;
            if (!isProfile || !isCorrectLength) continue;
            String group = entry.getKey().split("\\.")[2];
            ArrayList<String> values = new ArrayList<String>(Arrays.asList(entry.getValue().split(",")));
            profiles.addAll(values.stream().map(c -> group + "." + c).collect(Collectors.toList()));
        }
        for (String profile : profiles) {
            String value = profile.split("\\.")[1];
            if (value.equals("none")) continue;
            if (propertiesMap.get(CONFIG_GROUP_PREFIX + profile) == null) {
                Helper.assertFalse("profile not found: " + profile + ". Please add groups to properties.property file as " + CONFIG_GROUP_PREFIX + profile);
            }
            String path = propertiesMap.get(CONFIG_GROUP_PREFIX + profile);
            groupPath.add(path);
        }
        return groupPath;
    }

    public static String getValue(String key) {
        return Config.getValue(key, false);
    }

    public static String getValue(String key, boolean isFailable) {
        Object value = TestObject.getTestInfo().config.get(key);
        if (value == null) {
            value = MavenReader.getStringProperty(key);
        }
        if (value == null) {
            if (isFailable) {
                Helper.assertFalse("value not found, default empty: " + key);
            }
            TestObject.getTestInfo().missingConfigVars.add(key);
            value = "";
            return value.toString();
        }
        return value.toString();
    }

    public static int getGlobalIntValue(String key) {
        String value = Config.getValue(key, false);
        if (value.isEmpty()) {
            return -1;
        }
        return Integer.valueOf(value);
    }

    public static Object getGlobalObjectValue(String key) {
        if (TestObject.getGlobalTestInfo().config.get(key) == null) {
            return "";
        }
        Object value = TestObject.getTestInfo().config.get(key);
        return value;
    }

    public static Boolean getGlobalBooleanValue(String key) {
        String value = Config.getGlobalValue(key, false);
        if (value.isEmpty()) {
            return false;
        }
        return Boolean.parseBoolean(value);
    }

    public static String getGlobalValue(String key) {
        return Config.getGlobalValue(key, false);
    }

    public static String getGlobalValue(String key, boolean isFailable) {
        Object value = TestObject.getGlobalTestInfo().config.get(key);
        if (value == null) {
            value = MavenReader.getStringProperty(key);
        }
        if (value == null) {
            if (isFailable) {
                Helper.assertFalse("value not found, default empty: " + key);
            }
            value = "";
        }
        return value.toString();
    }

    public static Boolean getBooleanValue(String key) {
        return Config.getBooleanValue(key, false);
    }

    public static Boolean getBooleanValue(String key, boolean isFailable) {
        String value = Config.getValue(key, isFailable);
        if (value.isEmpty()) {
            if (isFailable) {
                Helper.assertFalse("value not found: " + key);
            }
            return false;
        }
        return Boolean.parseBoolean(value);
    }

    public static Object getObjectValue(String key) {
        if (TestObject.getTestInfo().config.get(key) == null) {
            return null;
        }
        Object value = TestObject.getTestInfo().config.get(key);
        return value;
    }

    public static int getIntValue(String key) {
        return Config.getIntValue(key, false);
    }

    public static int getIntValue(String key, boolean isFailable) {
        String value = Config.getValue(key, isFailable);
        if (value.isEmpty()) {
            if (isFailable) {
                Helper.assertFalse("value not found: " + key);
            }
            return -1;
        }
        return Integer.valueOf(value);
    }

    public static double getDoubleValue(String key) {
        return Config.getDoubleValue(key, false);
    }

    public static double getDoubleValue(String key, boolean isFailable) {
        String value = Config.getValue(key, isFailable);
        if (value.isEmpty()) {
            if (isFailable) {
                Helper.assertFalse("value not found: " + key);
            }
            return -1.0;
        }
        return Double.valueOf(value);
    }

    public static ArrayList<String> getValueList(String key) {
        return Config.getValueList(key, true);
    }

    public static ArrayList<String> getValueList(String key, boolean isFailable) {
        String value = Config.getValue(key, isFailable);
        ArrayList<String> items = new ArrayList<String>();
        if (value == null && isFailable) {
            Helper.assertFalse("value not found in config files: " + key);
        }
        if (value != null && !value.isEmpty()) {
            items = new ArrayList<String>(Arrays.asList(value.split(",")));
            items.replaceAll(String::trim);
        }
        return items;
    }

    public static void putValue(String key, Object value) {
        Config.putValue(key, value, true);
    }

    public static void putValue(String key, Object value, boolean isLog) {
        if (isLog) {
            TestLog.logPass("storing in key: " + key + " value: " + value, new Object[0]);
        }
        if (value == null) {
            value = "null";
        }
        TestObject.getTestInfo().config.put(key, value);
    }

    public static void putValue(String key, Object value, String info) {
        TestLog.logPass("storing in key: " + key + " value: " + info, new Object[0]);
        TestObject.getTestInfo().config.put(key, value);
    }

    public static void setParentValue(String key, Object value) {
        ServiceObject service = TestObject.getTestInfo().serviceObject;
        TestObject.getParentTestInfo((ServiceObject)service).config.put(key, value);
    }

    public static void setGlobalValue(String key, Object value) {
        TestLog.logPass("storing in global key: " + key + " value: " + value, new Object[0]);
        TestObject.getGlobalTestInfo().config.put(key, value);
    }

    public static boolean getParentValue(String key) {
        ServiceObject service = TestObject.getTestInfo().serviceObject;
        Object value = TestObject.getParentTestInfo((ServiceObject)service).config.get(key);
        if (value == null) {
            return false;
        }
        return (Boolean)value;
    }

    public static void printMissingConfigVariables() {
        List<String> variables = TestObject.getTestInfo().missingConfigVars;
        if (variables.size() > 0) {
            TestLog.ConsoleLog("List of missing config variables. Please see latest version for updated config: " + StringUtils.join(variables, (String)", "), new Object[0]);
        }
    }
}

