/*
 * Decompiled with CFR 0.152.
 */
package core.helpers;

import core.helpers.Element;
import core.helpers.Helper;
import core.support.logger.TestLog;
import core.support.objects.DriverObject;
import core.uiCore.drivers.AbstractDriver;
import core.uiCore.drivers.AbstractDriverJunit;
import core.uiCore.drivers.AbstractDriverTestNG;
import core.uiCore.webElement.EnhancedBy;
import core.uiCore.webElement.EnhancedWebElement;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.openqa.selenium.Alert;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;

public class PageHelper {
    public void maximizePage() {
        try {
            AbstractDriver.getWebDriver().manage().window().maximize();
        }
        catch (Exception e) {
            TestLog.logWarning("Page was not maximized", new Object[0]);
            this.printStackTrace(e);
        }
    }

    public void setPageSize(int x, int y) {
        Dimension dimension = new Dimension(x, y);
        AbstractDriver.getWebDriver().manage().window().setSize(dimension);
    }

    public void refreshPage() {
        try {
            if (Helper.isWebDriver()) {
                AbstractDriver.getWebDriver().navigate().refresh();
            }
            if (Helper.mobile_isMobile()) {
                Helper.refreshMobileApp();
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
        Helper.wait.waitForSeconds(1.0);
    }

    public void switchIframe(EnhancedBy frame) {
        EnhancedWebElement frameElement = Element.findElements(frame);
        AbstractDriver.getWebDriver().switchTo().defaultContent();
        AbstractDriver.getWebDriver().switchTo().frame(frameElement.get(0));
    }

    public void switchToDefaultFrame() {
        AbstractDriver.getWebDriver().switchTo().defaultContent();
    }

    public static void switchWindowHandle(int index) {
        PageHelper.waitForWindowHandle(index);
        Set handles = Helper.mobile.getAppiumDriver().getWindowHandles();
        ArrayList handleList = new ArrayList(handles);
        Helper.mobile.getAppiumDriver().switchTo().window((String)handleList.get(index));
    }

    private static void waitForWindowHandle(int index) {
        int retryWaitInSeconds = 3;
        Set handles = Helper.mobile.getAppiumDriver().getWindowHandles();
        ArrayList handleList = new ArrayList(handles);
        for (int retry = AbstractDriver.TIMEOUT_SECONDS / retryWaitInSeconds; index >= handleList.size() && retry > 0; --retry) {
            handles = Helper.mobile.getAppiumDriver().getWindowHandles();
            handleList = new ArrayList(handles);
            Helper.waitForSeconds(retryWaitInSeconds);
        }
        if (index >= handleList.size()) {
            Helper.assertFalse("window handle not available. size: " + handleList.size() + "index: " + index);
        }
    }

    public String dimissAlert() {
        String alertText = "";
        try {
            Alert alert = AbstractDriver.getWebDriver().switchTo().alert();
            alertText = alert.getText();
            TestLog.ConsoleLog("dismissed alert", new Object[0]);
            alert.dismiss();
        }
        catch (Exception e) {
            e.getMessage();
        }
        return alertText;
    }

    public String acceptAlert() {
        String alertText = "";
        try {
            Alert alert = AbstractDriver.getWebDriver().switchTo().alert();
            alertText = alert.getText();
            TestLog.ConsoleLog("accepted alert", new Object[0]);
            alert.accept();
        }
        catch (Exception e) {
            e.getMessage();
        }
        return alertText;
    }

    public String getAlertValue() {
        String alertText = "";
        try {
            Alert alert = AbstractDriver.getWebDriver().switchTo().alert();
            alertText = alert.getText();
        }
        catch (Exception e) {
            e.getMessage();
        }
        return alertText;
    }

    public String currentWindow() {
        return AbstractDriver.getWebDriver().getWindowHandle();
    }

    public void switchToNewWindow(String defaultWindow) {
        for (String winHandle : AbstractDriver.getWebDriver().getWindowHandles()) {
            if (winHandle.equals(defaultWindow)) continue;
            AbstractDriver.getWebDriver().switchTo().window(winHandle);
        }
    }

    public void CloseAndReturn(String defaultWindow) {
        AbstractDriver.getWebDriver().close();
        AbstractDriver.getWebDriver().switchTo().window(defaultWindow);
    }

    public void refreshPageSource() {
        AbstractDriver.getWebDriver().getPageSource();
    }

    public void verifyTitle(String appTitle) {
        Helper.assertEquals(AbstractDriver.getWebDriver().getTitle(), appTitle);
    }

    public void switchDriver(WebDriver driver) {
        if (driver.getTitle() != null || !driver.getTitle().isEmpty()) {
            TestLog.logPass("swtiching to " + driver.getTitle(), new Object[0]);
        }
        if (AbstractDriver.isJunit()) {
            AbstractDriverJunit.setWebDriver(driver);
        } else if (AbstractDriver.isTestNG()) {
            AbstractDriverTestNG.setWebDriver(driver);
        }
    }

    public void switchToNextTab() {
        ArrayList tabs = new ArrayList(AbstractDriver.getWebDriver().getWindowHandles());
        int currentIndex = tabs.indexOf(AbstractDriver.getWebDriver().getWindowHandle());
        if (currentIndex == tabs.size() - 1) {
            currentIndex = -1;
        }
        try {
            AbstractDriver.getWebDriver().switchTo().window((String)tabs.get(currentIndex + 1));
        }
        catch (Exception e) {
            Helper.assertFalse("tab does not exist");
        }
    }

    public void switchToPreviousTab() {
        ArrayList tabs = new ArrayList(AbstractDriver.getWebDriver().getWindowHandles());
        int currentIndex = tabs.indexOf(AbstractDriver.getWebDriver().getWindowHandle());
        if (currentIndex == 0) {
            currentIndex = tabs.size();
        }
        try {
            AbstractDriver.getWebDriver().switchTo().window((String)tabs.get(currentIndex - 1));
        }
        catch (Exception e) {
            Helper.assertFalse("tab does not exist");
        }
    }

    public void switchToTab(int index) {
        ArrayList tabs = new ArrayList(AbstractDriver.getWebDriver().getWindowHandles());
        try {
            AbstractDriver.getWebDriver().switchTo().window((String)tabs.get(index));
        }
        catch (Exception e) {
            Helper.assertFalse("tab does not exist");
        }
    }

    public void verifyNumberOfTabs(int tabs) {
        ArrayList tabCount = new ArrayList(AbstractDriver.getWebDriver().getWindowHandles());
        Helper.assertEquals(tabs, tabCount.size());
    }

    public String getPageTitle() {
        if (AbstractDriver.getWebDriver() == null) {
            return "";
        }
        return AbstractDriver.getWebDriver().getTitle();
    }

    public String getCurrentUrl() {
        if (AbstractDriver.getWebDriver() == null) {
            return "";
        }
        return AbstractDriver.getWebDriver().getCurrentUrl();
    }

    public String getPageSource() {
        if (AbstractDriver.getWebDriver() == null) {
            return "";
        }
        return AbstractDriver.getWebDriver().getPageSource();
    }

    public void navigateBack() {
        AbstractDriver.getWebDriver().navigate().back();
    }

    public void navigateForward() {
        AbstractDriver.getWebDriver().navigate().forward();
    }

    public void deleteAllCookies() {
        AbstractDriver.getWebDriver().manage().deleteAllCookies();
    }

    public void deleteCookieNamed(String name) {
        AbstractDriver.getWebDriver().manage().deleteCookieNamed(name);
    }

    public void bringPageToFront() {
        try {
            String currentWindowHandle = AbstractDriver.getWebDriver().getWindowHandle();
            AbstractDriver.getWebDriver().switchTo().window(currentWindowHandle);
        }
        catch (Exception e) {
            e.getMessage();
        }
    }

    public void swtichUrl(String url) {
        this.navigateToUrl(url);
    }

    public void navigateToUrl(String url) {
        int retry = 3;
        boolean success = false;
        do {
            --retry;
            try {
                AbstractDriver.getWebDriver().get(url);
                success = true;
            }
            catch (Exception e) {
                Helper.page.printStackTrace(e);
                TestLog.ConsoleLog("get url failed, retrying: " + url, new Object[0]);
            }
        } while (!success && --retry >= 0);
    }

    public String getClipboardData() {
        String myText = "";
        try {
            myText = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
        }
        catch (Exception e) {
            e.getMessage();
        }
        return myText;
    }

    public void quitCurrentDriver() {
        DriverObject.quitWebDriver(AbstractDriver.getWebDriver());
    }

    public void quitDriver(WebDriver driver) {
        DriverObject.quitWebDriver(driver);
    }

    public void quitAllCurrentTestDrivers() {
        DriverObject.quitTestDrivers();
    }

    public Boolean isVisibleInViewport(EnhancedBy by) {
        return this.isVisibleInViewport(by, 0);
    }

    public Boolean isVisibleInViewport(EnhancedBy by, int index) {
        if (!Helper.isWebDriver()) {
            return false;
        }
        Boolean isVisible = false;
        EnhancedWebElement targetElement = Element.findElements(by);
        try {
            isVisible = (Boolean)((JavascriptExecutor)AbstractDriver.getWebDriver()).executeScript("var elem = arguments[0],                   box = elem.getBoundingClientRect(),      cx = box.left + box.width / 2,           cy = box.top + box.height / 2,           e = document.elementFromPoint(cx, cy); for (; e; e = e.parentElement) {           if (e === elem)                            return true;                         }                                        return false;                            ", new Object[]{targetElement.get(index)});
        }
        catch (StaleElementReferenceException st) {
            st.getMessage();
        }
        catch (Exception e) {
            e.getMessage();
        }
        return isVisible;
    }

    public WebDriver getWebdriver() {
        return AbstractDriver.getWebDriver();
    }

    public void printStackTrace(Throwable throwable) {
        TestLog.ConsoleLog("stack trace: " + Helper.stringNormalize(ExceptionUtils.getStackTrace((Throwable)throwable)), new Object[0]);
    }
}

