/*
 * Decompiled with CFR 0.152.
 */
package core.helpers;

import core.helpers.Helper;
import core.helpers.LoginHelper;
import core.support.objects.ActionObject;
import core.support.objects.DriverObject;
import core.support.objects.LoginObject;
import core.support.objects.TestObject;
import core.support.objects.UserObject;
import core.uiCore.driverProperties.globalProperties.CrossPlatformProperties;
import core.uiCore.drivers.AbstractDriver;
import core.uiCore.webElement.EnhancedBy;
import java.util.List;

public class Loginbuilder {
    public Loginbuilder builder() {
        TestObject.getTestInfo().login = new LoginObject();
        return this;
    }

    public Loginbuilder withUsername(EnhancedBy element, String value) {
        ActionObject action = new ActionObject().withElement1(element).withValue(value).withAction(ActionObject.ACTION.FIELD);
        TestObject.getTestInfo().login.withLoginSequence(action);
        TestObject.getTestInfo().login.withUsername(value);
        return this;
    }

    public Loginbuilder withPassword(EnhancedBy element, String value) {
        ActionObject action = new ActionObject().withElement1(element).withValue(value).withAction(ActionObject.ACTION.FIELD);
        TestObject.getTestInfo().login.withLoginSequence(action);
        TestObject.getTestInfo().login.withPassword(value);
        return this;
    }

    public Loginbuilder withOptionalField(EnhancedBy element, String value) {
        ActionObject action = new ActionObject().withElement1(element).withValue(value).withAction(ActionObject.ACTION.OPTIONAL_FIELD);
        TestObject.getTestInfo().login.withLoginSequence(action);
        return this;
    }

    public Loginbuilder withOptionalSubmit(EnhancedBy element, EnhancedBy expected) {
        ActionObject action = new ActionObject().withElement1(element).withElement2(expected).withAction(ActionObject.ACTION.OPTIONAL_CLICK_AND_EXPECT);
        TestObject.getTestInfo().login.withLoginSequence(action);
        return this;
    }

    public Loginbuilder withFormSubmit(EnhancedBy element, EnhancedBy expected) {
        ActionObject action = new ActionObject().withElement1(element).withElement2(expected).withAction(ActionObject.ACTION.SUBMIT);
        TestObject.getTestInfo().login.withLoginSequence(action);
        return this;
    }

    public Loginbuilder withFormSubmit(EnhancedBy element, EnhancedBy expected, EnhancedBy optionalElemennt) {
        ActionObject action = new ActionObject().withElement1(element).withElement2(expected).withElement3(optionalElemennt).withAction(ActionObject.ACTION.BUTTON_WAIT_FIRST_ELEMENT);
        TestObject.getTestInfo().login.withLoginSequence(action);
        return this;
    }

    public Loginbuilder withSelectNext(EnhancedBy element, EnhancedBy expected) {
        ActionObject action = new ActionObject().withElement1(element).withElement2(expected).withAction(ActionObject.ACTION.BUTTON);
        TestObject.getTestInfo().login.withLoginSequence(action);
        return this;
    }

    public Loginbuilder withOptionalButton(EnhancedBy element) {
        ActionObject action = new ActionObject().withElement1(element).withAction(ActionObject.ACTION.OPTIONAL_BUTTON);
        TestObject.getTestInfo().login.withLoginSequence(action);
        return this;
    }

    public Loginbuilder withSelectButton(EnhancedBy element, EnhancedBy expected) {
        ActionObject action = new ActionObject().withElement1(element).withElement2(expected).withAction(ActionObject.ACTION.BUTTON);
        TestObject.getTestInfo().login.withLoginSequence(action);
        return this;
    }

    public Loginbuilder withSelectButtonAndWaitForFirstElement(EnhancedBy element, EnhancedBy expected, EnhancedBy expected2) {
        ActionObject action = new ActionObject().withElement1(element).withElement2(expected).withElement3(expected2).withAction(ActionObject.ACTION.BUTTON_WAIT_FIRST_ELEMENT);
        TestObject.getTestInfo().login.withLoginSequence(action);
        return this;
    }

    public Loginbuilder withWaitForElement(EnhancedBy element) {
        ActionObject action = new ActionObject().withElement1(element).withAction(ActionObject.ACTION.WAIT_ELEMENT);
        TestObject.getTestInfo().login.withLoginSequence(action);
        return this;
    }

    public Loginbuilder withWaitForEitherElement(EnhancedBy element, EnhancedBy element2) {
        ActionObject action = new ActionObject().withElement1(element).withElement1(element2).withAction(ActionObject.ACTION.WAIT_EITHER_ELEMENT);
        TestObject.getTestInfo().login.withLoginSequence(action);
        return this;
    }

    public Loginbuilder withVerifyError(EnhancedBy element, String error) {
        ActionObject action = new ActionObject().withElement1(element).withValue(error).withAction(ActionObject.ACTION.VERIFY_TEXT);
        TestObject.getTestInfo().login.withLoginSequence(action);
        return this;
    }

    public Loginbuilder withVerifyText(EnhancedBy element, String text) {
        ActionObject action = new ActionObject().withElement1(element).withValue(text).withAction(ActionObject.ACTION.VERIFY_TEXT);
        TestObject.getTestInfo().login.withLoginSequence(action);
        return this;
    }

    public void build(UserObject ... user) {
        if (!this.isSigleSignInLoginRequired(user)) {
            return;
        }
        List<ActionObject> sequence = TestObject.getTestInfo().login.getLoginSequence();
        this.ensurePageLoaded(sequence);
        block12: for (ActionObject action : sequence) {
            switch (action.getAction()) {
                case FIELD: {
                    Helper.form.setField(action.getElement1(), action.getValue());
                    continue block12;
                }
                case OPTIONAL_FIELD: {
                    if (!Helper.isPresent(action.getElement1())) continue block12;
                    Helper.form.setField(action.getElement1(), action.getValue());
                    continue block12;
                }
                case BUTTON: {
                    Helper.click.clickAndExpect(action.getElement1(), action.getElement2());
                    continue block12;
                }
                case BUTTON_WAIT_FIRST_ELEMENT: {
                    Helper.click.clickAndExpect(action.getElement1(), 0, action.getElement2(), action.getElement3());
                    continue block12;
                }
                case OPTIONAL_BUTTON: {
                    if (!Helper.isPresent(action.getElement1())) continue block12;
                    Helper.clickAndWait(action.getElement1(), 0.0);
                    continue block12;
                }
                case OPTIONAL_CLICK_AND_EXPECT: {
                    if (!Helper.isPresent(action.getElement1())) continue block12;
                    Helper.form.formSubmitNoRetry(action.getElement1(), action.getElement2());
                    continue block12;
                }
                case SUBMIT: {
                    Helper.form.formSubmitNoRetry(action.getElement1(), action.getElement2());
                    continue block12;
                }
                case WAIT_ELEMENT: {
                    Helper.waitForElementToLoad(action.getElement1());
                    continue block12;
                }
                case WAIT_EITHER_ELEMENT: {
                    Helper.waitForFirstElementToLoad(action.getElement1(), action.getElement2());
                    continue block12;
                }
                case VERIFY_TEXT: {
                    Helper.verifyElementContainingText(action.getElement1(), action.getValue());
                    continue block12;
                }
            }
            Helper.assertFalse("build action is not available: " + action.getAction().name());
        }
    }

    public boolean isSigleSignInLoginRequired(UserObject ... user) {
        if (!DriverObject.isDriverSet()) {
            return true;
        }
        Helper.handleDifferentUser();
        if (DriverObject.getCurrentDriverObject().config.isEmpty()) {
            DriverObject.getCurrentDriverObject().config = TestObject.getTestInfo().config;
        } else {
            TestObject.getTestInfo().config = DriverObject.getCurrentDriverObject().config;
        }
        if (!LoginHelper.isContinueLogin()) {
            return false;
        }
        Loginbuilder.setGlobalUserCredentials();
        return user.length <= 0 || !this.isLoggedIn(user[0]);
    }

    private static void setGlobalUserCredentials() {
        if (!DriverObject.isDriverSet()) {
            return;
        }
        if (!CrossPlatformProperties.isSingleSignIn().booleanValue()) {
            return;
        }
        String username = TestObject.getTestInfo().login.getUsername();
        String password = TestObject.getTestInfo().login.getPassword();
        DriverObject.getCurrentDriverObject().login.withLoggedInUsername(username).withLoggedInPassword(password);
    }

    private void ensurePageLoaded(List<ActionObject> sequence) {
        if (sequence.size() == 0) {
            return;
        }
        int retry = 3;
        EnhancedBy firstElement = sequence.get(0).getElement1();
        do {
            --retry;
            Helper.waitForElementToLoad(firstElement, AbstractDriver.TIMEOUT_SECONDS - 1);
            if (Helper.isPresent(firstElement)) continue;
            Helper.refreshPage();
        } while (!Helper.isPresent(firstElement) && retry > 0);
        if (!Helper.isPresent(firstElement)) {
            Helper.assertFalse("element '" + firstElement.name + "' did not load");
        }
    }

    public boolean isLoggedIn(UserObject user) {
        if (AbstractDriver.getWebDriver() == null) {
            return false;
        }
        return Helper.isDisplayed(user.getSuccessIndicator());
    }
}

