/*
 * Decompiled with CFR 0.152.
 */
package core.apiCore.helpers;

import core.apiCore.helpers.DataHelper;
import core.helpers.Helper;
import core.support.logger.TestLog;
import core.support.objects.KeyValue;
import core.support.objects.ServiceObject;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlHelper {
    public static String convertDocumentToString(Document doc) {
        try {
            StringWriter sw = new StringWriter();
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(new DOMSource(doc), new StreamResult(sw));
            return sw.toString();
        }
        catch (IllegalArgumentException | TransformerException ex) {
            throw new RuntimeException("Error converting to String", ex);
        }
    }

    public static Document convertXmlStringToDocument(String xmlStr) {
        Document doc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(new InputSource(new StringReader(xmlStr)));
            doc.getDocumentElement().normalize();
        }
        catch (Exception e) {
            e.printStackTrace();
            Helper.assertFalse(e.getMessage());
        }
        return doc;
    }

    public static String convertXmlFileToString(Path filePath) {
        Document document = XmlHelper.readFile(filePath.toString());
        return XmlHelper.convertDocumentToString(document);
    }

    public static synchronized Document readFile(String inputFilePath) {
        Document doc = null;
        int retry = 3;
        do {
            try {
                --retry;
                String inputFileContents = new String(Files.readAllBytes(Paths.get(inputFilePath, new String[0])));
                inputFileContents = DataHelper.replaceParameters(inputFileContents);
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                doc = dBuilder.parse(new InputSource(new StringReader(inputFileContents)));
                doc.getDocumentElement().normalize();
            }
            catch (Exception ex) {
                Thread.interrupted();
            }
        } while (doc == null && retry > 0);
        return doc;
    }

    public static String getNodeValue(String xpathString, String xmlString) {
        return XmlHelper.getNodeList(xpathString, xmlString).item(0).getTextContent();
    }

    public static NodeList getNodeList(String xpathString, String xmlString) {
        try {
            Document doc = XmlHelper.convertXmlStringToDocument(xmlString);
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList nodeList = (NodeList)xpath.evaluate(xpathString, doc, XPathConstants.NODESET);
            if (nodeList != null && nodeList.getLength() != 0) {
                return nodeList;
            }
            TestLog.ConsoleLog("No node found for xpath value: {0}", xpathString);
        }
        catch (XPathExpressionException ex) {
            TestLog.logWarning("Exception encountered for xpath value: " + xpathString, ex);
        }
        return null;
    }

    public static String getXpathValueFromJson(String json, String xpath) {
        String value = "";
        String xml = XmlHelper.jsonToXml(json);
        value = XmlHelper.getXpathFromXml(xml, xpath);
        return value;
    }

    public static String getXpathFromXml(String xml, String xpath) {
        ArrayList<String> valueList = new ArrayList<String>();
        Document doc = XmlHelper.convertXmlStringToDocument(xml);
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xpathObject = xPathFactory.newXPath();
        try {
            XPathExpression xPathEnvelopeExpr = xpathObject.compile(xpath);
            Object result = xPathEnvelopeExpr.evaluate(doc, XPathConstants.NODESET);
            NodeList nodes = (NodeList)result;
            valueList = new ArrayList();
            for (int i = 0; i < nodes.getLength(); ++i) {
                valueList.add(nodes.item(i).getTextContent());
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return DataHelper.listToString(valueList);
    }

    public static String jsonToXml(String json) {
        String xml = "";
        try {
            JSONObject jsonObject = new JSONObject(json);
            xml = XML.toString((Object)jsonObject);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return xml;
    }

    public static String getRequestBodyFromXmlTemplate(ServiceObject serviceObject) {
        Path templatePath = DataHelper.getTemplateFilePath(serviceObject.getTemplateFile());
        String xmlFileValue = XmlHelper.convertXmlFileToString(templatePath);
        xmlFileValue = DataHelper.replaceParameters(xmlFileValue);
        if (serviceObject.getRequestBody().isEmpty()) {
            return xmlFileValue;
        }
        return XmlHelper.replaceRequestTagValues(serviceObject);
    }

    public static String replaceTagValue(String xml, String tag, String value, int position) {
        xml = XmlHelper.replaceGroup("<" + tag + ">(.*?)<\\/" + tag + ">", xml, 1, position, value);
        return xml;
    }

    public static String replaceTagValue(String xml, String tag, String value) {
        xml = xml.replaceAll("<" + tag + ">(.*?)<\\/" + tag + ">", "<" + tag + ">" + value + "</" + tag + ">");
        return xml;
    }

    public static String replaceGroup(String regex, String source, int groupToReplace, int groupOccurrence, String replacement) {
        if (groupOccurrence == 0) {
            Helper.assertFalse("position starts at 1");
        }
        Matcher m = Pattern.compile(regex).matcher(source);
        for (int i = 0; i < groupOccurrence; ++i) {
            if (m.find()) continue;
            return source;
        }
        return new StringBuilder(source).replace(m.start(groupToReplace), m.end(groupToReplace), replacement).toString();
    }

    public static String replaceRequestTagValues(ServiceObject serviceObject) {
        String xmlString = DataHelper.getServiceObjectTemplateString(serviceObject);
        Helper.assertTrue("xml string is empty", !xmlString.isEmpty());
        xmlString = DataHelper.replaceParameters(xmlString);
        if (XmlHelper.isValidXmlString(serviceObject.getRequestBody())) {
            return serviceObject.getRequestBody();
        }
        List<KeyValue> keywords = DataHelper.getValidationMap(serviceObject.getRequestBody());
        for (KeyValue keyword : keywords) {
            if (keyword.value.toString().isEmpty()) continue;
            xmlString = XmlHelper.replaceTagValue(xmlString, keyword.key, keyword.value.toString(), Integer.valueOf(keyword.position));
        }
        return xmlString;
    }

    public static String getXmlTagValue(String value, String tag) {
        return XmlHelper.getXmlTagValue(value, tag, 1);
    }

    public static String getXmlTagValue(String source, String tag, int position) {
        ArrayList<String> values = new ArrayList<String>();
        try {
            String patternString = "<" + tag + ">(.*?)<\\/" + tag + ">";
            Pattern pattern = Pattern.compile(patternString);
            Matcher matcher = pattern.matcher(source);
            while (matcher.find()) {
                values.add(matcher.group(1));
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
        if (position == 0) {
            Helper.assertFalse("position starts at 1. your position: " + position + ".");
        }
        if (values.isEmpty()) {
            Helper.assertFalse("tag value: " + tag + " at position: " + position + " was not found at xml: \n" + source + " \n\n");
        }
        if (position > values.size()) {
            Helper.assertFalse("position is greater than response size. position: " + position + ". response size: " + values.size() + ". values: " + Arrays.toString(values.toArray()));
        }
        return (String)values.get(position - 1);
    }

    public static boolean isXmlFile(String filename) {
        return filename.toLowerCase().endsWith("xml");
    }

    public static boolean isValidXmlString(String xmlString) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setValidating(false);
            dbFactory.setSchema(null);
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            dBuilder.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                }

                @Override
                public void error(SAXParseException exception) throws SAXException {
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                }
            });
            dBuilder.parse(new InputSource(new StringReader(xmlString)));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String prettyFormat(String input, int indent) {
        try {
            StreamSource xmlInput = new StreamSource(new StringReader(input));
            StringWriter stringWriter = new StringWriter();
            StreamResult xmlOutput = new StreamResult(stringWriter);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", indent);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(xmlInput, xmlOutput);
            return xmlOutput.getWriter().toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String removeXmlNameSpace(String xmlString) {
        Document doc = XmlHelper.convertXmlStringToDocument(xmlString);
        Document updateDoc = XmlHelper.cleanNameSpace(doc);
        String xmlNoNameSpace = XmlHelper.convertDocumentToString(updateDoc);
        return xmlNoNameSpace;
    }

    public static Document cleanNameSpace(Document doc) {
        NodeList list = doc.getChildNodes();
        ArrayList<String> namespaces = new ArrayList<String>();
        for (int i = 0; i < list.getLength(); ++i) {
            XmlHelper.removeNamSpace(list.item(i), "", namespaces);
        }
        return doc;
    }

    private static void removeNamSpace(Node node, String nameSpaceURI, List<String> namespaces) {
        if (node.getNodeType() == 1) {
            int i;
            Document doc = node.getOwnerDocument();
            NamedNodeMap map = node.getAttributes();
            namespaces = XmlHelper.getXmlNamespaceTags(map, namespaces);
            ArrayList<Node> nodeList = new ArrayList<Node>();
            block0: for (i = 0; i < map.getLength(); ++i) {
                Node n = map.item(i);
                if (n.getNodeName() == null) continue;
                if (n.getNodeName().contains("xmlns")) {
                    nodeList.add(n);
                    continue;
                }
                for (String namespace : namespaces) {
                    if (!n.getNodeName().contains(namespace + ":")) continue;
                    nodeList.add(n);
                    continue block0;
                }
            }
            for (i = 0; i < nodeList.size(); ++i) {
                map.removeNamedItemNS(((Node)nodeList.get(i)).getNamespaceURI(), ((Node)nodeList.get(i)).getLocalName());
            }
            doc.renameNode(node, nameSpaceURI, node.getLocalName());
        }
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            XmlHelper.removeNamSpace(list.item(i), nameSpaceURI, namespaces);
        }
    }

    private static List<String> getXmlNamespaceTags(NamedNodeMap map, List<String> namespaces) {
        for (int i = 0; i < map.getLength(); ++i) {
            String[] namespaceArray;
            Node n = map.item(i);
            if (n.getNodeName() == null || !n.getNodeName().contains("xmlns") || (namespaceArray = n.getNodeName().split(":")).length != 2) continue;
            namespaces.add(namespaceArray[1]);
        }
        return namespaces;
    }
}

