/*
 * Decompiled with CFR 0.152.
 */
package core.support.objects;

import com.aventstack.extentreports.ExtentTest;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import core.apiCore.helpers.CsvReader;
import core.helpers.Helper;
import core.support.configReader.Config;
import core.support.logger.LogObject;
import core.support.objects.DriverObject;
import core.support.objects.LoginObject;
import core.support.objects.ServiceObject;
import core.uiCore.driverProperties.driverType;
import core.uiCore.drivers.AbstractDriver;
import core.uiCore.drivers.AbstractDriverTestNG;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.junit.runner.Description;
import org.monte.screenrecorder.ScreenRecorder;
import org.openqa.selenium.WebDriver;

public class TestObject {
    public static final String PROXY_ENABLED = "proxy.enabled";
    public static final String PROXY_HOST = "proxy.host";
    public static final String PROXY_PORT = "proxy.port";
    public static final String PROXY_USER = "proxy.username";
    public static final String PROXY_PASS = "proxy.password";
    public static final String PROXY_PROTOCOL = "proxy.maven.protocol";
    public static final String PROXY_AUTO_DETECT = "proxy.auto.detect";
    public static String BEFORE_SUITE_PREFIX = "-Beforesuite";
    public static String AFTER_SUITE_PREFIX = "-Aftersuite";
    public static String BEFORE_CLASS_PREFIX = "-Beforeclass";
    public static String AFTER_CLASS_PREFIX = "-Afterclass";
    public static String BEFORE_METHOD_PREFIX = "-Beforemethod";
    public static String BEFORE_TEST_FILE_PREFIX = "-BeforeTestFile";
    public static String AFTER_TEST_FILE_PREFIX = "-AfterTestFile";
    public static String PARENT_PREFIX = "-Parent";
    public static String DATAPROVIDER_TEST_SUFFIX = "-test";
    public static final String DEFAULT_TEST = "Autonomx-default";
    public static final String DEFAULT_TEST_THREAD_PREFIX = "Runner";
    public static final String RANDOM_STRING = "_randomString_";
    public static final String START_TIME_STRING = "_startTimeString_";
    public static final String DEFAULT_APP = "auto";
    public static String SUITE_NAME = "";
    public static String APP_IDENTIFIER = "";
    public static final String TEST_APP_API = "api";
    public List<WebDriver> webDriverList = new ArrayList<WebDriver>();
    public String app = "";
    public testType type;
    public String testId = "";
    public String testName = "";
    public String className = "";
    public String deviceName = "";
    public String testFileClassName;
    public DriverObject currentDriver;
    public Boolean isFirstRun = false;
    public Boolean isForcedRestart = false;
    public LoginObject login = new LoginObject();
    public int runCount = 0;
    public Boolean isTestPass = false;
    public Boolean isTestComplete = false;
    public Logger log;
    public int currentTestIndex = 0;
    public int testCountInCsvFile = 0;
    public String testCsvFileName = "";
    public ServiceObject serviceObject = new ServiceObject();
    public Description description;
    public Throwable caughtThrowable = null;
    public ArrayList<String> failTrace = new ArrayList();
    public ExtentTest testFeature;
    public ExtentTest testScenerio;
    public List<ExtentTest> testSteps = new ArrayList<ExtentTest>();
    public List<String> testSubSteps = new ArrayList<String>();
    public List<String> missingConfigVars = new ArrayList<String>();
    public ScreenRecorder screenRecorder = null;
    public List<LogObject> testLog = new ArrayList<LogObject>();
    public Map<String, String> languageMap = new ConcurrentHashMap<String, String>();
    public Map<String, ServiceObject> apiMap = new ConcurrentHashMap<String, ServiceObject>();
    public Map<String, Object> config = new ConcurrentHashMap<String, Object>();
    public Multimap<String, String> configKeys = ArrayListMultimap.create();
    public List<TestObject> testObjects = new ArrayList<TestObject>();
    public Map<String, Object> replacedValues = new ConcurrentHashMap<String, Object>();
    public static ThreadLocal<String> currentTestName = new ThreadLocal();
    public static ThreadLocal<String> currentTestId = new ThreadLocal();
    public String language;
    public static Map<String, TestObject> testInfo = new ConcurrentHashMap<String, TestObject>();

    public TestObject withWebDriver(WebDriver webdriver) {
        this.webDriverList.add(webdriver);
        return this;
    }

    public static void initializeTest(String testId) {
        DriverObject driver = new DriverObject().withApp(TEST_APP_API);
        TestObject.initializeTest(driver, testId);
    }

    public static void initializeTest(DriverObject driver, String testId) {
        if (TestObject.isBeforeTest(testId)) {
            TestObject test = new TestObject();
            test = TestObject.inheritParent(driver, testId);
            test.withTestId(testId).withTestName(test.getTestName());
            testInfo.put(testId, test);
            TestObject.setLogging();
            if (test.config.isEmpty()) {
                Config.loadConfig(testId);
            }
            String timeInstance = Helper.date.getTimeInstance();
            Config.putValue(RANDOM_STRING, (Object)Helper.generateRandomString(30), false);
            Config.putValue(START_TIME_STRING, (Object)timeInstance, false);
            CsvReader.getAllKeywords();
            TestObject.getTestInfo().type = testType.uiTest;
        }
    }

    public static TestObject inheritParent(DriverObject driver, String testId) {
        TestObject test = new TestObject();
        Map<String, Object> configValue = TestObject.getTestObjectInheritence((DriverObject)driver, (String)testId).config;
        test.config.putAll(configValue);
        return test;
    }

    public static TestObject getTestObjectInheritence(DriverObject driver, String testId) {
        testState testObjectState = TestObject.getTestState(testId);
        if (testObjectState.equals((Object)testState.beforeSuite)) {
            return new TestObject();
        }
        String[] testValues = testId.split("-");
        String testName = testValues[0];
        testId = testId.toLowerCase();
        String testClassname = AbstractDriverTestNG.testClassname.get();
        if (driver.app.equals(TEST_APP_API) && !testId.contains(BEFORE_METHOD_PREFIX)) {
            return new TestObject();
        }
        if (testId.equals(DEFAULT_TEST.toLowerCase())) {
            return new TestObject();
        }
        if (testId.contains(BEFORE_CLASS_PREFIX.toLowerCase())) {
            return TestObject.getTestInfo(SUITE_NAME + BEFORE_SUITE_PREFIX);
        }
        if (testObjectState.equals((Object)testState.testMethod)) {
            return TestObject.getTestInfo(testName + BEFORE_CLASS_PREFIX);
        }
        if (testObjectState.equals((Object)testState.parent)) {
            return TestObject.getTestInfo(testClassname + BEFORE_CLASS_PREFIX);
        }
        if (testId.contains(AFTER_CLASS_PREFIX.toLowerCase())) {
            return TestObject.getTestInfo(testName + BEFORE_CLASS_PREFIX);
        }
        if (testId.contains(AFTER_SUITE_PREFIX.toLowerCase())) {
            return TestObject.getTestInfo(SUITE_NAME + BEFORE_SUITE_PREFIX);
        }
        return new TestObject();
    }

    public static boolean isFirstRun() {
        if (AbstractDriver.getWebDriver() == null) {
            return true;
        }
        return TestObject.getTestInfo().isFirstRun != false;
    }

    public static TestObject getTestInfo() {
        String testId = TestObject.getTestId();
        if (testInfo.get(testId) == null) {
            return TestObject.getGlobalTestInfo();
        }
        return testInfo.get(testId);
    }

    public static TestObject getGlobalTestInfo() {
        String testId = TestObject.getDefaultTestObjectId();
        if (testInfo.get(testId) == null) {
            TestObject.setupDefaultDriver();
        }
        return testInfo.get(testId);
    }

    public static TestObject getParentTestInfo(ServiceObject serviceObject) {
        String parent = serviceObject.getParent();
        if (testInfo.get(parent) == null) {
            Helper.assertFalse("parent id not found: " + parent);
        }
        return testInfo.get(parent);
    }

    public static void setupDefaultDriver() {
        DriverObject driver = new DriverObject().withDriverType(driverType.DriverType.API).withApp(DEFAULT_TEST);
        new AbstractDriverTestNG().setupWebDriver(TestObject.getDefaultTestObjectId(), driver);
    }

    public static void updateAppName(DriverObject driver) {
        String defaultTest = TestObject.getDefaultTestObjectId();
        if (TestObject.getTestInfo((String)defaultTest).app.equals(DEFAULT_APP)) {
            TestObject.getTestInfo(defaultTest).withApp(driver.app);
        }
    }

    public static testState getTestState(String testName) {
        if ((testName = testName.toLowerCase()).contains(PARENT_PREFIX.toLowerCase())) {
            return testState.parent;
        }
        if (testName.contains(BEFORE_SUITE_PREFIX.toLowerCase())) {
            return testState.beforeSuite;
        }
        if (testName.contains(AFTER_SUITE_PREFIX.toLowerCase())) {
            return testState.suite;
        }
        if (testName.contains(BEFORE_CLASS_PREFIX.toLowerCase()) || testName.contains(AFTER_CLASS_PREFIX.toLowerCase())) {
            return testState.testClass;
        }
        if (testName.equals(DEFAULT_TEST.toLowerCase())) {
            return testState.defaultState;
        }
        return testState.testMethod;
    }

    public static void setTestName(String testName) {
        currentTestName.set(testName);
    }

    public static void setTestId(String testId) {
        currentTestId.set(testId);
    }

    public static void setTestId(String testclass, String testname) {
        currentTestId.set(testclass + "-" + testname);
    }

    public static String getTestId() {
        String testId = currentTestId.get();
        if (testId == null || testId.isEmpty()) {
            testId = TestObject.getDefaultTestObjectId();
        }
        return testId;
    }

    public static boolean isTestObjectSet(String testId) {
        return testInfo.get(testId) != null;
    }

    public static boolean isTestObjectSet() {
        String testId = currentTestId.get();
        if (testInfo.isEmpty()) {
            return false;
        }
        return testId != null && testInfo.get(testId) != null;
    }

    public static boolean hasTestStarted() {
        String testId = TestObject.getTestId();
        if (testId != null && testId.contains("-")) {
            return true;
        }
        if (testId == null || testInfo.get(testId) == null) {
            return false;
        }
        return TestObject.getTestInfo().testCountInCsvFile > 0;
    }

    public static void setLogging() {
        Logger log;
        TestObject.getTestInfo().log = log = Logger.getLogger((String)"");
    }

    public static TestObject getTestInfo(String testId) {
        TestObject test = testInfo.get(testId);
        Helper.assertTrue("test id not found. testId: " + testId + " testInfo: " + testInfo.toString(), test != null);
        return test;
    }

    public static boolean isBeforeTest(String testId) {
        TestObject test = testInfo.get(testId);
        return test == null;
    }

    public static boolean isValidTestId(String testId) {
        TestObject test = testInfo.get(testId);
        return test != null;
    }

    public static int getTestInvocationCount(String testname) {
        String tempTestname = testname;
        int invocationCount = 0;
        while (TestObject.isTestObjectSet(tempTestname = testname + DATAPROVIDER_TEST_SUFFIX + ++invocationCount)) {
        }
        return --invocationCount;
    }

    public static ServiceObject getApiDef(String key) {
        CsvReader.getAllKeywords();
        return TestObject.getTestInfo().apiMap.get(key);
    }

    public TestObject withIsFirstRun(Boolean isFirstRun) {
        this.isFirstRun = isFirstRun;
        return this;
    }

    public TestObject withIsForcedRestart(Boolean isForcedRestart) {
        this.isForcedRestart = isForcedRestart;
        return this;
    }

    public TestObject withCurrentDriver(DriverObject currentDriver) {
        this.currentDriver = currentDriver;
        return this;
    }

    public TestObject withTestId(String testId) {
        this.testId = testId;
        this.className = testId.contains("-") ? testId.split("-")[0] : testId;
        return this;
    }

    public TestObject withTestName(String testName) {
        this.testName = testName;
        return this;
    }

    public TestObject withClassName(String className) {
        this.className = className;
        return this;
    }

    public TestObject withIsTestComplete(boolean isTestComplete) {
        this.isTestComplete = isTestComplete;
        return this;
    }

    public TestObject withTestFileClassName(String testFileClassName) {
        this.testFileClassName = testFileClassName;
        return this;
    }

    public TestObject withWebDriverList(List<WebDriver> webDriverList) {
        this.webDriverList = webDriverList;
        return this;
    }

    public String getTestName() {
        String testName = this.testId.substring(this.testId.indexOf("-") + 1);
        return testName;
    }

    public String getClassName() {
        String className = this.testId.split("-")[0];
        return className;
    }

    public TestObject withRunCount(int rerunCount) {
        this.runCount = rerunCount;
        return this;
    }

    public TestObject withLog(Logger log) {
        this.log = log;
        return this;
    }

    public TestObject incremenetRunCount() {
        ++this.runCount;
        return this;
    }

    public TestObject withIsTestPass(Boolean isTestPass) {
        this.isTestPass = isTestPass;
        return this;
    }

    public TestObject withDescription(Description description) {
        this.description = description;
        return this;
    }

    public TestObject withCaughtThrowable(Throwable caughtThrowable) {
        this.caughtThrowable = caughtThrowable;
        return this;
    }

    public TestObject withFailTrace(ArrayList<String> failTrace) {
        this.failTrace = failTrace;
        return this;
    }

    public TestObject withTestScenario(ExtentTest testScenerio) {
        this.testScenerio = testScenerio;
        return this;
    }

    public TestObject withApp(String app) {
        this.app = app;
        return this;
    }

    public static String getDefaultTestObjectId() {
        return DEFAULT_TEST;
    }

    public static enum testState {
        parent,
        beforeSuite,
        suite,
        testClass,
        testMethod,
        apiTestMethod,
        defaultState;

    }

    public static enum testType {
        service,
        uiTest;

    }
}

