/*
 * Decompiled with CFR 0.152.
 */
package core.support.listeners;

import core.support.logger.TestLog;
import java.util.Iterator;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.testng.TestListenerAdapter;

public class TestResultListener
extends TestListenerAdapter {
    public void onConfigurationFailure(ITestResult result) {
        result.setStatus(3);
        Reporter.setCurrentTestResult((ITestResult)result);
        TestLog.ConsoleLog(ExceptionUtils.getStackTrace((Throwable)result.getThrowable()), new Object[0]);
    }

    public void onFinish(ITestContext context) {
        Iterator failedTestCases = context.getSkippedTests().getAllResults().iterator();
        while (failedTestCases.hasNext()) {
            ITestResult failedTestCase = (ITestResult)failedTestCases.next();
            ITestNGMethod method = failedTestCase.getMethod();
            if (context.getFailedTests().getResults(method).size() > 1) {
                System.out.println("skipped test case remove from report:" + failedTestCase.getTestClass().toString());
                failedTestCases.remove();
                continue;
            }
            if (context.getPassedTests().getResults(method).size() <= 0) continue;
            System.out.println("skipped retries removed from passing test:" + failedTestCase.getTestClass().toString());
            failedTestCases.remove();
        }
    }
}

